/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ObjectNode;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.openapi.util.objectTree.ObjectTreeListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.Equality;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectTree<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectTree");
    private final List<ObjectTreeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Set<T> myRootObjects = ContainerUtil.newIdentityTroveSet();
    private final Map<T, ObjectNode<T>> myObject2NodeMap = ContainerUtil.newIdentityTroveMap();
    private final List<ObjectNode<T>> myExecutedNodes = new ArrayList<ObjectNode<T>>();
    private final List<T> myExecutedUnregisteredNodes = new ArrayList<T>();
    final Object treeLock = new Object();
    private long myModification;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectNode<T> getNode(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.getNode must not be null");
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            return this.myObject2NodeMap.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectNode<T> putNode(@NotNull T object, @Nullable(value="null means remove") ObjectNode<T> node) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.putNode must not be null");
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            return node == null ? this.myObject2NodeMap.remove(object) : this.myObject2NodeMap.put(object, node);
        }
    }

    public final List<ObjectNode<T>> getNodesInExecution() {
        return this.myExecutedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(@NotNull T parent, @NotNull T child) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.register must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.register must not be null");
        }
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode<T> parentNode = this.getOrCreateNodeFor(parent, null);
            ObjectNode<T> childNode = this.getNode(child);
            if (childNode == null) {
                childNode = this.createNodeFor(child, parentNode, Disposer.isDebugMode() ? new Throwable() : null);
            } else {
                ObjectNode<T> oldParent = childNode.getParent();
                if (oldParent != null) {
                    oldParent.removeChild(childNode);
                }
            }
            this.myRootObjects.remove(child);
            this.checkWasNotAddedAlready(childNode, child);
            parentNode.addChild(childNode);
            this.fireRegistered(childNode.getObject());
        }
    }

    private void checkWasNotAddedAlready(@NotNull ObjectNode<T> childNode, @NotNull T child) {
        boolean childIsInTree;
        if (childNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.checkWasNotAddedAlready must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.checkWasNotAddedAlready must not be null");
        }
        ObjectNode<T> parent = childNode.getParent();
        boolean bl = childIsInTree = parent != null;
        if (!childIsInTree) {
            return;
        }
        while (parent != null) {
            if (parent.getObject() == child) {
                LOG.error(child + " was already added as a child of: " + parent);
            }
            parent = parent.getParent();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private ObjectNode<T> getOrCreateNodeFor(@NotNull T object, @Nullable ObjectNode<T> defaultParent) {
        ObjectNode<T> objectNode;
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.getOrCreateNodeFor must not be null");
        }
        ObjectNode<T> node = this.getNode(object);
        if (node != null) {
            objectNode = node;
            if (objectNode == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/objectTree/ObjectTree.getOrCreateNodeFor must not return null");
            return objectNode;
        }
        objectNode = this.createNodeFor(object, defaultParent, Disposer.isDebugMode() ? new Throwable() : null);
        if (objectNode != null) return objectNode;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/objectTree/ObjectTree.getOrCreateNodeFor must not return null");
    }

    @NotNull
    private ObjectNode<T> createNodeFor(@NotNull T object, @Nullable ObjectNode<T> parentNode, @Nullable Throwable trace) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.createNodeFor must not be null");
        }
        ObjectNode<T> newNode = new ObjectNode<T>(this, parentNode, object, this.getNextModification(), trace);
        if (parentNode == null) {
            this.myRootObjects.add(object);
        }
        this.putNode(object, newNode);
        ObjectNode<T> objectNode = newNode;
        if (objectNode == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/objectTree/ObjectTree.createNodeFor must not return null");
        }
        return objectNode;
    }

    public long getNextModification() {
        return ++this.myModification;
    }

    public final boolean executeAll(@NotNull T object, boolean disposeTree, @NotNull ObjectTreeAction<T> action, boolean processUnregistered) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.executeAll must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.executeAll must not be null");
        }
        ObjectNode<T> node = this.getNode(object);
        if (node == null) {
            if (processUnregistered) {
                this.executeUnregistered(object, action);
                return true;
            }
            return false;
        }
        node.execute(disposeTree, action);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> void executeActionWithRecursiveGuard(@NotNull T object, @NotNull List<T> recursiveGuard, @NotNull ObjectTreeAction<T> action) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.executeActionWithRecursiveGuard must not be null");
        }
        if (recursiveGuard == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.executeActionWithRecursiveGuard must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.executeActionWithRecursiveGuard must not be null");
        }
        List<T> list = recursiveGuard;
        synchronized (list) {
            if (ArrayUtil.indexOf(recursiveGuard, object, Equality.IDENTITY) != -1) {
                return;
            }
            recursiveGuard.add(object);
        }
        try {
            action.execute(object);
        }
        finally {
            list = recursiveGuard;
            synchronized (list) {
                int i = ArrayUtil.indexOf(recursiveGuard, object, Equality.IDENTITY);
                assert (i != -1);
                recursiveGuard.remove(i);
            }
        }
    }

    private void executeUnregistered(@NotNull T object, @NotNull ObjectTreeAction<T> action) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.executeUnregistered must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.executeUnregistered must not be null");
        }
        ObjectTree.executeActionWithRecursiveGuard(object, this.myExecutedUnregisteredNodes, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRootObject(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.removeRootObject must not be null");
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            this.myRootObjects.remove(object);
        }
    }

    void fireRegistered(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.fireRegistered must not be null");
        }
        for (ObjectTreeListener each : this.myListeners) {
            each.objectRegistered(object);
        }
    }

    void fireExecuted(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.fireExecuted must not be null");
        }
        for (ObjectTreeListener each : this.myListeners) {
            each.objectExecuted(object);
        }
    }
}

