/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.io.IOUtil;
import com.intellij.util.text.Matcher;
import java.util.BitSet;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinusculeMatcher
implements Matcher {
    private ThreadLocal<MatchingState> myMatchingState;
    private final char[] myPattern;
    private final NameUtil.MatchingCaseSensitivity myOptions;
    private final boolean myHasHumps;
    private final boolean myHasDots;
    private final boolean[] isLowerCase;
    private final boolean[] isUpperCase;
    private final boolean[] isWordSeparator;
    private final char[] toUpperCase;
    private final char[] toLowerCase;
    private final boolean myHasWildCards;

    public MinusculeMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/MinusculeMatcher.<init> must not be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/codeStyle/MinusculeMatcher.<init> must not be null");
        }
        this.myMatchingState = new ThreadLocal<MatchingState>(){

            @Override
            protected MatchingState initialValue() {
                return new MatchingState();
            }
        };
        this.myOptions = options;
        this.myPattern = StringUtil.trimEnd(pattern, "* ").toCharArray();
        this.isLowerCase = new boolean[this.myPattern.length];
        this.isUpperCase = new boolean[this.myPattern.length];
        this.isWordSeparator = new boolean[this.myPattern.length];
        this.toUpperCase = new char[this.myPattern.length];
        this.toLowerCase = new char[this.myPattern.length];
        for (int k = 0; k < this.myPattern.length; ++k) {
            char c = this.myPattern[k];
            this.isLowerCase[k] = Character.isLowerCase(c);
            this.isUpperCase[k] = Character.isUpperCase(c);
            this.isWordSeparator[k] = NameUtil.isWordSeparator(c);
            this.toUpperCase[k] = StringUtil.toUpperCase(c);
            this.toLowerCase[k] = StringUtil.toLowerCase(c);
        }
        int i = 0;
        while (this.isWildcard(i)) {
            ++i;
        }
        this.myHasHumps = this.hasFlag(i + 1, this.isUpperCase) && this.hasFlag(i, this.isLowerCase);
        this.myHasDots = this.hasDots(i);
        this.myHasWildCards = this.hasWildCards();
    }

    private boolean hasWildCards() {
        for (int i = 0; i < this.myPattern.length; ++i) {
            if (!this.isWildcard(i)) continue;
            return true;
        }
        return false;
    }

    private boolean hasFlag(int start, boolean[] flags) {
        for (int i = start; i < this.myPattern.length; ++i) {
            if (!flags[i]) continue;
            return true;
        }
        return false;
    }

    private boolean hasDots(int start) {
        for (int i = start; i < this.myPattern.length; ++i) {
            if (this.myPattern[i] != '.') continue;
            return true;
        }
        return false;
    }

    private static FList<TextRange> prependRange(@NotNull FList<TextRange> ranges, int from, int length) {
        if (ranges == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/MinusculeMatcher.prependRange must not be null");
        }
        TextRange head = ranges.getHead();
        if (head != null && head.getStartOffset() == from + length) {
            return ranges.getTail().prepend(new TextRange(from, head.getEndOffset()));
        }
        return ranges.prepend(TextRange.from(from, length));
    }

    public int matchingDegree(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/MinusculeMatcher.matchingDegree must not be null");
        }
        FList<TextRange> iterable = this.matchingFragments(name);
        if (iterable == null) {
            return Integer.MIN_VALUE;
        }
        if (iterable.isEmpty()) {
            return 0;
        }
        TextRange first = iterable.getHead();
        int matchingCase = 0;
        int p = -1;
        int integral = 0;
        int humpIndex = 1;
        int nextHumpStart = 0;
        block0: for (TextRange range : iterable) {
            for (int i = range.getStartOffset(); i < range.getEndOffset(); ++i) {
                boolean isHumpStart = false;
                while (nextHumpStart <= i) {
                    if (nextHumpStart == i) {
                        isHumpStart = true;
                    }
                    nextHumpStart = NameUtil.nextWord(name, nextHumpStart);
                    if (first == range) continue;
                    ++humpIndex;
                }
                integral += humpIndex;
                char c = name.charAt(i);
                p = StringUtil.indexOf(this.myPattern, c, p + 1, this.myPattern.length, false);
                if (p < 0) continue block0;
                if (c == this.myPattern[p]) {
                    matchingCase += this.isUpperCase[p] ? 50 : (isHumpStart ? 1 : 0);
                    continue;
                }
                if (!isHumpStart) continue;
                matchingCase -= 20;
            }
        }
        int startIndex = first.getStartOffset();
        boolean afterSeparator = StringUtil.indexOfAny(name, " ()", 0, startIndex) >= 0;
        boolean wordStart = startIndex == 0 || NameUtil.isWordStart(name, startIndex) && !NameUtil.isWordStart(name, startIndex - 1);
        return (wordStart ? 1000 : 0) - integral * 10 + matchingCase + (afterSeparator ? 0 : 1);
    }

    public boolean isStartMatch(@NotNull String name) {
        Iterator iterator;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/MinusculeMatcher.isStartMatch must not be null");
        }
        FList<TextRange> fragments = this.matchingFragments(name);
        return fragments != null && (!(iterator = fragments.iterator()).hasNext() || MinusculeMatcher.isStartMatch(name, ((TextRange)iterator.next()).getStartOffset()));
    }

    private static boolean isStartMatch(@NotNull String name, int startIndex) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/MinusculeMatcher.isStartMatch must not be null");
        }
        for (int i = 0; i < startIndex; ++i) {
            if (NameUtil.isWordSeparator(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/MinusculeMatcher.matches must not be null");
        }
        if (!this.myHasWildCards && name.length() < this.myPattern.length) {
            return false;
        }
        return this.matchingFragments(name) != null;
    }

    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/MinusculeMatcher.matchingFragments must not be null");
        }
        MatchingState state = this.myMatchingState.get();
        state.initializeState(name);
        FList<TextRange> result = this.matchWildcards(name, 0, 0, state);
        state.releaseState();
        return result;
    }

    @Nullable
    private FList<TextRange> matchWildcards(@NotNull String name, int patternIndex, int nameIndex, MatchingState matchingState) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/MinusculeMatcher.matchWildcards must not be null");
        }
        if (nameIndex < 0) {
            return null;
        }
        if (!this.isWildcard(patternIndex)) {
            if (patternIndex == this.myPattern.length) {
                return FList.emptyList();
            }
            return this.matchFragment(name, patternIndex, nameIndex, matchingState);
        }
        while (this.isWildcard(++patternIndex)) {
        }
        if (patternIndex == this.myPattern.length) {
            boolean space = this.isPatternChar(patternIndex - 1, ' ');
            if (space && nameIndex != name.length() && (patternIndex < 2 || !NameUtil.isWordStart(this.myPattern[patternIndex - 2]))) {
                return null;
            }
            return FList.emptyList();
        }
        FList<TextRange> ranges = this.matchFragment(name, patternIndex, nameIndex, matchingState);
        if (ranges != null) {
            return ranges;
        }
        return this.matchSkippingWords(name, patternIndex, nameIndex, true, matchingState);
    }

    @Nullable
    private FList<TextRange> matchSkippingWords(@NotNull String name, int patternIndex, int nameIndex, boolean allowSpecialChars, MatchingState matchingState) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/MinusculeMatcher.matchSkippingWords must not be null");
        }
        boolean star = this.isPatternChar(patternIndex - 1, '*');
        char p = this.myPattern[patternIndex];
        while (true) {
            FList<TextRange> ranges;
            int nextOccurrence;
            int n = nextOccurrence = star ? this.indexOfIgnoreCase(name, nameIndex + 1, p, patternIndex, matchingState.isAsciiName) : this.indexOfWordStart(name, patternIndex, nameIndex, matchingState.isAsciiName);
            if (nextOccurrence < 0) {
                return null;
            }
            if (!allowSpecialChars && !this.myHasHumps && StringUtil.containsAnyChar(name, " ()", nameIndex, nextOccurrence)) {
                return null;
            }
            if (!allowSpecialChars && this.myHasDots && StringUtil.contains(name, nameIndex, nextOccurrence, '.')) {
                return null;
            }
            if ((!this.isUpperCase[patternIndex] || star && Character.isUpperCase(name.charAt(nextOccurrence)) || NameUtil.isWordStart(name, nextOccurrence)) && (ranges = this.matchFragment(name, patternIndex, nextOccurrence, matchingState)) != null) {
                return ranges;
            }
            nameIndex = nextOccurrence;
        }
    }

    private boolean charEquals(char patternChar, int patternIndex, char c, boolean isIgnoreCase) {
        return patternChar == c || isIgnoreCase && (this.toLowerCase[patternIndex] == c || this.toUpperCase[patternIndex] == c);
    }

    @Nullable
    private FList<TextRange> matchFragment(@NotNull String name, int patternIndex, int nameIndex, MatchingState matchingState) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/MinusculeMatcher.matchFragment must not be null");
        }
        if (matchingState.hasFailed(patternIndex, nameIndex)) {
            return null;
        }
        FList<TextRange> result = this.doMatchFragments(name, patternIndex, nameIndex, matchingState);
        if (result == null) {
            matchingState.registerFailure(patternIndex, nameIndex);
        }
        return result;
    }

    private FList<TextRange> doMatchFragments(String name, int patternIndex, int nameIndex, MatchingState matchingState) {
        boolean ignoreCase;
        if (!this.isFirstCharMatching(name, nameIndex, patternIndex)) {
            return null;
        }
        int minFragment = this.isPatternChar(patternIndex - 1, '*') && !this.isWildcard(patternIndex + 1) && Character.isLetterOrDigit(name.charAt(nameIndex)) && !NameUtil.isWordStart(name, nameIndex) ? 3 : 1;
        int i = 1;
        boolean bl = ignoreCase = this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
        while (nameIndex + i < name.length() && patternIndex + i < this.myPattern.length && this.charEquals(this.myPattern[patternIndex + i], patternIndex + i, name.charAt(nameIndex + i), ignoreCase)) {
            if (this.isUpperCase[patternIndex + i]) {
                if (i < minFragment) {
                    return null;
                }
                if (this.myPattern[patternIndex + i] != name.charAt(nameIndex + i)) {
                    int nextWordStart = this.indexOfWordStart(name, patternIndex + i, nameIndex + i, matchingState.isAsciiName);
                    FList<TextRange> ranges = this.matchWildcards(name, patternIndex + i, nextWordStart, matchingState);
                    if (ranges != null) {
                        return MinusculeMatcher.prependRange(ranges, nameIndex, i);
                    }
                    if (this.myHasHumps && i > 1 && this.isUpperCase[patternIndex + i - 1] && this.isUpperCase[patternIndex + i - 2]) {
                        return null;
                    }
                }
            }
            ++i;
        }
        if (patternIndex + i >= this.myPattern.length) {
            return FList.emptyList().prepend(TextRange.from(nameIndex, i));
        }
        while (i >= minFragment) {
            FList<TextRange> ranges;
            FList<TextRange> fList = ranges = this.isWildcard(patternIndex + i) ? this.matchWildcards(name, patternIndex + i, nameIndex + i, matchingState) : this.matchSkippingWords(name, patternIndex + i, nameIndex + i, false, matchingState);
            if (ranges != null) {
                return MinusculeMatcher.prependRange(ranges, nameIndex, i);
            }
            --i;
        }
        return null;
    }

    private boolean isFirstCharMatching(@NotNull String name, int nameIndex, int patternIndex) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/MinusculeMatcher.isFirstCharMatching must not be null");
        }
        boolean ignoreCase = this.myOptions == NameUtil.MatchingCaseSensitivity.FIRST_LETTER && nameIndex > 0 || this.myOptions == NameUtil.MatchingCaseSensitivity.NONE;
        return nameIndex < name.length() && this.charEquals(this.myPattern[patternIndex], patternIndex, name.charAt(nameIndex), ignoreCase);
    }

    private boolean isWildcard(int patternIndex) {
        return this.isPatternChar(patternIndex, ' ', '*');
    }

    private boolean isPatternChar(int patternIndex, char c) {
        return patternIndex >= 0 && patternIndex < this.myPattern.length && this.myPattern[patternIndex] == c;
    }

    private boolean isPatternChar(int patternIndex, char c1, char c2) {
        if (patternIndex >= 0 && patternIndex < this.myPattern.length) {
            char pc = this.myPattern[patternIndex];
            return pc == c1 || pc == c2;
        }
        return false;
    }

    private int indexOfWordStart(@NotNull String name, int patternIndex, int startFrom, boolean isAsciiName) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/MinusculeMatcher.indexOfWordStart must not be null");
        }
        char p = this.myPattern[patternIndex];
        if (p == '.' || this.isWordSeparator[patternIndex]) {
            return this.indexOfIgnoreCase(name, startFrom + 1, p, patternIndex, isAsciiName);
        }
        if (startFrom >= name.length() || this.myHasHumps && this.isLowerCase[patternIndex] && (patternIndex <= 0 || !this.isWordSeparator[patternIndex - 1])) {
            return -1;
        }
        int nextWordStart = startFrom;
        do {
            if ((nextWordStart = NameUtil.nextWord(name, nextWordStart)) < name.length()) continue;
            return -1;
        } while (!this.charEquals(p, patternIndex, name.charAt(nextWordStart), true));
        return nextWordStart;
    }

    private int indexOfIgnoreCase(String name, int fromIndex, char p, int patternIndex, boolean isAsciiName) {
        if (isAsciiName && IOUtil.isAscii(p)) {
            char pUpper = this.toUpperCase[patternIndex];
            char pLower = this.toLowerCase[patternIndex];
            for (int i = fromIndex; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c != p && MinusculeMatcher.toUpperAscii(c) != pUpper && MinusculeMatcher.toLowerAscii(c) != pLower) continue;
                return i;
            }
            return -1;
        }
        return StringUtil.indexOfIgnoreCase(name, p, fromIndex);
    }

    private static char toUpperAscii(char c) {
        if (c >= 'a' && c <= 'z') {
            return (char)(c + -32);
        }
        return c;
    }

    private static char toLowerAscii(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c - -32);
        }
        return c;
    }

    @NonNls
    public String toString() {
        return "MinusculeMatcher{myPattern=" + new String(this.myPattern) + ", myOptions=" + (Object)((Object)this.myOptions) + '}';
    }

    private static class MatchingState {
        private boolean myBusy;
        private int myNameLength;
        private boolean isAsciiName;
        private final BitSet myTable = new BitSet();

        private MatchingState() {
        }

        void initializeState(String name) {
            assert (!this.myBusy);
            this.myBusy = true;
            this.myNameLength = name.length();
            this.isAsciiName = IOUtil.isAscii(name);
            this.myTable.clear();
        }

        void releaseState() {
            assert (this.myBusy);
            this.myBusy = false;
        }

        void registerFailure(int patternIndex, int nameIndex) {
            this.myTable.set(patternIndex * this.myNameLength + nameIndex);
        }

        boolean hasFailed(int patternIndex, int nameIndex) {
            return this.myTable.get(patternIndex * this.myNameLength + nameIndex);
        }
    }
}

