/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsMemberImpl;
import com.intellij.psi.impl.compiled.ClsModifierListOwner;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import gnu.trove.THashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ClsFieldImpl
extends ClsMemberImpl<PsiFieldStub>
implements PsiField,
PsiVariableEx,
ClsModifierListOwner {
    private PsiTypeElement myType;
    private PsiExpression myInitializer;
    private boolean myInitializerInitialized;

    public ClsFieldImpl(@NotNull PsiFieldStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFieldImpl.<init> must not be null");
        }
        super(stub);
        this.myType = null;
        this.myInitializer = null;
        this.myInitializerInitialized = false;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.getChildren(this.getDocComment(), this.getModifierList(), this.getTypeElement(), this.getNameIdentifier());
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    @Override
    public PsiClass getContainingClass() {
        return (PsiClass)this.getParent();
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = this.getTypeElement().getType();
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getType must not return null");
        }
        return psiType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public PsiTypeElement getTypeElement() {
        Object object = LAZY_BUILT_LOCK;
        // MONITORENTER : object
        if (this.myType == null) {
            PsiFieldStub stub = (PsiFieldStub)this.getStub();
            String typeText = TypeInfo.createTypeText(stub.getType(false));
            assert (typeText != null) : stub;
            this.myType = new ClsTypeElementImpl(this, typeText, '\u0000');
        }
        PsiTypeElement psiTypeElement = this.myType;
        // MONITOREXIT : object
        if (psiTypeElement != null) return psiTypeElement;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getTypeElement must not return null");
    }

    @Override
    public PsiModifierList getModifierList() {
        return ((PsiFieldStub)this.getStub()).findChildStubByType(JavaStubElementTypes.MODIFIER_LIST).getPsi();
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFieldImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiExpression getInitializer() {
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (!this.myInitializerInitialized) {
                this.myInitializerInitialized = true;
                String initializerText = ((PsiFieldStub)this.getStub()).getInitializerText();
                if (initializerText != null && !Comparing.equal(";INITIALIZER_TOO_LONG;", initializerText)) {
                    this.myInitializer = ClsParsingUtil.createExpressionFromText(initializerText, this.getManager(), this);
                }
            }
            return this.myInitializer;
        }
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Override
    public Object computeConstantValue() {
        return this.computeConstantValue(new THashSet<PsiVariable>());
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        String qName;
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        PsiExpression initializer = this.getInitializer();
        if (initializer == null) {
            return null;
        }
        PsiClass containingClass = this.getContainingClass();
        String string = qName = containingClass != null ? containingClass.getQualifiedName() : null;
        if ("java.lang.Float".equals(qName)) {
            String name = this.getName();
            if ("POSITIVE_INFINITY".equals(name)) {
                return new Float(Float.POSITIVE_INFINITY);
            }
            if ("NEGATIVE_INFINITY".equals(name)) {
                return new Float(Float.NEGATIVE_INFINITY);
            }
            if ("NaN".equals(name)) {
                return new Float(Float.NaN);
            }
        } else if ("java.lang.Double".equals(qName)) {
            String name = this.getName();
            if ("POSITIVE_INFINITY".equals(name)) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if ("NEGATIVE_INFINITY".equals(name)) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
            if ("NaN".equals(name)) {
                return new Double(Double.NaN);
            }
        }
        return PsiConstantEvaluationHelperImpl.computeCastTo(initializer, this.getType(), visitedVars);
    }

    @Override
    public boolean isDeprecated() {
        return ((PsiFieldStub)this.getStub()).isDeprecated();
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFieldImpl.appendMirrorText must not be null");
        }
        ClsFieldImpl.appendText(this.getDocComment(), indentLevel, buffer, "go_to_next_line_and_indent");
        ClsFieldImpl.appendText(this.getModifierList(), indentLevel, buffer, "");
        ClsFieldImpl.appendText(this.getTypeElement(), indentLevel, buffer, " ");
        ClsFieldImpl.appendText(this.getNameIdentifier(), indentLevel, buffer);
        PsiExpression initializer = this.getInitializer();
        if (initializer != null) {
            buffer.append(" = ");
            buffer.append(initializer.getText());
        }
        buffer.append(';');
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFieldImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiField mirror = (PsiField)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsFieldImpl.setMirrorIfPresent(this.getDocComment(), mirror.getDocComment());
        ClsFieldImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsFieldImpl.setMirror(this.getTypeElement(), mirror.getTypeElement());
        ClsFieldImpl.setMirror(this.getNameIdentifier(), mirror.getNameIdentifier());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFieldImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitField(this);
        } else {
            visitor.visitElement(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement;
        for (ClsCustomNavigationPolicy customNavigationPolicy : Extensions.getExtensions(ClsCustomNavigationPolicy.EP_NAME)) {
            PsiElement navigationElement = customNavigationPolicy.getNavigationElement(this);
            if (navigationElement == null) continue;
            psiElement = navigationElement;
            if (psiElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getNavigationElement must not return null");
            return psiElement;
        }
        PsiClass sourceClassMirror = ((ClsClassImpl)this.getParent()).getSourceMirrorClass();
        PsiField sourceFieldMirror = sourceClassMirror != null ? sourceClassMirror.findFieldByName(this.getName(), false) : null;
        psiElement = sourceFieldMirror != null ? sourceFieldMirror.getNavigationElement() : this;
        if (psiElement != null) return psiElement;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getNavigationElement must not return null");
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(PlatformIcons.FIELD_ICON, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getUseScope must not return null");
        }
        return searchScope;
    }

    @Override
    public PsiType getTypeNoResolve() {
        return this.getType();
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public String toString() {
        return "PsiField:" + this.getName();
    }
}

