/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.StubPsiFactory;
import com.intellij.psi.stubs.ILightStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.ICompositeElementType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JavaStubElementType<StubT extends StubElement, PsiT extends PsiElement>
extends ILightStubElementType<StubT, PsiT>
implements ICompositeElementType {
    private final boolean myLeftBound;

    protected JavaStubElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaStubElementType.<init> must not be null");
        }
        this(debugName, false);
    }

    protected JavaStubElementType(@NotNull @NonNls String debugName, boolean leftBound) {
        if (debugName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaStubElementType.<init> must not be null");
        }
        super(debugName, JavaLanguage.INSTANCE);
        this.myLeftBound = leftBound;
    }

    @Override
    public String getExternalId() {
        return "java." + this.toString();
    }

    protected StubPsiFactory getPsiFactory(StubT stub) {
        return this.getFileStub(stub).getPsiFactory();
    }

    public boolean isCompiled(StubT stub) {
        return this.getFileStub(stub).isCompiled();
    }

    private PsiJavaFileStub getFileStub(StubT stub) {
        Object parent = stub;
        while (!(parent instanceof PsiFileStub)) {
            parent = parent.getParentStub();
        }
        return (PsiJavaFileStub)parent;
    }

    @Override
    public abstract PsiT createPsi(@NotNull ASTNode var1);

    @Override
    public final StubT createStub(@NotNull PsiT psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaStubElementType.createStub must not be null");
        }
        String message = "Should not be called. Element=" + psi + "; class" + psi.getClass() + "; file=" + (psi.isValid() ? psi.getContainingFile() : "-");
        throw new UnsupportedOperationException(message);
    }

    @Override
    public boolean isLeftBound() {
        return this.myLeftBound;
    }
}

