/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PsiTryStatementImpl
extends CompositePsiElement
implements PsiTryStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiTryStatementImpl");
    private volatile PsiParameter[] myCachedCatchParameters = null;

    public PsiTryStatementImpl() {
        super(TRY_STATEMENT);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedCatchParameters = null;
    }

    @Override
    public PsiCodeBlock getTryBlock() {
        return (PsiCodeBlock)this.findChildByRoleAsPsiElement(48);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiCodeBlock[] getCatchBlocks() {
        PsiCodeBlock[] psiCodeBlockArray;
        ASTNode tryBlock = SourceTreeToPsiMap.psiElementToTree(this.getTryBlock());
        if (tryBlock != null) {
            PsiCatchSection[] catchSections = this.getCatchSections();
            if (catchSections.length == 0) {
                psiCodeBlockArray = PsiCodeBlock.EMPTY_ARRAY;
                if (PsiCodeBlock.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl.getCatchBlocks must not return null");
                return psiCodeBlockArray;
            } else {
                boolean lastIncomplete = catchSections[catchSections.length - 1].getCatchBlock() == null;
                PsiCodeBlock[] blocks = new PsiCodeBlock[lastIncomplete ? catchSections.length - 1 : catchSections.length];
                for (int i = 0; i < blocks.length; ++i) {
                    blocks[i] = catchSections[i].getCatchBlock();
                }
                psiCodeBlockArray = blocks;
                if (blocks == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl.getCatchBlocks must not return null");
                return psiCodeBlockArray;
            }
        }
        psiCodeBlockArray = PsiCodeBlock.EMPTY_ARRAY;
        if (PsiCodeBlock.EMPTY_ARRAY != null) return psiCodeBlockArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl.getCatchBlocks must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiParameter[] getCatchBlockParameters() {
        PsiParameter[] psiParameterArray;
        PsiParameter[] catchParameters = this.myCachedCatchParameters;
        if (catchParameters == null) {
            PsiCatchSection[] catchSections = this.getCatchSections();
            if (catchSections.length == 0) {
                psiParameterArray = PsiParameter.EMPTY_ARRAY;
                if (PsiParameter.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl.getCatchBlockParameters must not return null");
                return psiParameterArray;
            }
            boolean lastIncomplete = catchSections[catchSections.length - 1].getCatchBlock() == null;
            int limit = lastIncomplete ? catchSections.length - 1 : catchSections.length;
            ArrayList<PsiParameter> parameters = new ArrayList<PsiParameter>();
            for (int i = 0; i < limit; ++i) {
                PsiParameter parameter = catchSections[i].getParameter();
                if (parameter == null) continue;
                parameters.add(parameter);
            }
            catchParameters = parameters.toArray(new PsiParameter[parameters.size()]);
            this.myCachedCatchParameters = catchParameters;
        }
        psiParameterArray = catchParameters;
        if (catchParameters != null) return psiParameterArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl.getCatchBlockParameters must not return null");
    }

    @Override
    @NotNull
    public PsiCatchSection[] getCatchSections() {
        PsiCatchSection[] psiCatchSectionArray = (PsiCatchSection[])this.getChildrenAsPsiElements(CATCH_SECTION_BIT_SET, PsiCatchSection.ARRAY_FACTORY);
        if (psiCatchSectionArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl.getCatchSections must not return null");
        }
        return psiCatchSectionArray;
    }

    @Override
    public PsiCodeBlock getFinallyBlock() {
        return (PsiCodeBlock)this.findChildByRoleAsPsiElement(52);
    }

    @Override
    public PsiResourceList getResourceList() {
        return PsiTreeUtil.getChildOfType(this, PsiResourceList.class);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 45: {
                return this.findChildByType(TRY_KEYWORD);
            }
            case 48: {
                return this.findChildByType(CODE_BLOCK);
            }
            case 47: {
                return this.findChildByType(FINALLY_KEYWORD);
            }
            case 52: 
        }
        ASTNode finallyKeyword = this.findChildByRole(47);
        if (finallyKeyword == null) {
            return null;
        }
        for (ASTNode child = finallyKeyword.getTreeNext(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != CODE_BLOCK) continue;
            return child;
        }
        return null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == TRY_KEYWORD) {
            return 45;
        }
        if (i == FINALLY_KEYWORD) {
            return 47;
        }
        if (i == CATCH_SECTION) {
            return 251;
        }
        if (child.getElementType() == CODE_BLOCK) {
            int role = this.getChildRole(child, 48);
            if (role != 0) {
                return role;
            }
            return this.getChildRole(child, 52);
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTryStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl.processDeclarations must not be null");
        }
        PsiResourceList resourceList = this.getResourceList();
        if (resourceList != null && lastParent instanceof PsiCodeBlock && lastParent == this.getTryBlock()) {
            return PsiImplUtil.processDeclarationsInResourceList(resourceList, processor, state, lastParent);
        }
        return true;
    }

    @Override
    public String toString() {
        return "PsiTryStatement";
    }
}

