/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class AtomicFieldUpdater<T, V> {
    private static final Unsafe unsafe = AtomicFieldUpdater.getUnsafe();
    private final long offset;

    @NotNull
    public static Unsafe getUnsafe() {
        Unsafe unsafe = null;
        Class<Unsafe> uc = Unsafe.class;
        try {
            Field[] fields;
            for (Field field : fields = uc.getDeclaredFields()) {
                if (!field.getName().equals("theUnsafe")) continue;
                field.setAccessible(true);
                unsafe = (Unsafe)field.get(uc);
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (unsafe == null) {
            throw new RuntimeException("Could not find 'theUnsafe' field in the " + uc);
        }
        Unsafe unsafe2 = unsafe;
        if (unsafe2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/concurrency/AtomicFieldUpdater.getUnsafe must not return null");
        }
        return unsafe2;
    }

    @NotNull
    public static <T, V> AtomicFieldUpdater<T, V> forFieldOfType(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        if (ownerClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/concurrency/AtomicFieldUpdater.forFieldOfType must not be null");
        }
        if (fieldType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/concurrency/AtomicFieldUpdater.forFieldOfType must not be null");
        }
        AtomicFieldUpdater<T, V> atomicFieldUpdater = new AtomicFieldUpdater<T, V>(ownerClass, fieldType);
        if (atomicFieldUpdater == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/concurrency/AtomicFieldUpdater.forFieldOfType must not return null");
        }
        return atomicFieldUpdater;
    }

    @NotNull
    public static <T> AtomicFieldUpdater<T, Long> forLongField(@NotNull Class<T> ownerClass) {
        if (ownerClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/concurrency/AtomicFieldUpdater.forLongField must not be null");
        }
        AtomicFieldUpdater<T, Long> atomicFieldUpdater = new AtomicFieldUpdater<T, Long>(ownerClass, Long.TYPE);
        if (atomicFieldUpdater == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/concurrency/AtomicFieldUpdater.forLongField must not return null");
        }
        return atomicFieldUpdater;
    }

    private AtomicFieldUpdater(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        if (ownerClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/concurrency/AtomicFieldUpdater.<init> must not be null");
        }
        if (fieldType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/concurrency/AtomicFieldUpdater.<init> must not be null");
        }
        Field[] declaredFields = ownerClass.getDeclaredFields();
        Field found = null;
        for (Field field : declaredFields) {
            if ((field.getModifiers() & 0x18) != 0 || !fieldType.isAssignableFrom(field.getType())) continue;
            if (found == null) {
                found = field;
                continue;
            }
            throw new IllegalArgumentException("Two fields of " + fieldType + " found in the " + ownerClass + ": " + found.getName() + " and " + field.getName());
        }
        if (found == null) {
            throw new IllegalArgumentException("No (non-static, non-final) field of " + fieldType + " found in the " + ownerClass);
        }
        found.setAccessible(true);
        if ((found.getModifiers() & 0x40) == 0) {
            throw new IllegalArgumentException("Field " + found + " in the " + ownerClass + " must be volatile");
        }
        this.offset = unsafe.objectFieldOffset(found);
    }

    public boolean compareAndSet(@NotNull T owner, V expected, V newValue) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/concurrency/AtomicFieldUpdater.compareAndSet must not be null");
        }
        return unsafe.compareAndSwapObject(owner, this.offset, expected, newValue);
    }

    /*
     * WARNING - void declaration
     */
    public boolean compareAndSetLong(@NotNull T owner, long expected, long l) {
        void newValue;
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/concurrency/AtomicFieldUpdater.compareAndSetLong must not be null");
        }
        return unsafe.compareAndSwapLong(owner, this.offset, expected, (long)newValue);
    }
}

