/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.lang.Language;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.SubstitutedFileType;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public final class FileContentImpl
extends UserDataHolderBase
implements FileContent {
    private final VirtualFile myFile;
    private final String myFileName;
    private final FileType myFileType;
    private final Charset myCharset;
    private byte[] myContent;
    private CharSequence myContentAsText;
    private final long myStamp;
    private static final Key<PsiFile> CACHED_PSI = Key.create("cached psi from content");

    @Override
    public Project getProject() {
        return this.getUserData(IndexingDataKeys.PROJECT);
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psi = this.getUserData(IndexingDataKeys.PSI_FILE);
        if (psi == null) {
            psi = this.getUserData(CACHED_PSI);
        }
        if (psi == null) {
            Project project = this.getProject();
            if (project == null) {
                project = DefaultProjectFactory.getInstance().getDefaultProject();
            }
            Language language = ((LanguageFileType)this.getFileTypeWithoutSubstitution()).getLanguage();
            Language substitutedLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, this.getFile(), project);
            psi = PsiFileFactory.getInstance(project).createFileFromText(this.getFileName(), substitutedLanguage, this.getContentAsText(), false, false, true);
            psi.putUserData(IndexingDataKeys.VIRTUAL_FILE, this.getFile());
            this.putUserData(CACHED_PSI, psi);
        }
        PsiFile psiFile = psi;
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileContentImpl.getPsiFile must not return null");
        }
        return psiFile;
    }

    public FileContentImpl(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/indexing/FileContentImpl.<init> must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/indexing/FileContentImpl.<init> must not be null");
        }
        this(file, null, content, LoadTextUtil.detectCharsetAndSetBOM(file, content), -1L);
    }

    private FileContentImpl(@NotNull VirtualFile file, CharSequence contentAsText, byte[] content, Charset charset, long stamp) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/indexing/FileContentImpl.<init> must not be null");
        }
        this.myFile = file;
        this.myContentAsText = contentAsText;
        this.myContent = content;
        this.myCharset = charset;
        this.myFileType = file.getFileType();
        this.myFileName = file.getName();
        this.myStamp = stamp;
    }

    @NotNull
    private FileType substituteFileType(VirtualFile file, FileType fileType) {
        Project project = this.getProject();
        FileType fileType2 = SubstitutedFileType.substituteFileType(file, fileType, project);
        if (fileType2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileContentImpl.substituteFileType must not return null");
        }
        return fileType2;
    }

    @NotNull
    public FileType getSubstitutedFileType() {
        FileType fileType = this.substituteFileType(this.myFile, this.myFileType);
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileContentImpl.getSubstitutedFileType must not return null");
        }
        return fileType;
    }

    public FileType getFileTypeWithoutSubstitution() {
        return this.myFileType;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        FileType fileType = this.getSubstitutedFileType();
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileContentImpl.getFileType must not return null");
        }
        return fileType;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileContentImpl.getFile must not return null");
        }
        return virtualFile;
    }

    @NotNull
    public String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileContentImpl.getFileName must not return null");
        }
        return string;
    }

    @Override
    public byte[] getContent() {
        if (this.myContent == null && this.myContentAsText != null) {
            try {
                this.myContent = this.myCharset != null ? ((Object)this.myContentAsText).toString().getBytes(this.myCharset.name()) : ((Object)this.myContentAsText).toString().getBytes();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.myContent;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public CharSequence getContentAsText() {
        CharSequence charSequence;
        if (this.myFileType.isBinary()) {
            throw new IllegalDataException("Cannot obtain text for binary file type : " + this.myFileType.getDescription());
        }
        CharSequence content = this.getUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY);
        if (content != null) {
            charSequence = content;
            if (charSequence == null) throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileContentImpl.getContentAsText must not return null");
            return charSequence;
        }
        if (this.myContentAsText == null && this.myContent != null) {
            this.myContentAsText = LoadTextUtil.getTextByBinaryPresentation(this.myContent, this.myCharset);
            this.myContent = null;
        }
        if ((charSequence = this.myContentAsText) != null) return charSequence;
        throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileContentImpl.getContentAsText must not return null");
    }

    public String toString() {
        return this.myFileName;
    }

    public static class IllegalDataException
    extends RuntimeException {
        public IllegalDataException(String message) {
            super(message);
        }
    }
}

