/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;

public class StringFactory {
    private static final Constructor<String> sharingCtr;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String createShared(@NotNull char[] chars) {
        String string;
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/StringFactory.createShared must not be null");
        }
        if (sharingCtr != null) {
            String string2;
            try {
                string2 = sharingCtr.newInstance(chars, true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            string = string2;
            if (string2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/StringFactory.createShared must not return null");
            return string;
        }
        string = new String(chars);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/util/text/StringFactory.createShared must not return null");
    }

    static {
        Constructor newC = null;
        try {
            newC = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
            newC.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        sharingCtr = newC;
    }
}

