/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.RetinaImage;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.IsRetina;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.swing.GrayFilter;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class UIUtil {
    private static final AtomicNotNullLazyValue<Boolean> X_RENDER_ACTIVE = new AtomicNotNullLazyValue<Boolean>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        protected Boolean compute() {
            Boolean bl;
            Boolean bl2;
            if (!SystemInfo.isXWindow) {
                bl2 = false;
                if (bl2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ui/UIUtil$1.compute must not return null");
                return bl2;
            }
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.awt.X11GraphicsEnvironment");
                Method method = clazz.getMethod("isXRenderAvailable", new Class[0]);
                bl = (Boolean)method.invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                bl2 = false;
                if (bl2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ui/UIUtil$1.compute must not return null");
                return bl2;
            }
            bl2 = bl;
            if (bl == null) throw new IllegalStateException("@NotNull method com/intellij/util/ui/UIUtil$1.compute must not return null");
            return bl2;
        }
    };
    private static final String[] STANDARD_FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    private static final GrayFilter DEFAULT_GRAY_FILTER = new GrayFilter(true, 65);
    private static final GrayFilter DARCULA_GRAY_FILTER = new GrayFilter(true, 30);
    public static final Pattern CLOSE_TAG_PATTERN = Pattern.compile("<\\s*([^<>/ ]+)([^<>]*)/\\s*>", 2);
    public static Key<Integer> KEEP_BORDER_SIDES = Key.create("keepBorderSides");
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.UIUtil");
    private static final Color UNFOCUSED_SELECTION_COLOR = Gray._212;
    private static final Color ACTIVE_HEADER_COLOR = new Color(160, 186, 213);
    private static final Color INACTIVE_HEADER_COLOR = Gray._128;
    private static final Color BORDER_COLOR = Color.LIGHT_GRAY;
    public static final Color AQUA_SEPARATOR_FOREGROUND_COLOR = Gray._190;
    public static final Color AQUA_SEPARATOR_BACKGROUND_COLOR = Gray._240;
    public static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    public static final Insets PANEL_REGULAR_INSETS = new Insets(8, 12, 8, 12);
    public static final Insets PANEL_SMALL_INSETS = new Insets(5, 8, 5, 8);
    public static final Border DEBUG_MARKER_BORDER = new Border(){
        private final Insets empty = new Insets(0, 0, 0, 0);

        @Override
        public Insets getBorderInsets(Component c) {
            return this.empty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics g2 = g.create();
            try {
                g2.setColor(JBColor.RED);
                UIUtil.drawDottedRectangle(g2, x, y, x + width - 1, y + height - 1);
            }
            finally {
                g2.dispose();
            }
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    };
    private static final HashMap<Color, BufferedImage> ourAppleDotSamples = new HashMap();
    private static volatile Pair<String, Integer> ourSystemFontData = null;
    private static final Ref<Boolean> ourRetina = Ref.create(SystemInfo.isMac ? null : Boolean.valueOf(false));
    public static final Color GTK_AMBIANCE_TEXT_COLOR = new Color(223, 219, 210);
    public static final Color GTK_AMBIANCE_BACKGROUND_COLOR = new Color(67, 66, 63);
    private static final Color DECORATED_ROW_BG_COLOR = new Color(242, 245, 249);
    private static final Color DECORATED_ROW_BG_COLOR_DARK = Gray._75;

    private UIUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRetina() {
        Ref<Boolean> ref = ourRetina;
        synchronized (ref) {
            if (ourRetina.isNull()) {
                ourRetina.set(false);
                String vendor = SystemProperties.getJavaVmVendor();
                if (SystemInfo.isJavaVersionAtLeast("1.6.0_33") && vendor != null && StringUtil.containsIgnoreCase(vendor, "Apple") && !"false".equals(System.getProperty("ide.mac.retina"))) {
                    ourRetina.set(IsRetina.isRetina());
                }
            }
            return ourRetina.get();
        }
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
    }

    public static Color getTreeTextBackground() {
        return UIManager.getColor("Tree.textBackground");
    }

    public static Color getListBackground() {
        return UIUtil.isUnderGTKLookAndFeel() ? UIUtil.getTreeTextBackground() : UIManager.getColor("List.background");
    }

    public static Color getListForeground() {
        return UIManager.getColor("List.foreground");
    }

    public static boolean isUnderDarcula() {
        return UIManager.getLookAndFeel().getName().contains("Darcula");
    }

    public static boolean isUnderGTKLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("GTK");
    }

    public static void drawDottedRectangle(Graphics g, int x, int y, int x1, int y1) {
        int i1;
        for (i1 = x; i1 <= x1; i1 += 2) {
            UIUtil.drawLine(g, i1, y, i1, y);
        }
        int n = i1 = i1 != x1 + 1 ? y + 2 : y + 1;
        while (i1 <= y1) {
            UIUtil.drawLine(g, x1, i1, x1, i1);
            i1 += 2;
        }
        int n2 = i1 = i1 != y1 + 1 ? x1 - 2 : x1 - 1;
        while (i1 >= x) {
            UIUtil.drawLine(g, i1, y1, i1, y1);
            i1 -= 2;
        }
        int n3 = i1 = i1 != x - 1 ? y1 - 2 : y1 - 1;
        while (i1 >= y) {
            UIUtil.drawLine(g, x, i1, x, i1);
            i1 -= 2;
        }
    }

    public static BufferedImage createImage(int width, int height, int type) {
        if (UIUtil.isRetina()) {
            return RetinaImage.create(width, height, type);
        }
        return new BufferedImage(width, height, type);
    }
}

