/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class PropertyAccessor
implements Accessor {
    private final String myName;
    private final Class<?> myType;
    private final Method myReadMethod;
    private final Method myWriteMethod;
    private final Type myGenericType;
    private Annotation[] myAnnotationCache;

    public PropertyAccessor(String name, Class<?> type, Method readMethod, Method writeMethod) {
        this.myName = name;
        this.myType = type;
        this.myReadMethod = readMethod;
        this.myWriteMethod = writeMethod;
        this.myGenericType = this.myReadMethod.getGenericReturnType();
    }

    @Override
    public Object read(Object o) {
        try {
            return this.myReadMethod.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new XmlSerializationException(e);
        }
    }

    @Override
    public void write(Object o, Object value) {
        try {
            this.myWriteMethod.invoke(o, XmlSerializerImpl.convert(value, this.myType));
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new XmlSerializationException(e);
        }
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        Annotation[] annotations = this.myAnnotationCache;
        if (annotations == null) {
            this.myAnnotationCache = this.calcAnnotations();
            annotations = this.myAnnotationCache;
        }
        if (annotations == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xmlb/PropertyAccessor.getAnnotations must not return null");
        }
        return annotations;
    }

    private Annotation[] calcAnnotations() {
        ArrayList result = new ArrayList();
        if (this.myReadMethod != null) {
            ContainerUtil.addAll(result, this.myReadMethod.getAnnotations());
        }
        if (this.myWriteMethod != null) {
            ContainerUtil.addAll(result, this.myWriteMethod.getAnnotations());
        }
        return result.toArray(new Annotation[result.size()]);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Class<?> getValueClass() {
        return this.myType;
    }

    @Override
    public Type getGenericType() {
        return this.myGenericType;
    }

    @NonNls
    public String toString() {
        return "PropertyAccessor[" + this.myReadMethod.getDeclaringClass().getName() + "." + this.getName() + "]";
    }
}

