/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.DoubleIterator;
import jet.DoubleProgressionIterator;
import jet.Progression;
import jet.Range;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public final class DoubleRange
implements Progression<Double>,
Range<Double> {
    public static final DoubleRange EMPTY = new DoubleRange(1.0, 0.0);
    private final double start;
    private final double end;

    public DoubleRange(double start, double end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean contains(Double item) {
        return this.start <= item && item <= this.end;
    }

    @Override
    public boolean contains(double item) {
        return this.start <= item && item <= this.end;
    }

    @Override
    public Double getStart() {
        return this.start;
    }

    @Override
    public Double getEnd() {
        return this.end;
    }

    @Override
    public Double getIncrement() {
        return 1.0;
    }

    public DoubleIterator iterator() {
        return new DoubleProgressionIterator(this.start, this.end, 1.0);
    }

    public String toString() {
        return this.start + ".." + this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleRange range = (DoubleRange)o;
        return Double.compare(range.end, this.end) == 0 && Double.compare(range.start, this.start) == 0;
    }

    public int hashCode() {
        long temp = this.start != 0.0 ? Double.doubleToLongBits(this.start) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.end != 0.0 ? Double.doubleToLongBits(this.end) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

