/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.SubstitutingScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeConstructorImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;

public class ClassDescriptorImpl
extends DeclarationDescriptorNonRootImpl
implements ClassDescriptor {
    private TypeConstructor typeConstructor;
    private JetScope memberDeclarations;
    private Set<ConstructorDescriptor> constructors;
    private ConstructorDescriptor primaryConstructor;
    private ReceiverParameterDescriptor thisAsReceiverParameter;
    private final Modality modality;
    private ClassDescriptor classObjectDescriptor;
    private final ClassKind kind;
    private boolean isInner;

    public ClassDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull List<AnnotationDescriptor> annotations, @NotNull Modality modality, @NotNull Name name) {
        this(containingDeclaration, ClassKind.CLASS, annotations, modality, name);
    }

    public ClassDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull ClassKind kind, @NotNull List<AnnotationDescriptor> annotations, @NotNull Modality modality, @NotNull Name name) {
        super(containingDeclaration, annotations, name);
        this.kind = kind;
        this.modality = modality;
    }

    public final ClassDescriptorImpl initialize(boolean sealed, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @NotNull Collection<JetType> supertypes, @NotNull JetScope memberDeclarations, @NotNull Set<ConstructorDescriptor> constructors, @Nullable ConstructorDescriptor primaryConstructor, boolean isInner) {
        this.typeConstructor = new TypeConstructorImpl(this, this.getAnnotations(), sealed, this.getName().asString(), typeParameters, supertypes);
        this.memberDeclarations = memberDeclarations;
        this.constructors = constructors;
        this.primaryConstructor = primaryConstructor;
        this.isInner = isInner;
        return this;
    }

    public void setPrimaryConstructor(@NotNull ConstructorDescriptor primaryConstructor) {
        this.primaryConstructor = primaryConstructor;
    }

    public void setClassObjectDescriptor(@NotNull ClassDescriptor classObjectDescriptor) {
        this.classObjectDescriptor = classObjectDescriptor;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor;
    }

    @Override
    @NotNull
    public JetScope getMemberScope(List<TypeProjection> typeArguments) {
        assert (typeArguments.size() == this.typeConstructor.getParameters().size()) : typeArguments;
        if (this.typeConstructor.getParameters().isEmpty()) {
            return this.memberDeclarations;
        }
        Map<TypeConstructor, TypeProjection> substitutionContext = SubstitutionUtils.buildSubstitutionContext(this.typeConstructor.getParameters(), typeArguments);
        return new SubstitutingScope(this.memberDeclarations, TypeSubstitutor.create(substitutionContext));
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        return TypeUtils.makeUnsubstitutedType(this, this.memberDeclarations);
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        return this.constructors;
    }

    @Override
    @NotNull
    public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JetType getClassObjectType() {
        return this.getClassObjectDescriptor().getDefaultType();
    }

    @Override
    public ClassDescriptor getClassObjectDescriptor() {
        return this.classObjectDescriptor;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        return this.kind;
    }

    @Override
    public boolean isClassObjectAValue() {
        return true;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitClassDescriptor(this, data);
    }

    @Override
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.primaryConstructor;
    }

    @Override
    @NotNull
    public Modality getModality() {
        return this.modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return Visibilities.PUBLIC;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    @Override
    @NotNull
    public ReceiverParameterDescriptor getThisAsReceiverParameter() {
        if (this.thisAsReceiverParameter == null) {
            this.thisAsReceiverParameter = DescriptorResolver.createLazyReceiverParameterDescriptor(this);
        }
        return this.thisAsReceiverParameter;
    }

    @Override
    @NotNull
    public JetScope getUnsubstitutedInnerClassesScope() {
        return JetScope.EMPTY;
    }
}

