/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ExpressionPosition;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.context.ResolveMode;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.constants.ConstantUtils;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.ChainedScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

public class CallExpressionResolver {
    @NotNull
    private ExpressionTypingServices expressionTypingServices;

    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        this.expressionTypingServices = expressionTypingServices;
    }

    @Nullable
    private JetType lookupNamespaceOrClassObject(@NotNull JetSimpleNameExpression expression, @NotNull ResolutionContext context) {
        JetType classObjectType;
        Name referencedName = expression.getReferencedNameAsName();
        final ClassifierDescriptor classifier = context.scope.getClassifier(referencedName);
        if (classifier != null && (classObjectType = classifier.getClassObjectType()) != null) {
            context.trace.record(BindingContext.REFERENCE_TARGET, expression, classifier);
            JetType result = this.getExtendedClassObjectType(classObjectType, referencedName, classifier, context);
            if (result == null) {
                context.trace.report(Errors.NO_CLASS_OBJECT.on(expression, classifier));
            }
            return DataFlowUtils.checkType(result, expression, context);
        }
        JetType[] result = new JetType[1];
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(context.trace, "trace for namespace/class object lookup of name", referencedName);
        if (this.furtherNameLookup(expression, result, (ResolutionContext)context.replaceBindingTrace(temporaryTrace))) {
            temporaryTrace.commit();
            return DataFlowUtils.checkType(result[0], expression, context);
        }
        if (classifier != null) {
            if (classifier instanceof TypeParameterDescriptor) {
                if (context.expressionPosition == ExpressionPosition.FREE) {
                    context.trace.report(Errors.TYPE_PARAMETER_IS_NOT_AN_EXPRESSION.on(expression, (TypeParameterDescriptor)classifier));
                } else {
                    context.trace.report(Errors.TYPE_PARAMETER_ON_LHS_OF_DOT.on(expression, (TypeParameterDescriptor)classifier));
                }
            } else if (context.expressionPosition == ExpressionPosition.FREE) {
                context.trace.report(Errors.NO_CLASS_OBJECT.on(expression, classifier));
            }
            context.trace.record(BindingContext.REFERENCE_TARGET, expression, classifier);
            JetScope scopeForStaticMembersResolution = classifier instanceof ClassDescriptor ? DescriptorUtils.getStaticNestedClassesScope((ClassDescriptor)classifier) : new JetScopeImpl(){

                @Override
                @NotNull
                public DeclarationDescriptor getContainingDeclaration() {
                    return classifier;
                }

                public String toString() {
                    return "Scope for the type parameter on the left hand side of dot";
                }
            };
            return new NamespaceType(referencedName, scopeForStaticMembersResolution);
        }
        temporaryTrace.commit();
        return result[0];
    }

    @Nullable
    private JetType getExtendedClassObjectType(@NotNull JetType classObjectType, @NotNull Name referencedName, @NotNull ClassifierDescriptor classifier, @NotNull ResolutionContext context) {
        if (context.expressionPosition == ExpressionPosition.LHS_OF_DOT && classifier instanceof ClassDescriptor) {
            ArrayList<JetScope> scopes = new ArrayList<JetScope>(3);
            scopes.add(classObjectType.getMemberScope());
            scopes.add(DescriptorUtils.getStaticNestedClassesScope((ClassDescriptor)classifier));
            NamespaceDescriptor namespace = context.scope.getNamespace(referencedName);
            if (namespace != null) {
                scopes.add(namespace.getMemberScope());
            }
            ChainedScope scope = new ChainedScope((DeclarationDescriptor)classifier, scopes.toArray(new JetScope[scopes.size()]));
            return new NamespaceType(referencedName, scope);
        }
        if (context.expressionPosition == ExpressionPosition.LHS_OF_DOT || classifier.isClassObjectAValue()) {
            return classObjectType;
        }
        return null;
    }

    private boolean furtherNameLookup(@NotNull JetSimpleNameExpression expression, @NotNull JetType[] result, @NotNull ResolutionContext context) {
        NamespaceType namespaceType = this.lookupNamespaceType(expression, context);
        if (namespaceType == null) {
            return false;
        }
        if (context.expressionPosition == ExpressionPosition.LHS_OF_DOT) {
            result[0] = namespaceType;
            return true;
        }
        context.trace.report(Errors.EXPRESSION_EXPECTED_NAMESPACE_FOUND.on(expression));
        result[0] = ErrorUtils.createErrorType("Type for " + expression.getReferencedNameAsName());
        return false;
    }

    @Nullable
    private NamespaceType lookupNamespaceType(@NotNull JetSimpleNameExpression expression, @NotNull ResolutionContext context) {
        Name name = expression.getReferencedNameAsName();
        NamespaceDescriptor namespace = context.scope.getNamespace(name);
        if (namespace == null) {
            return null;
        }
        context.trace.record(BindingContext.REFERENCE_TARGET, expression, namespace);
        ClassifierDescriptor classifier = context.scope.getClassifier(name);
        JetScope scope = classifier instanceof ClassDescriptor ? new ChainedScope((DeclarationDescriptor)namespace, namespace.getMemberScope(), DescriptorUtils.getStaticNestedClassesScope((ClassDescriptor)classifier)) : namespace.getMemberScope();
        return new NamespaceType(name, scope);
    }

    @Nullable
    public ResolvedCallWithTrace<FunctionDescriptor> getResolvedCallForFunction(@NotNull Call call, @NotNull JetExpression callExpression, @NotNull ResolutionContext context, @NotNull ResolveMode resolveMode, @NotNull CheckValueArgumentsMode checkArguments, @NotNull ResolutionResultsCache resolutionResultsCache, @NotNull boolean[] result) {
        CallResolver callResolver = this.expressionTypingServices.getCallResolver();
        OverloadResolutionResultsImpl<FunctionDescriptor> results = callResolver.resolveFunctionCall(BasicCallResolutionContext.create(context, call, resolveMode, checkArguments, resolutionResultsCache));
        if (!results.isNothing()) {
            this.checkSuper(call.getExplicitReceiver(), results, context.trace, callExpression);
            result[0] = true;
            if (results.isSingleResult() && resolveMode == ResolveMode.TOP_LEVEL_CALL && !CallResolverUtil.hasInferredReturnType(results.getResultingCall())) {
                return null;
            }
            return results.isSingleResult() ? results.getResultingCall() : null;
        }
        result[0] = false;
        return null;
    }

    @Nullable
    private JetType getVariableType(@NotNull JetSimpleNameExpression nameExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ResolutionContext context, @NotNull boolean[] result) {
        TemporaryBindingTrace traceForNamespaceOrClassObject;
        TemporaryBindingTrace traceForVariable = TemporaryBindingTrace.create(context.trace, "trace to resolve as local variable or property", nameExpression);
        CallResolver callResolver = this.expressionTypingServices.getCallResolver();
        Call call = CallMaker.makePropertyCall(receiver, callOperationNode, nameExpression);
        OverloadResolutionResults<VariableDescriptor> resolutionResult = callResolver.resolveSimpleProperty(BasicCallResolutionContext.create(context.replaceBindingTrace(traceForVariable), call, ResolveMode.TOP_LEVEL_CALL, CheckValueArgumentsMode.ENABLED, ResolutionResultsCache.create()));
        if (!resolutionResult.isNothing()) {
            traceForVariable.commit();
            this.checkSuper(receiver, resolutionResult, context.trace, nameExpression);
            result[0] = true;
            return resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null;
        }
        ResolutionContext newContext = receiver.exists() ? context.replaceScope(receiver.getType().getMemberScope()) : context;
        JetType jetType = this.lookupNamespaceOrClassObject(nameExpression, (ResolutionContext)newContext.replaceBindingTrace(traceForNamespaceOrClassObject = TemporaryBindingTrace.create(context.trace, "trace to resolve as namespace or class object", nameExpression)));
        if (jetType != null) {
            traceForNamespaceOrClassObject.commit();
            context.trace.record(BindingContext.RESOLUTION_SCOPE, nameExpression, context.scope);
            if (context.dataFlowInfo.hasTypeInfoConstraints()) {
                context.trace.record(BindingContext.NON_DEFAULT_EXPRESSION_DATA_FLOW, nameExpression, context.dataFlowInfo);
            }
            result[0] = true;
            return jetType;
        }
        result[0] = false;
        return null;
    }

    @NotNull
    public JetTypeInfo getSimpleNameExpressionTypeInfo(@NotNull JetSimpleNameExpression nameExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ResolutionContext context) {
        boolean[] result = new boolean[1];
        TemporaryBindingTrace traceForVariable = TemporaryBindingTrace.create(context.trace, "trace to resolve as variable", nameExpression);
        JetType type = this.getVariableType(nameExpression, receiver, callOperationNode, (ResolutionContext)context.replaceBindingTrace(traceForVariable), result);
        if (result[0]) {
            traceForVariable.commit();
            if (type instanceof NamespaceType && context.expressionPosition == ExpressionPosition.FREE) {
                type = null;
            }
            return JetTypeInfo.create(type, context.dataFlowInfo);
        }
        Call call = CallMaker.makeCall(nameExpression, receiver, callOperationNode, nameExpression, Collections.emptyList());
        TemporaryBindingTrace traceForFunction = TemporaryBindingTrace.create(context.trace, "trace to resolve as function", nameExpression);
        ResolvedCallWithTrace<FunctionDescriptor> resolvedCall = this.getResolvedCallForFunction(call, nameExpression, context, ResolveMode.TOP_LEVEL_CALL, CheckValueArgumentsMode.ENABLED, ResolutionResultsCache.create(), result);
        if (result[0]) {
            FunctionDescriptor functionDescriptor = resolvedCall != null ? (FunctionDescriptor)resolvedCall.getResultingDescriptor() : null;
            traceForFunction.commit();
            boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
            context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on(nameExpression, nameExpression, hasValueParameters));
            type = functionDescriptor != null ? functionDescriptor.getReturnType() : null;
            return JetTypeInfo.create(type, context.dataFlowInfo);
        }
        traceForVariable.commit();
        return JetTypeInfo.create(null, context.dataFlowInfo);
    }

    @NotNull
    public JetTypeInfo getCallExpressionTypeInfo(@NotNull JetCallExpression callExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ResolutionContext context, @NotNull ResolveMode resolveMode, @NotNull ResolutionResultsCache resolutionResultsCache) {
        JetTypeInfo typeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck(callExpression, receiver, callOperationNode, context, resolveMode, resolutionResultsCache);
        if (resolveMode == ResolveMode.TOP_LEVEL_CALL) {
            DataFlowUtils.checkType(typeInfo.getType(), callExpression, context, typeInfo.getDataFlowInfo());
        }
        return typeInfo;
    }

    @NotNull
    public JetTypeInfo getCallExpressionTypeInfoWithoutFinalTypeCheck(@NotNull JetCallExpression callExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ResolutionContext context, @NotNull ResolveMode resolveMode, @NotNull ResolutionResultsCache resolutionResultsCache) {
        boolean[] result = new boolean[1];
        Call call = CallMaker.makeCall(receiver, callOperationNode, callExpression);
        TemporaryBindingTrace traceForFunction = TemporaryBindingTrace.create(context.trace, "trace to resolve as function call", callExpression);
        ResolvedCallWithTrace<FunctionDescriptor> resolvedCall = this.getResolvedCallForFunction(call, callExpression, (ResolutionContext)context.replaceBindingTrace(traceForFunction), resolveMode, CheckValueArgumentsMode.ENABLED, resolutionResultsCache, result);
        if (result[0]) {
            FunctionDescriptor functionDescriptor = resolvedCall != null ? (FunctionDescriptor)resolvedCall.getResultingDescriptor() : null;
            traceForFunction.commit();
            if (callExpression.getValueArgumentList() == null && callExpression.getFunctionLiteralArguments().isEmpty()) {
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on(callExpression, callExpression, hasValueParameters));
            }
            if (functionDescriptor == null) {
                return JetTypeInfo.create(null, context.dataFlowInfo);
            }
            JetType type = functionDescriptor.getReturnType();
            return JetTypeInfo.create(type, resolvedCall.getDataFlowInfo());
        }
        JetExpression calleeExpression = callExpression.getCalleeExpression();
        if (calleeExpression instanceof JetSimpleNameExpression && callExpression.getTypeArgumentList() == null) {
            TemporaryBindingTrace traceForVariable = TemporaryBindingTrace.create(context.trace, "trace to resolve as variable with 'invoke' call", callExpression);
            JetType type = this.getVariableType((JetSimpleNameExpression)calleeExpression, receiver, callOperationNode, (ResolutionContext)context.replaceBindingTrace(traceForVariable), result);
            if (result[0]) {
                traceForVariable.commit();
                context.trace.report(Errors.FUNCTION_EXPECTED.on((JetReferenceExpression)calleeExpression, calleeExpression, type != null ? type : ErrorUtils.createErrorType("")));
                return JetTypeInfo.create(null, context.dataFlowInfo);
            }
        }
        traceForFunction.commit();
        return JetTypeInfo.create(null, context.dataFlowInfo);
    }

    private void checkSuper(@NotNull ReceiverValue receiverValue, @NotNull OverloadResolutionResults<? extends CallableDescriptor> results, @NotNull BindingTrace trace, @NotNull JetExpression expression) {
        if (!results.isSingleResult()) {
            return;
        }
        if (!(receiverValue instanceof ExpressionReceiver)) {
            return;
        }
        JetExpression receiver = ((ExpressionReceiver)receiverValue).getExpression();
        CallableDescriptor descriptor = results.getResultingDescriptor();
        if (receiver instanceof JetSuperExpression && descriptor instanceof MemberDescriptor && ((MemberDescriptor)((Object)descriptor)).getModality() == Modality.ABSTRACT) {
            trace.report(Errors.ABSTRACT_SUPER_CALL.on(expression));
        }
    }

    @NotNull
    private JetTypeInfo getSelectorReturnTypeInfo(@NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull JetExpression selectorExpression, @NotNull ResolutionContext context, @NotNull ResolveMode resolveMode, @NotNull ResolutionResultsCache resolutionResultsCache) {
        if (selectorExpression instanceof JetCallExpression) {
            return this.getCallExpressionTypeInfoWithoutFinalTypeCheck((JetCallExpression)selectorExpression, receiver, callOperationNode, context, resolveMode, resolutionResultsCache);
        }
        if (selectorExpression instanceof JetSimpleNameExpression) {
            return this.getSimpleNameExpressionTypeInfo((JetSimpleNameExpression)selectorExpression, receiver, callOperationNode, context);
        }
        if (selectorExpression instanceof JetQualifiedExpression) {
            JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)selectorExpression;
            JetExpression newReceiverExpression = qualifiedExpression.getReceiverExpression();
            JetTypeInfo newReceiverTypeInfo = this.getSelectorReturnTypeInfo(receiver, callOperationNode, newReceiverExpression, (ResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE), resolveMode, resolutionResultsCache);
            JetType newReceiverType = newReceiverTypeInfo.getType();
            DataFlowInfo newReceiverDataFlowInfo = newReceiverTypeInfo.getDataFlowInfo();
            JetExpression newSelectorExpression = qualifiedExpression.getSelectorExpression();
            if (newReceiverType != null && newSelectorExpression != null) {
                ExpressionReceiver expressionReceiver = new ExpressionReceiver(newReceiverExpression, newReceiverType);
                return this.getSelectorReturnTypeInfo(expressionReceiver, qualifiedExpression.getOperationTokenNode(), newSelectorExpression, (ResolutionContext)context.replaceDataFlowInfo(newReceiverDataFlowInfo), resolveMode, resolutionResultsCache);
            }
        } else {
            context.trace.report(Errors.ILLEGAL_SELECTOR.on(selectorExpression, selectorExpression.getText()));
        }
        return JetTypeInfo.create(null, context.dataFlowInfo);
    }

    @NotNull
    public JetTypeInfo getQualifiedExpressionTypeInfo(@NotNull JetQualifiedExpression expression, @NotNull ResolutionContext context, @NotNull ResolveMode resolveMode, @NotNull ResolutionResultsCache resolutionResultsCache) {
        JetExpression selectorExpression = expression.getSelectorExpression();
        JetExpression receiverExpression = expression.getReceiverExpression();
        JetTypeInfo receiverTypeInfo = this.expressionTypingServices.getTypeInfoWithNamespaces(receiverExpression, context.scope, TypeUtils.NO_EXPECTED_TYPE, context.dataFlowInfo, context.trace);
        JetType receiverType = receiverTypeInfo.getType();
        if (selectorExpression == null) {
            return JetTypeInfo.create(null, context.dataFlowInfo);
        }
        if (receiverType == null) {
            receiverType = ErrorUtils.createErrorType("Type for " + expression.getText());
        }
        context = context.replaceDataFlowInfo(receiverTypeInfo.getDataFlowInfo());
        if (selectorExpression instanceof JetSimpleNameExpression) {
            ConstantUtils.propagateConstantValues(expression, context.trace, (JetSimpleNameExpression)selectorExpression);
        }
        JetTypeInfo selectorReturnTypeInfo = this.getSelectorReturnTypeInfo(new ExpressionReceiver(receiverExpression, receiverType), expression.getOperationTokenNode(), selectorExpression, context, resolveMode, resolutionResultsCache);
        JetType selectorReturnType = selectorReturnTypeInfo.getType();
        if (!(receiverType instanceof NamespaceType) && expression.getOperationSign() == JetTokens.SAFE_ACCESS && selectorReturnType != null && !selectorReturnType.isNullable() && !KotlinBuiltIns.getInstance().isUnit(selectorReturnType) && receiverType.isNullable()) {
            selectorReturnType = TypeUtils.makeNullable(selectorReturnType);
        }
        if (selectorReturnType != null) {
            context.trace.record(BindingContext.EXPRESSION_TYPE, selectorExpression, selectorReturnType);
        }
        JetTypeInfo typeInfo = JetTypeInfo.create(selectorReturnType, selectorReturnTypeInfo.getDataFlowInfo());
        if (resolveMode == ResolveMode.TOP_LEVEL_CALL) {
            DataFlowUtils.checkType(typeInfo.getType(), expression, context, typeInfo.getDataFlowInfo());
        }
        return typeInfo;
    }
}

