/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.ChainedTemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.util.DelegatingCall;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;

public class CallTransformer<D extends CallableDescriptor, F extends D> {
    public static CallTransformer<VariableDescriptor, VariableDescriptor> PROPERTY_CALL_TRANSFORMER = new CallTransformer();
    public static CallTransformer<CallableDescriptor, FunctionDescriptor> FUNCTION_CALL_TRANSFORMER = new CallTransformer<CallableDescriptor, FunctionDescriptor>(){

        @Override
        @NotNull
        public Collection<CallCandidateResolutionContext<CallableDescriptor>> createCallContexts(@NotNull ResolutionCandidate<CallableDescriptor> candidate, @NotNull ResolutionTask<CallableDescriptor, FunctionDescriptor> task, @NotNull TemporaryBindingTrace candidateTrace) {
            if (candidate.getDescriptor() instanceof FunctionDescriptor) {
                return super.createCallContexts(candidate, task, candidateTrace);
            }
            assert (candidate.getDescriptor() instanceof VariableDescriptor);
            boolean hasReceiver = candidate.getReceiverArgument().exists();
            Call variableCall = this.stripCallArguments(task);
            if (!hasReceiver) {
                CallCandidateResolutionContext<CallableDescriptor> context = CallCandidateResolutionContext.create(ResolvedCallImpl.create(candidate, candidateTrace, task.tracing), task, candidateTrace, task.tracing, variableCall);
                return Collections.singleton(context);
            }
            Call variableCallWithoutReceiver = this.stripReceiver(variableCall);
            CallCandidateResolutionContext<CallableDescriptor> contextWithReceiver = this.createContextWithChainedTrace(candidate, variableCall, candidateTrace, task);
            ResolutionCandidate<CallableDescriptor> candidateWithoutReceiver = ResolutionCandidate.create(candidate.getDescriptor(), candidate.getThisObject(), ReceiverValue.NO_RECEIVER, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, false);
            CallCandidateResolutionContext<CallableDescriptor> contextWithoutReceiver = this.createContextWithChainedTrace(candidateWithoutReceiver, variableCallWithoutReceiver, candidateTrace, task);
            contextWithoutReceiver.receiverForVariableAsFunctionSecondCall = variableCall.getExplicitReceiver();
            return Lists.newArrayList(contextWithReceiver, contextWithoutReceiver);
        }

        private CallCandidateResolutionContext<CallableDescriptor> createContextWithChainedTrace(ResolutionCandidate<CallableDescriptor> candidate, Call call, TemporaryBindingTrace temporaryTrace, ResolutionTask<CallableDescriptor, FunctionDescriptor> task) {
            ChainedTemporaryBindingTrace chainedTrace = ChainedTemporaryBindingTrace.create(temporaryTrace, "chained trace to resolve candidate", candidate);
            ResolvedCallImpl<CallableDescriptor> resolvedCall = ResolvedCallImpl.create(candidate, chainedTrace, task.tracing);
            return CallCandidateResolutionContext.create(resolvedCall, task, chainedTrace, task.tracing, call);
        }

        private Call stripCallArguments(@NotNull ResolutionTask<CallableDescriptor, FunctionDescriptor> task) {
            return new DelegatingCall(task.call){

                @Override
                public JetValueArgumentList getValueArgumentList() {
                    return null;
                }

                @Override
                @NotNull
                public List<? extends ValueArgument> getValueArguments() {
                    return Collections.emptyList();
                }

                @Override
                @NotNull
                public List<JetExpression> getFunctionLiteralArguments() {
                    return Collections.emptyList();
                }

                @Override
                @NotNull
                public List<JetTypeProjection> getTypeArguments() {
                    return Collections.emptyList();
                }

                @Override
                public JetTypeArgumentList getTypeArgumentList() {
                    return null;
                }
            };
        }

        private Call stripReceiver(@NotNull Call variableCall) {
            return new DelegatingCall(variableCall){

                @Override
                @NotNull
                public ReceiverValue getExplicitReceiver() {
                    return ReceiverValue.NO_RECEIVER;
                }
            };
        }

        @Override
        @NotNull
        public Collection<ResolvedCallWithTrace<FunctionDescriptor>> transformCall(@NotNull CallCandidateResolutionContext<CallableDescriptor> context, @NotNull CallResolver callResolver, @NotNull ResolutionTask<CallableDescriptor, FunctionDescriptor> task) {
            Object descriptor = context.candidateCall.getCandidateDescriptor();
            if (descriptor instanceof FunctionDescriptor) {
                return super.transformCall(context, callResolver, task);
            }
            assert (descriptor instanceof VariableDescriptor);
            JetType returnType = descriptor.getReturnType();
            if (returnType == null) {
                return Collections.emptyList();
            }
            final ResolvedCallImpl variableResolvedCall = context.candidateCall;
            CallForImplicitInvoke functionCall = new CallForImplicitInvoke(context, task, returnType);
            DelegatingBindingTrace variableCallTrace = context.candidateCall.getTrace();
            BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(variableCallTrace, context.scope, functionCall, context.expectedType, context.dataFlowInfo, context.resolveMode, context.checkArguments, context.expressionPosition, context.resolutionResultsCache);
            OverloadResolutionResults<FunctionDescriptor> results = callResolver.resolveCallWithGivenName(basicCallResolutionContext, task.reference, Name.identifier("invoke"));
            Collection calls = ((OverloadResolutionResultsImpl)results).getResultingCalls();
            return Collections2.transform(calls, new Function<ResolvedCallWithTrace<FunctionDescriptor>, ResolvedCallWithTrace<FunctionDescriptor>>(){

                @Override
                public ResolvedCallWithTrace<FunctionDescriptor> apply(ResolvedCallWithTrace<FunctionDescriptor> functionResolvedCall) {
                    return new VariableAsFunctionResolvedCall(functionResolvedCall, variableResolvedCall);
                }
            });
        }
    };

    private CallTransformer() {
    }

    @NotNull
    public Collection<CallCandidateResolutionContext<D>> createCallContexts(@NotNull ResolutionCandidate<D> candidate, @NotNull ResolutionTask<D, F> task, @NotNull TemporaryBindingTrace candidateTrace) {
        ResolvedCallImpl<D> candidateCall = ResolvedCallImpl.create(candidate, candidateTrace, task.tracing);
        return Collections.singleton(CallCandidateResolutionContext.create(candidateCall, task, candidateTrace, task.tracing));
    }

    @NotNull
    public Collection<ResolvedCallWithTrace<F>> transformCall(@NotNull CallCandidateResolutionContext<D> callCandidateResolutionContext, @NotNull CallResolver callResolver, @NotNull ResolutionTask<D, F> task) {
        return Collections.singleton(callCandidateResolutionContext.candidateCall);
    }

    public static class CallForImplicitInvoke
    extends DelegatingCall {
        final Call outerCall;
        final CallCandidateResolutionContext<CallableDescriptor> context;
        final ExpressionReceiver receiverFromVariable;
        final JetSimpleNameExpression invokeExpression;

        private CallForImplicitInvoke(CallCandidateResolutionContext<CallableDescriptor> context, ResolutionTask<CallableDescriptor, FunctionDescriptor> task, JetType returnType) {
            super(task.call);
            this.outerCall = task.call;
            this.context = context;
            this.receiverFromVariable = new ExpressionReceiver(task.reference, returnType);
            this.invokeExpression = (JetSimpleNameExpression)JetPsiFactory.createExpression(task.call.getCallElement().getProject(), "invoke");
        }

        @Override
        @NotNull
        public ReceiverValue getExplicitReceiver() {
            return this.context.receiverForVariableAsFunctionSecondCall;
        }

        @Override
        @NotNull
        public ReceiverValue getThisObject() {
            return this.receiverFromVariable;
        }

        @Override
        public JetExpression getCalleeExpression() {
            return this.invokeExpression;
        }

        @Override
        @NotNull
        public PsiElement getCallElement() {
            JetValueArgumentList list;
            if (this.outerCall.getCallElement() instanceof JetCallElement && (list = ((JetCallElement)this.outerCall.getCallElement()).getValueArgumentList()) != null) {
                return list;
            }
            return this.invokeExpression;
        }

        @Override
        @NotNull
        public Call.CallType getCallType() {
            return Call.CallType.INVOKE;
        }

        @NotNull
        public Call getOuterCall() {
            return this.outerCall;
        }
    }
}

