/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.autocasts;

import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetRootNamespaceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.JetModuleUtil;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.autocasts.Nullability;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValueVisitor;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ScriptReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class DataFlowValueFactory {
    public static final DataFlowValueFactory INSTANCE = new DataFlowValueFactory();
    private static final IdentifierInfo NO_IDENTIFIER_INFO = new IdentifierInfo(null, false, false);

    private DataFlowValueFactory() {
    }

    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull JetExpression expression, @NotNull JetType type, @NotNull BindingContext bindingContext) {
        JetConstantExpression constantExpression;
        if (expression instanceof JetConstantExpression && (constantExpression = (JetConstantExpression)expression).getNode().getElementType() == JetNodeTypes.NULL) {
            return DataFlowValue.NULL;
        }
        if (TypeUtils.equalTypes(type, KotlinBuiltIns.getInstance().getNullableNothingType())) {
            return DataFlowValue.NULL;
        }
        IdentifierInfo result = DataFlowValueFactory.getIdForStableIdentifier(expression, bindingContext);
        return new DataFlowValue(result.id == null ? expression : result.id, type, result.isStable, this.getImmanentNullability(type));
    }

    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull ThisReceiver receiver) {
        JetType type = receiver.getType();
        return new DataFlowValue(receiver, type, true, this.getImmanentNullability(type));
    }

    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull VariableDescriptor variableDescriptor) {
        JetType type = variableDescriptor.getType();
        return new DataFlowValue(variableDescriptor, type, DataFlowValueFactory.isStableVariable(variableDescriptor), this.getImmanentNullability(type));
    }

    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull BindingContext bindingContext) {
        return receiverValue.accept(new ReceiverValueVisitor<DataFlowValue, BindingContext>(){

            @Override
            public DataFlowValue visitNoReceiver(ReceiverValue noReceiver, BindingContext data) {
                throw new IllegalArgumentException("No DataFlowValue exists for ReceiverValue.NO_RECEIVER");
            }

            @Override
            public DataFlowValue visitExtensionReceiver(ExtensionReceiver receiver, BindingContext data) {
                return DataFlowValueFactory.this.createDataFlowValue(receiver);
            }

            @Override
            public DataFlowValue visitExpressionReceiver(ExpressionReceiver receiver, BindingContext bindingContext) {
                return DataFlowValueFactory.this.createDataFlowValue(receiver.getExpression(), receiver.getType(), bindingContext);
            }

            @Override
            public DataFlowValue visitClassReceiver(ClassReceiver receiver, BindingContext data) {
                return DataFlowValueFactory.this.createDataFlowValue(receiver);
            }

            @Override
            public DataFlowValue visitTransientReceiver(TransientReceiver receiver, BindingContext data) {
                return this.createTransientDataFlowValue(receiver);
            }

            @Override
            public DataFlowValue visitScriptReceiver(ScriptReceiver receiver, BindingContext data) {
                return this.createTransientDataFlowValue(receiver);
            }

            @NotNull
            private DataFlowValue createTransientDataFlowValue(ReceiverValue receiver) {
                JetType type = receiver.getType();
                boolean nullable = type.isNullable() || TypeUtils.hasNullableSuperType(type);
                return new DataFlowValue(receiver, type, nullable, Nullability.NOT_NULL);
            }
        }, bindingContext);
    }

    private Nullability getImmanentNullability(JetType type) {
        return type.isNullable() || TypeUtils.hasNullableSuperType(type) ? Nullability.UNKNOWN : Nullability.NOT_NULL;
    }

    @NotNull
    private static IdentifierInfo createInfo(Object id, boolean isStable) {
        return new IdentifierInfo(id, isStable, false);
    }

    @NotNull
    private static IdentifierInfo createNamespaceInfo(Object id) {
        return new IdentifierInfo(id, true, true);
    }

    @NotNull
    private static IdentifierInfo combineInfo(@Nullable IdentifierInfo receiverInfo, @NotNull IdentifierInfo selectorInfo) {
        if (selectorInfo.id == null) {
            return NO_IDENTIFIER_INFO;
        }
        if (receiverInfo == null || receiverInfo == NO_IDENTIFIER_INFO || receiverInfo.isNamespace) {
            return selectorInfo;
        }
        return DataFlowValueFactory.createInfo(Pair.create(receiverInfo.id, selectorInfo.id), receiverInfo.isStable && selectorInfo.isStable);
    }

    @NotNull
    private static IdentifierInfo getIdForStableIdentifier(@Nullable JetExpression expression, @NotNull BindingContext bindingContext) {
        if (expression instanceof JetParenthesizedExpression) {
            JetParenthesizedExpression parenthesizedExpression = (JetParenthesizedExpression)expression;
            JetExpression innerExpression = parenthesizedExpression.getExpression();
            return DataFlowValueFactory.getIdForStableIdentifier(innerExpression, bindingContext);
        }
        if (expression instanceof JetQualifiedExpression) {
            JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)expression;
            JetExpression receiverExpression = qualifiedExpression.getReceiverExpression();
            JetExpression selectorExpression = qualifiedExpression.getSelectorExpression();
            IdentifierInfo receiverId = DataFlowValueFactory.getIdForStableIdentifier(receiverExpression, bindingContext);
            IdentifierInfo selectorId = DataFlowValueFactory.getIdForStableIdentifier(selectorExpression, bindingContext);
            return DataFlowValueFactory.combineInfo(receiverId, selectorId);
        }
        if (expression instanceof JetSimpleNameExpression) {
            return DataFlowValueFactory.getIdForSimpleNameExpression((JetSimpleNameExpression)expression, bindingContext);
        }
        if (expression instanceof JetThisExpression) {
            JetThisExpression thisExpression = (JetThisExpression)expression;
            DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, thisExpression.getInstanceReference());
            return DataFlowValueFactory.getIdForThisReceiver(declarationDescriptor);
        }
        if (expression instanceof JetRootNamespaceExpression) {
            return DataFlowValueFactory.createNamespaceInfo(JetModuleUtil.getRootNamespaceType(expression));
        }
        return NO_IDENTIFIER_INFO;
    }

    @NotNull
    private static IdentifierInfo getIdForSimpleNameExpression(@NotNull JetSimpleNameExpression simpleNameExpression, @NotNull BindingContext bindingContext) {
        DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, simpleNameExpression);
        if (declarationDescriptor instanceof VariableDescriptor) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall = bindingContext.get(BindingContext.RESOLVED_CALL, simpleNameExpression);
            IdentifierInfo receiverInfo = resolvedCall != null ? DataFlowValueFactory.getIdForImplicitReceiver(resolvedCall.getThisObject(), simpleNameExpression) : null;
            VariableDescriptor variableDescriptor = (VariableDescriptor)declarationDescriptor;
            return DataFlowValueFactory.combineInfo(receiverInfo, DataFlowValueFactory.createInfo(variableDescriptor, DataFlowValueFactory.isStableVariable(variableDescriptor)));
        }
        if (declarationDescriptor instanceof NamespaceDescriptor) {
            return DataFlowValueFactory.createNamespaceInfo(declarationDescriptor);
        }
        if (declarationDescriptor instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            return DataFlowValueFactory.createInfo(classDescriptor, classDescriptor.isClassObjectAValue());
        }
        return NO_IDENTIFIER_INFO;
    }

    @Nullable
    private static IdentifierInfo getIdForImplicitReceiver(@NotNull ReceiverValue receiverValue, final @Nullable JetExpression expression) {
        return receiverValue.accept(new ReceiverValueVisitor<IdentifierInfo, Void>(){

            @Override
            public IdentifierInfo visitNoReceiver(ReceiverValue noReceiver, Void data) {
                return null;
            }

            @Override
            public IdentifierInfo visitTransientReceiver(TransientReceiver receiver, Void data) {
                assert (false) : "Transient receiver is implicit for an explicit expression: " + expression + ". Receiver: " + receiver;
                return null;
            }

            @Override
            public IdentifierInfo visitExtensionReceiver(ExtensionReceiver receiver, Void data) {
                return DataFlowValueFactory.getIdForThisReceiver(receiver);
            }

            @Override
            public IdentifierInfo visitExpressionReceiver(ExpressionReceiver receiver, Void data) {
                return null;
            }

            @Override
            public IdentifierInfo visitClassReceiver(ClassReceiver receiver, Void data) {
                return DataFlowValueFactory.getIdForThisReceiver(receiver);
            }

            @Override
            public IdentifierInfo visitScriptReceiver(ScriptReceiver receiver, Void data) {
                return DataFlowValueFactory.getIdForThisReceiver(receiver);
            }
        }, null);
    }

    @NotNull
    private static IdentifierInfo getIdForThisReceiver(@NotNull ThisReceiver thisReceiver) {
        return DataFlowValueFactory.getIdForThisReceiver(thisReceiver.getDeclarationDescriptor());
    }

    @NotNull
    private static IdentifierInfo getIdForThisReceiver(@Nullable DeclarationDescriptor descriptorOfThisReceiver) {
        if (descriptorOfThisReceiver instanceof CallableDescriptor) {
            ReceiverParameterDescriptor receiverParameter = ((CallableDescriptor)descriptorOfThisReceiver).getReceiverParameter();
            assert (receiverParameter != null) : "'This' refers to the callable member without a receiver parameter: " + descriptorOfThisReceiver;
            return DataFlowValueFactory.createInfo(receiverParameter.getValue(), true);
        }
        if (descriptorOfThisReceiver instanceof ClassDescriptor) {
            return DataFlowValueFactory.createInfo(((ClassDescriptor)descriptorOfThisReceiver).getThisAsReceiverParameter().getValue(), true);
        }
        return NO_IDENTIFIER_INFO;
    }

    public static boolean isStableVariable(@NotNull VariableDescriptor variableDescriptor) {
        if (variableDescriptor.isVar()) {
            return false;
        }
        if (variableDescriptor instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
            if (!DataFlowValueFactory.invisibleFromOtherModules(propertyDescriptor)) {
                return false;
            }
            if (!DataFlowValueFactory.isFinal(propertyDescriptor)) {
                return false;
            }
            if (!DataFlowValueFactory.hasDefaultGetter(propertyDescriptor)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isFinal(PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            if (classDescriptor.getModality().isOverridable() && propertyDescriptor.getModality().isOverridable()) {
                return false;
            }
        } else if (propertyDescriptor.getModality().isOverridable()) {
            throw new IllegalStateException("Property outside a class must not be overridable: " + propertyDescriptor.getName());
        }
        return true;
    }

    private static boolean invisibleFromOtherModules(@NotNull DeclarationDescriptorWithVisibility descriptor) {
        if (Visibilities.INVISIBLE_FROM_OTHER_MODULES.contains(descriptor.getVisibility())) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (!(containingDeclaration instanceof DeclarationDescriptorWithVisibility)) {
            return false;
        }
        return DataFlowValueFactory.invisibleFromOtherModules((DeclarationDescriptorWithVisibility)containingDeclaration);
    }

    private static boolean hasDefaultGetter(PropertyDescriptor propertyDescriptor) {
        PropertyGetterDescriptor getter = propertyDescriptor.getGetter();
        return getter == null || getter.isDefault();
    }

    private static class IdentifierInfo {
        public final Object id;
        public final boolean isStable;
        public final boolean isNamespace;

        private IdentifierInfo(Object id, boolean isStable, boolean isNamespace) {
            this.id = id;
            this.isStable = isStable;
            this.isNamespace = isNamespace;
        }
    }
}

