/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ExpressionPosition;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.context.ResolveMode;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;

public final class CallCandidateResolutionContext<D extends CallableDescriptor>
extends CallResolutionContext<CallCandidateResolutionContext<D>> {
    public final ResolvedCallImpl<D> candidateCall;
    public final TracingStrategy tracing;
    public ReceiverValue receiverForVariableAsFunctionSecondCall = ReceiverValue.NO_RECEIVER;

    private CallCandidateResolutionContext(@NotNull ResolvedCallImpl<D> candidateCall, @NotNull TracingStrategy tracing, @NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull Call call, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull ResolveMode resolveMode, @NotNull CheckValueArgumentsMode checkArguments, @NotNull ExpressionPosition expressionPosition, @NotNull ResolutionResultsCache resolutionResultsCache) {
        super(trace, scope, call, expectedType, dataFlowInfo, resolveMode, checkArguments, expressionPosition, resolutionResultsCache);
        this.candidateCall = candidateCall;
        this.tracing = tracing;
    }

    public static <D extends CallableDescriptor> CallCandidateResolutionContext<D> create(@NotNull ResolvedCallImpl<D> candidateCall, @NotNull CallResolutionContext<?> context, @NotNull BindingTrace trace, @NotNull TracingStrategy tracing, @NotNull Call call) {
        candidateCall.setInitialDataFlowInfo(context.dataFlowInfo);
        return new CallCandidateResolutionContext<D>(candidateCall, tracing, trace, context.scope, call, context.expectedType, context.dataFlowInfo, context.resolveMode, context.checkArguments, context.expressionPosition, context.resolutionResultsCache);
    }

    public static <D extends CallableDescriptor> CallCandidateResolutionContext<D> create(@NotNull ResolvedCallImpl<D> candidateCall, @NotNull CallResolutionContext<?> context, @NotNull BindingTrace trace, @NotNull TracingStrategy tracing) {
        return CallCandidateResolutionContext.create(candidateCall, context, trace, tracing, context.call);
    }

    public static <D extends CallableDescriptor> CallCandidateResolutionContext<D> createForCallBeingAnalyzed(@NotNull ResolvedCallImpl<D> candidateCall, @NotNull BasicCallResolutionContext context, @NotNull TracingStrategy tracing) {
        return CallCandidateResolutionContext.createForCallBeingAnalyzed(candidateCall, context, context.call, context.resolveMode, context.checkArguments, tracing, context.resolutionResultsCache);
    }

    public static <D extends CallableDescriptor> CallCandidateResolutionContext<D> createForCallBeingAnalyzed(@NotNull ResolvedCallImpl<D> candidateCall, @NotNull ResolutionContext context, @NotNull Call call, @NotNull ResolveMode resolveMode, @NotNull CheckValueArgumentsMode checkArguments, @NotNull TracingStrategy tracing, @NotNull ResolutionResultsCache resolutionResultsCache) {
        return new CallCandidateResolutionContext<D>(candidateCall, tracing, context.trace, context.scope, call, context.expectedType, context.dataFlowInfo, resolveMode, checkArguments, context.expressionPosition, resolutionResultsCache);
    }

    @Override
    protected CallCandidateResolutionContext<D> create(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType expectedType, @NotNull ExpressionPosition expressionPosition) {
        return new CallCandidateResolutionContext<D>(this.candidateCall, this.tracing, trace, scope, this.call, expectedType, dataFlowInfo, this.resolveMode, this.checkArguments, expressionPosition, this.resolutionResultsCache);
    }

    @Override
    protected CallCandidateResolutionContext<D> self() {
        return this;
    }

    @NotNull
    public CallCandidateResolutionContext<D> replaceResolveMode(@NotNull ResolveMode newResolveMode) {
        if (newResolveMode == this.resolveMode) {
            return this;
        }
        return new CallCandidateResolutionContext<D>(this.candidateCall, this.tracing, this.trace, this.scope, this.call, this.expectedType, this.dataFlowInfo, newResolveMode, this.checkArguments, this.expressionPosition, this.resolutionResultsCache);
    }
}

