/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolvers;

public class TypeVariableResolverFromTypeDescriptors
implements TypeVariableResolver {
    @NotNull
    private final List<TypeParameterDescriptor> typeParameters;
    @NotNull
    private final DeclarationDescriptor typeParametersOwner;
    @NotNull
    private final String context;

    public TypeVariableResolverFromTypeDescriptors(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull DeclarationDescriptor owner, @NotNull String context) {
        this.typeParameters = typeParameters;
        this.typeParametersOwner = owner;
        this.context = context;
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            if (typeParameter.getContainingDeclaration() == owner) continue;
            throw new IllegalStateException();
        }
    }

    @Override
    @NotNull
    public TypeParameterDescriptor getTypeVariable(@NotNull String name) {
        return TypeVariableResolverFromTypeDescriptors.getTypeVariable(name, this.typeParameters, this.typeParametersOwner, this.context);
    }

    @NotNull
    private static TypeParameterDescriptor getTypeVariable(@NotNull String name, @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull DeclarationDescriptor owner, @NotNull String context) {
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            if (!typeParameter.getName().asString().equals(name)) continue;
            return typeParameter;
        }
        DeclarationDescriptor containingDeclaration = owner.getContainingDeclaration();
        if (containingDeclaration != null) {
            return TypeVariableResolverFromTypeDescriptors.getTypeVariable(name, TypeVariableResolvers.getTypeParameterDescriptors((ClassOrNamespaceDescriptor)containingDeclaration), containingDeclaration, context);
        }
        throw new RuntimeException("type parameter not found by name '" + name + "' in " + context);
    }
}

