/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorParent;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.AbiVersionUtil;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;
import org.jetbrains.jet.lang.resolve.java.JavaBridgeConfiguration;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaNamespaceKind;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaNamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.kt.JetPackageClassAnnotation;
import org.jetbrains.jet.lang.resolve.java.provider.MembersCache;
import org.jetbrains.jet.lang.resolve.java.scope.JavaBaseScope;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassStaticMembersScope;
import org.jetbrains.jet.lang.resolve.java.scope.JavaPackageScopeWithoutMembers;
import org.jetbrains.jet.lang.resolve.java.scope.JavaScopeForKotlinNamespace;
import org.jetbrains.jet.lang.resolve.name.FqName;

public final class JavaNamespaceResolver {
    @NotNull
    public static final ModuleDescriptor FAKE_ROOT_MODULE = new ModuleDescriptorImpl(JavaDescriptorResolver.JAVA_ROOT, JavaBridgeConfiguration.ALL_JAVA_IMPORTS, JavaToKotlinClassMap.getInstance());
    @NotNull
    private final Map<FqName, JavaBaseScope> resolvedNamespaceCache = Maps.newHashMap();
    @NotNull
    private final Set<FqName> unresolvedCache = Sets.newHashSet();
    private PsiClassFinder psiClassFinder;
    private BindingTrace trace;
    private JavaSemanticServices javaSemanticServices;

    public void setPsiClassFinder(PsiClassFinder psiClassFinder) {
        this.psiClassFinder = psiClassFinder;
    }

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void setJavaSemanticServices(JavaSemanticServices javaSemanticServices) {
        this.javaSemanticServices = javaSemanticServices;
    }

    @Nullable
    public NamespaceDescriptor resolveNamespace(@NotNull FqName qualifiedName, @NotNull DescriptorSearchRule searchRule) {
        NamespaceDescriptor kotlinNamespaceDescriptor = this.javaSemanticServices.getKotlinNamespaceDescriptor(qualifiedName);
        if (kotlinNamespaceDescriptor != null) {
            return searchRule.processFoundInKotlin(kotlinNamespaceDescriptor);
        }
        if (this.unresolvedCache.contains(qualifiedName)) {
            return null;
        }
        JavaBaseScope scope = this.resolvedNamespaceCache.get(qualifiedName);
        if (scope != null) {
            return (NamespaceDescriptor)scope.getContainingDeclaration();
        }
        NamespaceDescriptorParent parentNs = this.resolveParentNamespace(qualifiedName);
        if (parentNs == null) {
            return null;
        }
        JavaNamespaceDescriptor javaNamespaceDescriptor = new JavaNamespaceDescriptor(parentNs, Collections.<AnnotationDescriptor>emptyList(), qualifiedName);
        JavaBaseScope newScope = this.createNamespaceScope(qualifiedName, javaNamespaceDescriptor);
        if (newScope == null) {
            return null;
        }
        this.trace.record(BindingContext.NAMESPACE, newScope.getPsiElement(), javaNamespaceDescriptor);
        javaNamespaceDescriptor.setMemberScope(newScope);
        return javaNamespaceDescriptor;
    }

    @Nullable
    public NamespaceDescriptor resolveNamespace(@NotNull FqName qualifiedName) {
        return this.resolveNamespace(qualifiedName, DescriptorSearchRule.ERROR_IF_FOUND_IN_KOTLIN);
    }

    @Nullable
    private NamespaceDescriptorParent resolveParentNamespace(@NotNull FqName fqName) {
        if (fqName.isRoot()) {
            return FAKE_ROOT_MODULE;
        }
        return this.resolveNamespace(fqName.parent(), DescriptorSearchRule.INCLUDE_KOTLIN);
    }

    @Nullable
    private JavaBaseScope createNamespaceScope(@NotNull FqName fqName, @NotNull NamespaceDescriptor namespaceDescriptor) {
        JavaBaseScope namespaceScope = this.doCreateNamespaceScope(fqName, namespaceDescriptor);
        this.cache(fqName, namespaceScope);
        return namespaceScope;
    }

    @Nullable
    private JavaBaseScope doCreateNamespaceScope(@NotNull FqName fqName, @NotNull NamespaceDescriptor namespaceDescriptor) {
        PsiPackage psiPackage = this.psiClassFinder.findPsiPackage(fqName);
        if (psiPackage != null) {
            PsiClass psiClass = this.getPsiClassForJavaPackageScope(fqName);
            this.trace.record(JavaBindingContext.JAVA_NAMESPACE_KIND, namespaceDescriptor, JavaNamespaceKind.PROPER);
            if (psiClass == null) {
                return new JavaPackageScopeWithoutMembers(namespaceDescriptor, this.javaSemanticServices.getPsiDeclarationProviderFactory().createDeclarationProviderForNamespaceWithoutMembers(psiPackage), fqName, this.javaSemanticServices);
            }
            AbiVersionUtil.checkAbiVersion(psiClass, JetPackageClassAnnotation.get(psiClass), this.trace);
            return new JavaScopeForKotlinNamespace(namespaceDescriptor, this.javaSemanticServices.getPsiDeclarationProviderFactory().createDeclarationForKotlinNamespace(psiPackage, psiClass), fqName, this.javaSemanticServices);
        }
        PsiClass psiClass = this.psiClassFinder.findPsiClass(fqName, PsiClassFinder.RuntimeClassesHandleMode.IGNORE);
        if (psiClass == null) {
            return null;
        }
        if (DescriptorResolverUtils.isKotlinClass(psiClass)) {
            return null;
        }
        if (!JavaNamespaceResolver.hasStaticMembers(psiClass)) {
            return null;
        }
        this.trace.record(JavaBindingContext.JAVA_NAMESPACE_KIND, namespaceDescriptor, JavaNamespaceKind.CLASS_STATICS);
        return new JavaClassStaticMembersScope(namespaceDescriptor, this.javaSemanticServices.getPsiDeclarationProviderFactory().createDeclarationProviderForClassStaticMembers(psiClass), fqName, this.javaSemanticServices);
    }

    private void cache(@NotNull FqName fqName, @Nullable JavaBaseScope packageScope) {
        if (packageScope == null) {
            this.unresolvedCache.add(fqName);
            return;
        }
        JavaBaseScope oldValue = this.resolvedNamespaceCache.put(fqName, packageScope);
        if (oldValue != null) {
            throw new IllegalStateException("rewrite at " + fqName);
        }
    }

    @Nullable
    public JavaBaseScope getJavaPackageScopeForExistingNamespaceDescriptor(@NotNull NamespaceDescriptor namespaceDescriptor) {
        FqName fqName = DescriptorUtils.getFQName(namespaceDescriptor).toSafe();
        if (this.unresolvedCache.contains(fqName)) {
            throw new IllegalStateException("This means that we are trying to create a Java package, but have a package with the same FQN defined in Kotlin: " + fqName);
        }
        JavaBaseScope alreadyResolvedScope = this.resolvedNamespaceCache.get(fqName);
        if (alreadyResolvedScope != null) {
            return alreadyResolvedScope;
        }
        return this.createNamespaceScope(fqName, namespaceDescriptor);
    }

    @Nullable
    private PsiClass getPsiClassForJavaPackageScope(@NotNull FqName packageFQN) {
        return this.psiClassFinder.findPsiClass(PackageClassUtils.getPackageClassFqName(packageFQN), PsiClassFinder.RuntimeClassesHandleMode.IGNORE);
    }

    private static boolean hasStaticMembers(@NotNull PsiClass psiClass) {
        for (PsiMember psiMember : ContainerUtil.concat(psiClass.getMethods(), psiClass.getFields())) {
            if (!psiMember.hasModifierProperty("static") || DescriptorResolverUtils.shouldBeInEnumClassObject(psiMember)) continue;
            return true;
        }
        for (PsiClass nestedClass : psiClass.getInnerClasses()) {
            if (MembersCache.isSamInterface(nestedClass)) {
                return true;
            }
            if (!nestedClass.hasModifierProperty("static") || !JavaNamespaceResolver.hasStaticMembers(nestedClass)) continue;
            return true;
        }
        return false;
    }
}

