/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.Importer;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.lazy.ImportsProvider;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeSelectorUtil;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;

public class LazyImportScope
implements JetScope {
    private final ResolveSession resolveSession;
    private final NamespaceDescriptor packageDescriptor;
    private final ImportsProvider importsProvider;
    private final JetScope rootScope;
    private final BindingTrace traceForImportResolve;
    private final String debugName;
    private final Map<JetImportDirective, ImportResolveStatus> importedScopes = Maps.newHashMap();
    private JetImportDirective directiveUnderResolve = null;

    public LazyImportScope(@NotNull ResolveSession resolveSession, @NotNull NamespaceDescriptor packageDescriptor, @NotNull List<JetImportDirective> imports, @NotNull BindingTrace traceForImportResolve, @NotNull String debugName) {
        this.resolveSession = resolveSession;
        this.packageDescriptor = packageDescriptor;
        this.importsProvider = new ImportsProvider(imports);
        this.traceForImportResolve = traceForImportResolve;
        this.debugName = debugName;
        NamespaceDescriptor rootPackageDescriptor = resolveSession.getPackageDescriptorByFqName(FqName.ROOT);
        if (rootPackageDescriptor == null) {
            throw new IllegalStateException("Root package not found");
        }
        this.rootScope = rootPackageDescriptor.getMemberScope();
    }

    public static LazyImportScope createImportScopeForFile(@NotNull ResolveSession resolveSession, @NotNull NamespaceDescriptor packageDescriptor, @NotNull JetFile jetFile, @NotNull BindingTrace traceForImportResolve, @NotNull String debugName) {
        return new LazyImportScope(resolveSession, packageDescriptor, Lists.reverse(jetFile.getImportDirectives()), traceForImportResolve, debugName);
    }

    @Nullable
    private <D extends DeclarationDescriptor> D selectFirstFromImports(Name name, QualifiedExpressionResolver.LookupMode lookupMode, JetScopeSelectorUtil.ScopeByNameSelector<D> descriptorSelector) {
        for (JetImportDirective directive : this.importsProvider.getImports(name)) {
            if (directive == this.directiveUnderResolve) {
                return null;
            }
            D foundDescriptor = descriptorSelector.get(this.getImportScope(directive, lookupMode), name);
            if (foundDescriptor == null) continue;
            return foundDescriptor;
        }
        return null;
    }

    @NotNull
    private <D extends DeclarationDescriptor> Collection<D> collectFromImports(Name name, QualifiedExpressionResolver.LookupMode lookupMode, JetScopeSelectorUtil.ScopeByNameMultiSelector<D> descriptorsSelector) {
        HashSet<D> descriptors = Sets.newHashSet();
        for (JetImportDirective directive : this.importsProvider.getImports(name)) {
            if (directive == this.directiveUnderResolve) {
                throw new IllegalStateException("Recursion while resolving many imports: " + directive.getText());
            }
            descriptors.addAll(descriptorsSelector.get(this.getImportScope(directive, lookupMode), name));
        }
        return descriptors;
    }

    @NotNull
    private <D extends DeclarationDescriptor> Collection<D> collectFromImports(QualifiedExpressionResolver.LookupMode lookupMode, JetScopeSelectorUtil.ScopeDescriptorSelector<D> descriptorsSelector) {
        HashSet<D> descriptors = Sets.newHashSet();
        for (JetImportDirective directive : this.importsProvider.getAllImports()) {
            if (directive == this.directiveUnderResolve) {
                throw new IllegalStateException("Recursion while resolving many imports: " + directive.getText());
            }
            descriptors.addAll(descriptorsSelector.get(this.getImportScope(directive, lookupMode)));
        }
        return descriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private JetScope getImportScope(JetImportDirective directive, QualifiedExpressionResolver.LookupMode lookupMode) {
        ImportResolveStatus status = this.importedScopes.get(directive);
        if (status != null && (lookupMode == status.lookupMode || status.lookupMode == QualifiedExpressionResolver.LookupMode.EVERYTHING)) {
            return status.scope;
        }
        WritableScopeImpl directiveImportScope = new WritableScopeImpl(JetScope.EMPTY, this.packageDescriptor, RedeclarationHandler.DO_NOTHING, "Scope for import '" + directive.getText() + "' resolve in " + this.toString());
        directiveImportScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        Importer.StandardImporter importer = new Importer.StandardImporter(directiveImportScope);
        this.directiveUnderResolve = directive;
        try {
            this.resolveSession.getInjector().getQualifiedExpressionResolver().processImportReference(directive, this.rootScope, this.packageDescriptor.getMemberScope(), importer, this.traceForImportResolve, this.resolveSession.getRootModuleDescriptor(), lookupMode);
        }
        finally {
            this.directiveUnderResolve = null;
            directiveImportScope.changeLockLevel(WritableScope.LockLevel.READING);
            this.importedScopes.put(directive, new ImportResolveStatus(lookupMode, directiveImportScope));
        }
        return directiveImportScope;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        return this.selectFirstFromImports(name, QualifiedExpressionResolver.LookupMode.ONLY_CLASSES, JetScopeSelectorUtil.CLASSIFIER_DESCRIPTOR_SCOPE_SELECTOR);
    }

    @Override
    @Nullable
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        return this.selectFirstFromImports(name, QualifiedExpressionResolver.LookupMode.ONLY_CLASSES, JetScopeSelectorUtil.NAMED_OBJECT_SCOPE_SELECTOR);
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> getObjectDescriptors() {
        return this.collectFromImports(QualifiedExpressionResolver.LookupMode.ONLY_CLASSES, JetScopeSelectorUtil.OBJECTS_SCOPE_SELECTOR);
    }

    @Override
    @Nullable
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        return this.selectFirstFromImports(name, QualifiedExpressionResolver.LookupMode.ONLY_CLASSES, JetScopeSelectorUtil.NAMESPACE_SCOPE_SELECTOR);
    }

    @Override
    @NotNull
    public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
        return this.collectFromImports(name, QualifiedExpressionResolver.LookupMode.EVERYTHING, JetScopeSelectorUtil.NAMED_PROPERTIES_SCOPE_SELECTOR);
    }

    @Override
    @Nullable
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        return null;
    }

    @Override
    @NotNull
    public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
        return this.collectFromImports(name, QualifiedExpressionResolver.LookupMode.EVERYTHING, JetScopeSelectorUtil.NAMED_FUNCTION_SCOPE_SELECTOR);
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.packageDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public PropertyDescriptor getPropertyByFieldReference(@NotNull Name fieldName) {
        return null;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        return this.collectFromImports(QualifiedExpressionResolver.LookupMode.EVERYTHING, JetScopeSelectorUtil.ALL_DESCRIPTORS_SCOPE_SELECTOR);
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        return Collections.emptyList();
    }

    public String toString() {
        return "LazyImportScope: " + this.debugName;
    }

    private static class ImportResolveStatus {
        private final QualifiedExpressionResolver.LookupMode lookupMode;
        private final JetScope scope;

        ImportResolveStatus(QualifiedExpressionResolver.LookupMode lookupMode, JetScope scope) {
            this.lookupMode = lookupMode;
            this.scope = scope;
        }
    }
}

