/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.lazy.LazyDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.lazy.RecursionIntolerantLazyValue;

public class LazyTypeParameterDescriptor
implements TypeParameterDescriptor,
LazyDescriptor {
    private final ResolveSession resolveSession;
    private final JetTypeParameter jetTypeParameter;
    private final Variance variance;
    private final boolean reified;
    private final int index;
    private final LazyClassDescriptor containingDeclaration;
    private final Name name;
    private final NotNullLazyValue<TypeConstructor> typeConstructor;
    private final NotNullLazyValue<JetType> defaultType;
    private final NotNullLazyValue<Set<JetType>> upperBounds;
    private final NotNullLazyValue<JetType> upperBoundsAsType;

    public LazyTypeParameterDescriptor(@NotNull ResolveSession resolveSession, @NotNull LazyClassDescriptor containingDeclaration, @NotNull JetTypeParameter jetTypeParameter, int index) {
        this.resolveSession = resolveSession;
        this.jetTypeParameter = jetTypeParameter;
        this.variance = jetTypeParameter.getVariance();
        this.containingDeclaration = containingDeclaration;
        this.index = index;
        this.name = jetTypeParameter.getNameAsName();
        this.reified = jetTypeParameter.hasModifier(JetTokens.REIFIED_KEYWORD);
        StorageManager storageManager = resolveSession.getStorageManager();
        this.typeConstructor = storageManager.createLazyValue(new Computable<TypeConstructor>(){

            @Override
            public TypeConstructor compute() {
                return LazyTypeParameterDescriptor.this.createTypeConstructor();
            }
        });
        this.defaultType = storageManager.createLazyValue(new Computable<JetType>(){

            @Override
            public JetType compute() {
                return LazyTypeParameterDescriptor.this.createDefaultType();
            }
        });
        this.upperBounds = storageManager.createLazyValue(new Computable<Set<JetType>>(){

            @Override
            public Set<JetType> compute() {
                return LazyTypeParameterDescriptor.this.resolveUpperBounds();
            }
        });
        this.upperBoundsAsType = storageManager.createLazyValue(new Computable<JetType>(){

            @Override
            public JetType compute() {
                return LazyTypeParameterDescriptor.this.computeUpperBoundsAsType();
            }
        });
    }

    @Override
    public boolean isReified() {
        return this.reified;
    }

    @Override
    public Variance getVariance() {
        return this.variance;
    }

    @Override
    @NotNull
    public Set<JetType> getUpperBounds() {
        return this.upperBounds.compute();
    }

    @NotNull
    private Set<JetType> resolveUpperBounds() {
        LinkedHashSet<JetType> upperBounds = Sets.newLinkedHashSet();
        JetTypeParameter jetTypeParameter = this.jetTypeParameter;
        this.resolveUpperBoundsFromWhereClause(upperBounds, false);
        JetTypeReference extendsBound = jetTypeParameter.getExtendsBound();
        if (extendsBound != null) {
            upperBounds.add(this.resolveBoundType(extendsBound));
        }
        if (upperBounds.isEmpty()) {
            upperBounds.add(KotlinBuiltIns.getInstance().getDefaultBound());
        }
        return upperBounds;
    }

    private void resolveUpperBoundsFromWhereClause(Set<JetType> upperBounds, boolean forClassObject) {
        JetClassOrObject classOrObject = PsiTreeUtil.getParentOfType((PsiElement)this.jetTypeParameter, JetClassOrObject.class);
        if (classOrObject instanceof JetClass) {
            JetClass jetClass = (JetClass)classOrObject;
            for (JetTypeConstraint jetTypeConstraint : jetClass.getTypeConstraints()) {
                JetTypeReference boundTypeReference;
                JetSimpleNameExpression constrainedParameterName;
                if (jetTypeConstraint.isClassObjectContraint() != forClassObject || (constrainedParameterName = jetTypeConstraint.getSubjectTypeParameterName()) == null || !this.name.equals(constrainedParameterName.getReferencedNameAsName()) || (boundTypeReference = jetTypeConstraint.getBoundTypeReference()) == null) continue;
                upperBounds.add(this.resolveBoundType(boundTypeReference));
            }
        }
    }

    private JetType resolveBoundType(@NotNull JetTypeReference boundTypeReference) {
        return this.resolveSession.getInjector().getTypeResolver().resolveType(this.containingDeclaration.getScopeForClassHeaderResolution(), boundTypeReference, this.resolveSession.getTrace(), false);
    }

    @Override
    @NotNull
    public JetType getUpperBoundsAsType() {
        return this.upperBoundsAsType.compute();
    }

    @NotNull
    private JetType computeUpperBoundsAsType() {
        Set<JetType> upperBounds = this.getUpperBounds();
        assert (upperBounds.size() > 0) : "Upper bound list is empty in " + this.getName();
        JetType upperBoundsAsType = TypeUtils.intersect(JetTypeChecker.INSTANCE, upperBounds);
        if (upperBoundsAsType == null) {
            upperBoundsAsType = KotlinBuiltIns.getInstance().getNothingType();
        }
        return upperBoundsAsType;
    }

    @Override
    @NotNull
    public Set<JetType> getLowerBounds() {
        return Collections.singleton(this.getLowerBoundsAsType());
    }

    @Override
    @NotNull
    public JetType getLowerBoundsAsType() {
        return KotlinBuiltIns.getInstance().getNothingType();
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor.compute();
    }

    @NotNull
    private TypeConstructor createTypeConstructor() {
        return new TypeConstructor(){

            @Override
            @NotNull
            public Collection<JetType> getSupertypes() {
                return LazyTypeParameterDescriptor.this.getUpperBounds();
            }

            @Override
            @NotNull
            public List<TypeParameterDescriptor> getParameters() {
                return Collections.emptyList();
            }

            @Override
            public boolean isSealed() {
                return false;
            }

            @Override
            public ClassifierDescriptor getDeclarationDescriptor() {
                return LazyTypeParameterDescriptor.this;
            }

            @Override
            public List<AnnotationDescriptor> getAnnotations() {
                return LazyTypeParameterDescriptor.this.getAnnotations();
            }

            public String toString() {
                return LazyTypeParameterDescriptor.this.getName().toString();
            }
        };
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        return this.defaultType.compute();
    }

    @NotNull
    private JetType createDefaultType() {
        return new JetTypeImpl(this.getTypeConstructor(), new LazyScopeAdapter(new RecursionIntolerantLazyValue<JetScope>(){

            @Override
            protected JetScope compute() {
                return LazyTypeParameterDescriptor.this.getUpperBoundsAsType().getMemberScope();
            }
        }));
    }

    @Override
    public JetType getClassObjectType() {
        return null;
    }

    @Override
    public boolean isClassObjectAValue() {
        return false;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        return this;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.containingDeclaration;
    }

    @Override
    @Deprecated
    @NotNull
    public TypeParameterDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        throw new UnsupportedOperationException("Don't call substitute() on type parameters");
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitTypeParameterDescriptor(this, data);
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor) {
        visitor.visitTypeParameterDescriptor(this, null);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public List<AnnotationDescriptor> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    public String toString() {
        return this.getName().toString();
    }

    @Override
    public void forceResolveAllContents() {
        this.getAnnotations();
        this.getClassObjectType();
        this.getContainingDeclaration();
        this.getDefaultType();
        this.getIndex();
        this.getLowerBounds();
        this.getLowerBoundsAsType();
        this.getOriginal();
        this.getTypeConstructor();
        this.getUpperBounds();
        this.getUpperBoundsAsType();
        this.getVariance();
    }
}

