/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.lang;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.LocalTimeCounter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.DefaultModuleConfiguration;
import org.jetbrains.jet.lang.ModuleConfiguration;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.lazy.storage.LockBasedStorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;
import org.jetbrains.jet.plugin.JetFileType;

public class KotlinBuiltIns {
    public static final JetScope STUB = JetScope.EMPTY;
    public static final String BUILT_INS_DIR = "jet";
    private static final Name BUILT_INS_PACKAGE_NAME = Name.identifier("jet");
    public static final FqName BUILT_INS_PACKAGE_FQ_NAME = FqName.topLevel(BUILT_INS_PACKAGE_NAME);
    private static final List<String> LIBRARY_FILES = Arrays.asList("jet/Library.jet", "jet/Numbers.jet", "jet/Ranges.jet", "jet/Progressions.jet", "jet/Iterators.jet", "jet/Arrays.jet", "jet/Enum.jet", "jet/Collections.jet", "jet/Any.jet", "jet/ExtensionFunctions.jet", "jet/Functions.jet", "jet/KFunctions.jet", "jet/KMemberFunctions.jet", "jet/KExtensionFunctions.jet", "jet/Nothing.jet", "jet/Unit.jet");
    public static final int FUNCTION_TRAIT_COUNT = 23;
    private static volatile KotlinBuiltIns instance = null;
    private static volatile boolean initializing;
    private static Throwable initializationFailed;
    private final KotlinCodeAnalyzer analyzer;
    private final ModuleDescriptorImpl builtInsModule;
    private volatile ImmutableSet<ClassDescriptor> nonPhysicalClasses;
    private final ImmutableSet<ClassDescriptor> functionClassesSet;
    private final ImmutableSet<ClassDescriptor> extensionFunctionClassesSet;
    private final EnumMap<PrimitiveType, ClassDescriptor> primitiveTypeToClass;
    private final EnumMap<PrimitiveType, ClassDescriptor> primitiveTypeToArrayClass;
    private final EnumMap<PrimitiveType, JetType> primitiveTypeToJetType;
    private final EnumMap<PrimitiveType, JetType> primitiveTypeToNullableJetType;
    private final EnumMap<PrimitiveType, JetType> primitiveTypeToArrayJetType;
    private final Map<JetType, JetType> primitiveJetTypeToJetArrayType;
    private final Map<JetType, JetType> jetArrayTypeToPrimitiveJetType;
    private final ClassDescriptor nothingClass;
    private final ClassDescriptor arrayClass;
    private final ClassDescriptor deprecatedAnnotationClass;
    private final ClassDescriptor dataAnnotationClass;
    private final ClassDescriptor[] functionClasses;
    private volatile JetType anyType;
    private volatile JetType nullableAnyType;
    private volatile JetType nothingType;
    private volatile JetType nullableNothingType;
    private volatile JetType unitType;
    private volatile JetType stringType;
    private volatile JetType annotationType;

    public static synchronized void initialize(@NotNull Project project, @NotNull InitializationMode initializationMode) {
        if (instance == null) {
            if (initializationFailed != null) {
                throw new RuntimeException("builtin library initialization failed previously: " + initializationFailed, initializationFailed);
            }
            if (initializing) {
                throw new IllegalStateException("builtin library initialization loop");
            }
            initializing = true;
            try {
                instance = new KotlinBuiltIns(project);
                instance.initialize(initializationMode == InitializationMode.MULTI_THREADED);
            }
            catch (Throwable e) {
                initializationFailed = e;
                throw new RuntimeException("builtin library initialization failed: " + e, e);
            }
            finally {
                initializing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static KotlinBuiltIns getInstance() {
        if (initializing) {
            Class<KotlinBuiltIns> clazz = KotlinBuiltIns.class;
            synchronized (KotlinBuiltIns.class) {
                assert (instance != null) : "Built-ins are not initialized (note: We are under the same lock as initializing and instance)";
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }
        if (instance == null) {
            throw new IllegalStateException("Initialize standard library first");
        }
        return instance;
    }

    private KotlinBuiltIns(@NotNull Project project) {
        try {
            this.builtInsModule = new ModuleDescriptorImpl(Name.special("<built-ins lazy module>"), DefaultModuleConfiguration.DEFAULT_JET_IMPORTS, PlatformToKotlinClassMap.EMPTY);
            this.builtInsModule.setModuleConfiguration(ModuleConfiguration.EMPTY);
            this.analyzer = this.createLazyResolveSession(project);
            this.functionClassesSet = this.computeIndexedClasses("Function", 23);
            this.extensionFunctionClassesSet = this.computeIndexedClasses("ExtensionFunction", 23);
            this.primitiveTypeToClass = new EnumMap(PrimitiveType.class);
            this.primitiveTypeToJetType = new EnumMap(PrimitiveType.class);
            this.primitiveTypeToNullableJetType = new EnumMap(PrimitiveType.class);
            this.primitiveTypeToArrayClass = new EnumMap(PrimitiveType.class);
            this.primitiveTypeToArrayJetType = new EnumMap(PrimitiveType.class);
            this.primitiveJetTypeToJetArrayType = new HashMap<JetType, JetType>();
            this.jetArrayTypeToPrimitiveJetType = new HashMap<JetType, JetType>();
            this.nothingClass = this.getBuiltInClassByName("Nothing");
            this.arrayClass = this.getBuiltInClassByName("Array");
            this.deprecatedAnnotationClass = this.getBuiltInClassByName("deprecated");
            this.dataAnnotationClass = this.getBuiltInClassByName("data");
            this.functionClasses = new ClassDescriptor[23];
            for (int i = 0; i < this.functionClasses.length; ++i) {
                this.functionClasses[i] = this.getBuiltInClassByName("Function" + i);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void initialize(boolean forceResolveAll) {
        this.anyType = this.getBuiltInTypeByClassName("Any");
        this.nullableAnyType = TypeUtils.makeNullable(this.anyType);
        this.nothingType = this.getBuiltInTypeByClassName("Nothing");
        this.nullableNothingType = TypeUtils.makeNullable(this.nothingType);
        this.unitType = this.getBuiltInTypeByClassName("Unit");
        this.stringType = this.getBuiltInTypeByClassName("String");
        this.annotationType = this.getBuiltInTypeByClassName("Annotation");
        for (PrimitiveType primitive : PrimitiveType.values()) {
            this.makePrimitive(primitive);
        }
        this.nonPhysicalClasses = this.computeNonPhysicalClasses();
        if (forceResolveAll) {
            this.analyzer.forceResolveAll();
        }
        AnalyzingUtils.throwExceptionOnErrors(this.analyzer.getBindingContext());
    }

    @NotNull
    private KotlinCodeAnalyzer createLazyResolveSession(@NotNull Project project) throws IOException {
        List<JetFile> files = KotlinBuiltIns.loadResourcesAsJetFiles(project, LIBRARY_FILES);
        LockBasedStorageManager storageManager = new LockBasedStorageManager();
        return new ResolveSession(project, storageManager, this.builtInsModule, new FileBasedDeclarationProviderFactory(storageManager, files), ResolveSession.NO_ALIASES, Predicates.in(Sets.newHashSet(new FqNameUnsafe("jet.Any"), new FqNameUnsafe("jet.Nothing"))), new BindingTraceContext());
    }

    @NotNull
    private static List<JetFile> loadResourcesAsJetFiles(@NotNull Project project, @NotNull List<String> libraryFiles) throws IOException, ProcessCanceledException {
        LinkedList<JetFile> files = new LinkedList<JetFile>();
        for (String path : libraryFiles) {
            InputStream stream = KotlinBuiltIns.class.getClassLoader().getResourceAsStream(path);
            if (stream == null) {
                throw new IllegalStateException("Resource not found in classpath: " + path);
            }
            String text = FileUtil.loadTextAndClose(new InputStreamReader(stream));
            JetFile file = (JetFile)PsiFileFactory.getInstance(project).createFileFromText(path, JetFileType.INSTANCE, (CharSequence)StringUtil.convertLineSeparators(text), LocalTimeCounter.currentTime(), true, false);
            files.add(file);
        }
        return files;
    }

    private void makePrimitive(PrimitiveType primitiveType) {
        ClassDescriptor theClass = this.getBuiltInClassByName(primitiveType.getTypeName().asString());
        JetTypeImpl type = new JetTypeImpl(theClass);
        ClassDescriptor arrayClass = this.getBuiltInClassByName(primitiveType.getArrayTypeName().asString());
        JetTypeImpl arrayType = new JetTypeImpl(arrayClass);
        this.primitiveTypeToClass.put(primitiveType, theClass);
        this.primitiveTypeToJetType.put(primitiveType, type);
        this.primitiveTypeToNullableJetType.put(primitiveType, TypeUtils.makeNullable(type));
        this.primitiveTypeToArrayClass.put(primitiveType, arrayClass);
        this.primitiveTypeToArrayJetType.put(primitiveType, arrayType);
        this.primitiveJetTypeToJetArrayType.put(type, arrayType);
        this.jetArrayTypeToPrimitiveJetType.put(arrayType, type);
    }

    @NotNull
    public ModuleDescriptorImpl getBuiltInsModule() {
        return this.builtInsModule;
    }

    @NotNull
    public NamespaceDescriptor getBuiltInsPackage() {
        NamespaceDescriptor namespace = this.getBuiltInsModule().getNamespace(BUILT_INS_PACKAGE_FQ_NAME);
        assert (namespace != null) : "Built ins namespace not found: " + BUILT_INS_PACKAGE_FQ_NAME;
        return namespace;
    }

    @NotNull
    public FqName getBuiltInsPackageFqName() {
        return this.getBuiltInsPackage().getFqName();
    }

    @NotNull
    public JetScope getBuiltInsScope() {
        return this.getBuiltInsPackage().getMemberScope();
    }

    @NotNull
    public ClassDescriptor getBuiltInClassByName(@NotNull Name simpleName) {
        ClassifierDescriptor classifier = this.getBuiltInsScope().getClassifier(simpleName);
        assert (classifier instanceof ClassDescriptor) : "Must be a class descriptor " + simpleName + ", but was " + classifier;
        return (ClassDescriptor)classifier;
    }

    @NotNull
    private ClassDescriptor getBuiltInClassByName(@NotNull String simpleName) {
        return this.getBuiltInClassByName(Name.identifier(simpleName));
    }

    @NotNull
    public ClassDescriptor getAny() {
        return this.getBuiltInClassByName("Any");
    }

    @NotNull
    public ClassDescriptor getNothing() {
        return this.getBuiltInClassByName("Nothing");
    }

    @NotNull
    public ClassDescriptor getPrimitiveClassDescriptor(@NotNull PrimitiveType type) {
        return this.getBuiltInClassByName(type.getTypeName().asString());
    }

    @NotNull
    public ClassDescriptor getByte() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.BYTE);
    }

    @NotNull
    public ClassDescriptor getShort() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.SHORT);
    }

    @NotNull
    public ClassDescriptor getInt() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.INT);
    }

    @NotNull
    public ClassDescriptor getLong() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.LONG);
    }

    @NotNull
    public ClassDescriptor getFloat() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.FLOAT);
    }

    @NotNull
    public ClassDescriptor getDouble() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.DOUBLE);
    }

    @NotNull
    public ClassDescriptor getChar() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.CHAR);
    }

    @NotNull
    public ClassDescriptor getBoolean() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.BOOLEAN);
    }

    @NotNull
    public Set<DeclarationDescriptor> getIntegralRanges() {
        return ImmutableSet.of(this.getBuiltInClassByName("ByteRange"), this.getBuiltInClassByName("ShortRange"), this.getBuiltInClassByName("CharRange"), this.getBuiltInClassByName("IntRange"), this.getBuiltInClassByName("LongRange"));
    }

    @NotNull
    public ClassDescriptor getArray() {
        return this.getBuiltInClassByName("Array");
    }

    @NotNull
    public ClassDescriptor getPrimitiveArrayClassDescriptor(@NotNull PrimitiveType type) {
        return this.getBuiltInClassByName(type.getArrayTypeName().asString());
    }

    @NotNull
    public ClassDescriptor getNumber() {
        return this.getBuiltInClassByName("Number");
    }

    @NotNull
    public ClassDescriptor getUnit() {
        return this.getBuiltInClassByName("Unit");
    }

    @NotNull
    public ClassDescriptor getFunction(int parameterCount) {
        return this.getBuiltInClassByName("Function" + parameterCount);
    }

    @NotNull
    public ClassDescriptor getExtensionFunction(int parameterCount) {
        return this.getBuiltInClassByName("ExtensionFunction" + parameterCount);
    }

    @NotNull
    public ClassDescriptor getKFunction(int parameterCount) {
        return this.getBuiltInClassByName("KFunction" + parameterCount);
    }

    @NotNull
    public ClassDescriptor getKMemberFunction(int parameterCount) {
        return this.getBuiltInClassByName("KMemberFunction" + parameterCount);
    }

    @NotNull
    public ClassDescriptor getKExtensionFunction(int parameterCount) {
        return this.getBuiltInClassByName("KExtensionFunction" + parameterCount);
    }

    @NotNull
    public ClassDescriptor getThrowable() {
        return this.getBuiltInClassByName("Throwable");
    }

    @NotNull
    public ClassDescriptor getDataClassAnnotation() {
        return this.getBuiltInClassByName("data");
    }

    @NotNull
    public ClassDescriptor getVolatileAnnotationClass() {
        return this.getBuiltInClassByName("volatile");
    }

    @NotNull
    public ClassDescriptor getDeprecatedAnnotation() {
        return this.getBuiltInClassByName("deprecated");
    }

    @NotNull
    public ClassDescriptor getString() {
        return this.getBuiltInClassByName("String");
    }

    @NotNull
    public ClassDescriptor getCharSequence() {
        return this.getBuiltInClassByName("CharSequence");
    }

    @NotNull
    public ClassDescriptor getComparable() {
        return this.getBuiltInClassByName("Comparable");
    }

    @NotNull
    public ClassDescriptor getEnum() {
        return this.getBuiltInClassByName("Enum");
    }

    @NotNull
    public ClassDescriptor getAnnotation() {
        return this.getBuiltInClassByName("Annotation");
    }

    @NotNull
    public ClassDescriptor getIterator() {
        return this.getBuiltInClassByName("Iterator");
    }

    @NotNull
    public ClassDescriptor getIterable() {
        return this.getBuiltInClassByName("Iterable");
    }

    @NotNull
    public ClassDescriptor getMutableIterable() {
        return this.getBuiltInClassByName("MutableIterable");
    }

    @NotNull
    public ClassDescriptor getMutableIterator() {
        return this.getBuiltInClassByName("MutableIterator");
    }

    @NotNull
    public ClassDescriptor getCollection() {
        return this.getBuiltInClassByName("Collection");
    }

    @NotNull
    public ClassDescriptor getMutableCollection() {
        return this.getBuiltInClassByName("MutableCollection");
    }

    @NotNull
    public ClassDescriptor getList() {
        return this.getBuiltInClassByName("List");
    }

    @NotNull
    public ClassDescriptor getMutableList() {
        return this.getBuiltInClassByName("MutableList");
    }

    @NotNull
    public ClassDescriptor getSet() {
        return this.getBuiltInClassByName("Set");
    }

    @NotNull
    public ClassDescriptor getMutableSet() {
        return this.getBuiltInClassByName("MutableSet");
    }

    @NotNull
    public ClassDescriptor getMap() {
        return this.getBuiltInClassByName("Map");
    }

    @NotNull
    public ClassDescriptor getMutableMap() {
        return this.getBuiltInClassByName("MutableMap");
    }

    @NotNull
    public ClassDescriptor getMapEntry() {
        ClassDescriptor classDescriptor = DescriptorUtils.getInnerClassByName(this.getBuiltInClassByName("Map"), "Entry");
        assert (classDescriptor != null) : "Can't find Map.Entry";
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableMapEntry() {
        ClassDescriptor classDescriptor = DescriptorUtils.getInnerClassByName(this.getBuiltInClassByName("MutableMap"), "MutableEntry");
        assert (classDescriptor != null) : "Can't find MutableMap.MutableEntry";
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getListIterator() {
        return this.getBuiltInClassByName("ListIterator");
    }

    @NotNull
    public ClassDescriptor getMutableListIterator() {
        return this.getBuiltInClassByName("MutableListIterator");
    }

    @NotNull
    public Set<ClassDescriptor> getNonPhysicalClasses() {
        return this.nonPhysicalClasses;
    }

    @NotNull
    private ImmutableSet<ClassDescriptor> computeNonPhysicalClasses() {
        ImmutableSet.Builder nonPhysical = ImmutableSet.builder();
        nonPhysical.add(new ClassDescriptor[]{this.getAny(), this.getNothing(), this.getNumber(), this.getString(), this.getCharSequence(), this.getThrowable(), this.getBuiltInClassByName("Hashable"), this.getIterator(), this.getIterable(), this.getCollection(), this.getList(), this.getListIterator(), this.getSet(), this.getMap(), this.getMapEntry(), this.getMutableIterator(), this.getMutableIterable(), this.getMutableCollection(), this.getMutableList(), this.getMutableListIterator(), this.getMutableSet(), this.getMutableMap(), this.getMutableMapEntry(), this.getVolatileAnnotationClass(), this.getDataClassAnnotation(), this.getAnnotation(), this.getComparable(), this.getEnum(), this.getArray()});
        for (PrimitiveType primitiveType : PrimitiveType.values()) {
            nonPhysical.add(this.getPrimitiveClassDescriptor(primitiveType));
            nonPhysical.add(this.getPrimitiveArrayClassDescriptor(primitiveType));
        }
        return nonPhysical.build();
    }

    @NotNull
    private JetType getBuiltInTypeByClassName(@NotNull String classSimpleName) {
        return new JetTypeImpl(this.getBuiltInClassByName(classSimpleName));
    }

    @NotNull
    public JetType getNothingType() {
        return this.getBuiltInTypeByClassName("Nothing");
    }

    @NotNull
    public JetType getNullableNothingType() {
        return TypeUtils.makeNullable(this.getNothingType());
    }

    @NotNull
    public JetType getAnyType() {
        return this.getBuiltInTypeByClassName("Any");
    }

    @NotNull
    public JetType getNullableAnyType() {
        return TypeUtils.makeNullable(this.getAnyType());
    }

    @NotNull
    public JetType getPrimitiveJetType(@NotNull PrimitiveType type) {
        return new JetTypeImpl(this.getPrimitiveClassDescriptor(type));
    }

    @NotNull
    public JetType getNullablePrimitiveJetType(@NotNull PrimitiveType primitiveType) {
        return this.primitiveTypeToNullableJetType.get((Object)primitiveType);
    }

    @NotNull
    public JetType getByteType() {
        return this.getPrimitiveJetType(PrimitiveType.BYTE);
    }

    @NotNull
    public JetType getShortType() {
        return this.getPrimitiveJetType(PrimitiveType.SHORT);
    }

    @NotNull
    public JetType getIntType() {
        return this.getPrimitiveJetType(PrimitiveType.INT);
    }

    @NotNull
    public JetType getLongType() {
        return this.getPrimitiveJetType(PrimitiveType.LONG);
    }

    @NotNull
    public JetType getFloatType() {
        return this.getPrimitiveJetType(PrimitiveType.FLOAT);
    }

    @NotNull
    public JetType getDoubleType() {
        return this.getPrimitiveJetType(PrimitiveType.DOUBLE);
    }

    @NotNull
    public JetType getCharType() {
        return this.getPrimitiveJetType(PrimitiveType.CHAR);
    }

    @NotNull
    public JetType getBooleanType() {
        return this.getPrimitiveJetType(PrimitiveType.BOOLEAN);
    }

    @NotNull
    public JetType getUnitType() {
        return this.getBuiltInTypeByClassName("Unit");
    }

    @NotNull
    public JetType getStringType() {
        return this.getBuiltInTypeByClassName("String");
    }

    @NotNull
    public JetType getArrayElementType(@NotNull JetType arrayType) {
        if (arrayType.getConstructor().getDeclarationDescriptor() == this.getArray()) {
            if (arrayType.getArguments().size() != 1) {
                throw new IllegalStateException();
            }
            return arrayType.getArguments().get(0).getType();
        }
        JetType primitiveType = this.jetArrayTypeToPrimitiveJetType.get(TypeUtils.makeNotNullable(arrayType));
        if (primitiveType == null) {
            throw new IllegalStateException("not array: " + arrayType);
        }
        return primitiveType;
    }

    @NotNull
    public JetType getPrimitiveArrayJetType(@NotNull PrimitiveType primitiveType) {
        return this.primitiveTypeToArrayJetType.get((Object)primitiveType);
    }

    @Nullable
    public JetType getPrimitiveArrayJetTypeByPrimitiveJetType(@NotNull JetType jetType) {
        return this.primitiveJetTypeToJetArrayType.get(jetType);
    }

    @NotNull
    public JetType getArrayType(@NotNull Variance projectionType, @NotNull JetType argument) {
        List<TypeProjection> types = Collections.singletonList(new TypeProjection(projectionType, argument));
        return new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), this.getArray().getTypeConstructor(), false, types, this.getArray().getMemberScope(types));
    }

    @NotNull
    public JetType getArrayType(@NotNull JetType argument) {
        return this.getArrayType(Variance.INVARIANT, argument);
    }

    @NotNull
    public JetType getEnumType(@NotNull JetType argument) {
        Variance projectionType = Variance.INVARIANT;
        List<TypeProjection> types = Collections.singletonList(new TypeProjection(projectionType, argument));
        return new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), this.getEnum().getTypeConstructor(), false, types, this.getEnum().getMemberScope(types));
    }

    @NotNull
    public JetType getAnnotationType() {
        return this.getBuiltInTypeByClassName("Annotation");
    }

    @NotNull
    public ClassDescriptor getPropertyMetadata() {
        return this.getBuiltInClassByName("PropertyMetadata");
    }

    @NotNull
    public ClassDescriptor getPropertyMetadataImpl() {
        return this.getBuiltInClassByName("PropertyMetadataImpl");
    }

    @NotNull
    public JetType getFunctionType(@NotNull List<AnnotationDescriptor> annotations, @Nullable JetType receiverType, @NotNull List<JetType> parameterTypes, @NotNull JetType returnType) {
        List<TypeProjection> arguments = KotlinBuiltIns.getFunctionTypeArgumentProjections(receiverType, parameterTypes, returnType);
        int size = parameterTypes.size();
        ClassDescriptor classDescriptor = receiverType == null ? this.getFunction(size) : this.getExtensionFunction(size);
        TypeConstructor constructor = classDescriptor.getTypeConstructor();
        return new JetTypeImpl(annotations, constructor, false, arguments, classDescriptor.getMemberScope(arguments));
    }

    @NotNull
    public JetType getKFunctionType(@NotNull List<AnnotationDescriptor> annotations, @Nullable JetType receiverType, @NotNull List<JetType> parameterTypes, @NotNull JetType returnType, boolean extensionFunction) {
        List<TypeProjection> arguments = KotlinBuiltIns.getFunctionTypeArgumentProjections(receiverType, parameterTypes, returnType);
        ClassDescriptor classDescriptor = this.getCorrespondingKFunctionClass(receiverType, extensionFunction, parameterTypes.size());
        return new JetTypeImpl(annotations, classDescriptor.getTypeConstructor(), false, arguments, classDescriptor.getMemberScope(arguments));
    }

    @NotNull
    private ClassDescriptor getCorrespondingKFunctionClass(@Nullable JetType receiverType, boolean extensionFunction, int numberOfParameters) {
        if (receiverType == null) {
            return this.getKFunction(numberOfParameters);
        }
        if (extensionFunction) {
            return this.getKExtensionFunction(numberOfParameters);
        }
        return this.getKMemberFunction(numberOfParameters);
    }

    @NotNull
    private static List<TypeProjection> getFunctionTypeArgumentProjections(@Nullable JetType receiverType, @NotNull List<JetType> parameterTypes, @NotNull JetType returnType) {
        ArrayList<TypeProjection> arguments = new ArrayList<TypeProjection>();
        if (receiverType != null) {
            arguments.add(KotlinBuiltIns.defaultProjection(receiverType));
        }
        for (JetType parameterType : parameterTypes) {
            arguments.add(KotlinBuiltIns.defaultProjection(parameterType));
        }
        arguments.add(KotlinBuiltIns.defaultProjection(returnType));
        return arguments;
    }

    private static TypeProjection defaultProjection(JetType returnType) {
        return new TypeProjection(Variance.INVARIANT, returnType);
    }

    public boolean isArray(@NotNull JetType type) {
        return this.getArray().equals(type.getConstructor().getDeclarationDescriptor());
    }

    public boolean isPrimitiveArray(@NotNull JetType type) {
        return this.jetArrayTypeToPrimitiveJetType.containsKey(TypeUtils.makeNotNullable(type));
    }

    @NotNull
    private ImmutableSet<ClassDescriptor> computeIndexedClasses(@NotNull String prefix, int count) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < count; ++i) {
            builder.add(this.getBuiltInClassByName(prefix + i));
        }
        return builder.build();
    }

    public boolean isFunctionOrExtensionFunctionType(@NotNull JetType type) {
        return this.isFunctionType(type) || this.isExtensionFunctionType(type);
    }

    public boolean isFunctionType(@NotNull JetType type) {
        if (KotlinBuiltIns.setContainsClassOf(this.functionClassesSet, type)) {
            return true;
        }
        for (JetType superType : type.getConstructor().getSupertypes()) {
            if (!this.isFunctionType(superType)) continue;
            return true;
        }
        return false;
    }

    public boolean isExtensionFunctionType(@NotNull JetType type) {
        if (KotlinBuiltIns.setContainsClassOf(this.extensionFunctionClassesSet, type)) {
            return true;
        }
        for (JetType superType : type.getConstructor().getSupertypes()) {
            if (!this.isExtensionFunctionType(superType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public JetType getReceiverType(@NotNull JetType type) {
        assert (this.isFunctionOrExtensionFunctionType(type)) : type;
        if (this.isExtensionFunctionType(type)) {
            return type.getArguments().get(0).getType();
        }
        return null;
    }

    @NotNull
    public List<ValueParameterDescriptor> getValueParameters(@NotNull FunctionDescriptor functionDescriptor, @NotNull JetType type) {
        assert (this.isFunctionOrExtensionFunctionType(type));
        ArrayList<ValueParameterDescriptor> valueParameters = Lists.newArrayList();
        List<TypeProjection> parameterTypes = this.getParameterTypeProjectionsFromFunctionType(type);
        for (int i = 0; i < parameterTypes.size(); ++i) {
            TypeProjection parameterType = parameterTypes.get(i);
            ValueParameterDescriptorImpl valueParameterDescriptor = new ValueParameterDescriptorImpl(functionDescriptor, i, Collections.<AnnotationDescriptor>emptyList(), Name.identifier("p" + (i + 1)), parameterType.getType(), false, null);
            valueParameters.add(valueParameterDescriptor);
        }
        return valueParameters;
    }

    @NotNull
    public JetType getReturnTypeFromFunctionType(@NotNull JetType type) {
        assert (this.isFunctionOrExtensionFunctionType(type));
        List<TypeProjection> arguments = type.getArguments();
        return arguments.get(arguments.size() - 1).getType();
    }

    @NotNull
    public List<TypeProjection> getParameterTypeProjectionsFromFunctionType(@NotNull JetType type) {
        assert (this.isFunctionOrExtensionFunctionType(type));
        List<TypeProjection> arguments = type.getArguments();
        int first = this.isExtensionFunctionType(type) ? 1 : 0;
        int last = arguments.size() - 2;
        ArrayList<TypeProjection> parameterTypes = Lists.newArrayList();
        for (int i = first; i <= last; ++i) {
            parameterTypes.add(arguments.get(i));
        }
        return parameterTypes;
    }

    public boolean isNothing(@NotNull JetType type) {
        return this.isNothingOrNullableNothing(type) && !type.isNullable();
    }

    public boolean isNullableNothing(@NotNull JetType type) {
        return this.isNothingOrNullableNothing(type) && type.isNullable();
    }

    public boolean isNothingOrNullableNothing(@NotNull JetType type) {
        return !(type instanceof NamespaceType) && type.getConstructor() == this.getNothing().getTypeConstructor();
    }

    public boolean isAny(@NotNull JetType type) {
        return !(type instanceof NamespaceType) && type.getConstructor() == this.getAny().getTypeConstructor();
    }

    public boolean isUnit(@NotNull JetType type) {
        return !(type instanceof NamespaceType) && type.getConstructor() == this.getUnitType().getConstructor();
    }

    public boolean isData(@NotNull ClassDescriptor classDescriptor) {
        return KotlinBuiltIns.containsAnnotation(classDescriptor, this.getDataClassAnnotation());
    }

    public boolean isDeprecated(@NotNull DeclarationDescriptor declarationDescriptor) {
        return KotlinBuiltIns.containsAnnotation(declarationDescriptor, this.getDeprecatedAnnotation());
    }

    private static boolean containsAnnotation(DeclarationDescriptor descriptor, ClassDescriptor annotationClass) {
        List<AnnotationDescriptor> annotations = descriptor.getOriginal().getAnnotations();
        if (annotations != null) {
            for (AnnotationDescriptor annotation : annotations) {
                if (!annotationClass.equals(annotation.getType().getConstructor().getDeclarationDescriptor())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isVolatile(@NotNull PropertyDescriptor descriptor) {
        return KotlinBuiltIns.containsAnnotation(descriptor, this.getVolatileAnnotationClass());
    }

    @NotNull
    public JetType getDefaultBound() {
        return this.getNullableAnyType();
    }

    private static boolean setContainsClassOf(ImmutableSet<ClassDescriptor> set, JetType type) {
        return set.contains(type.getConstructor().getDeclarationDescriptor());
    }

    public static enum InitializationMode {
        MULTI_THREADED,
        SINGLE_THREADED;

    }
}

