/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.utils;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class KotlinVfsUtil {
    @NotNull
    public static String convertFromUrl(@NotNull URL url) throws MalformedURLException {
        String protocol = url.getProtocol();
        String path = url.getPath();
        if ("jar".equals(protocol)) {
            if (StringUtil.startsWithConcatenationOf(path, "file", ":")) {
                URL subURL = new URL(path);
                path = subURL.getPath();
            } else {
                throw new MalformedURLException("Can't parse url: " + url.toExternalForm());
            }
        }
        if (SystemInfo.isWindows || SystemInfo.isOS2) {
            while (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1, path.length());
            }
        }
        path = URLUtil.unescapePercentSequences(path);
        return protocol + "://" + path;
    }

    private KotlinVfsUtil() {
    }
}

