/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassAliasingMap;
import org.jetbrains.k2js.translate.declaration.DeclarationBodyVisitor;
import org.jetbrains.k2js.translate.declaration.PropertyTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class ClassTranslator
extends AbstractTranslator {
    @NotNull
    private final DeclarationBodyVisitor declarationBodyVisitor = new DeclarationBodyVisitor();
    @NotNull
    private final JetClassOrObject classDeclaration;
    @NotNull
    private final ClassDescriptor descriptor;
    @Nullable
    private final ClassAliasingMap aliasingMap;

    @NotNull
    public static JsExpression generateClassCreation(@NotNull JetClassOrObject classDeclaration, @NotNull ClassAliasingMap aliasingMap, @NotNull TranslationContext context) {
        return new ClassTranslator(classDeclaration, aliasingMap, context).translateClassOrObjectCreation(context);
    }

    @NotNull
    public static JsExpression generateClassCreation(@NotNull JetClassOrObject classDeclaration, @NotNull TranslationContext context) {
        return new ClassTranslator(classDeclaration, null, context).translateClassOrObjectCreation(context);
    }

    @NotNull
    public static JsExpression generateClassCreation(@NotNull JetClassOrObject classDeclaration, @NotNull ClassDescriptor descriptor, @NotNull TranslationContext context) {
        return new ClassTranslator(classDeclaration, descriptor, null, context).translateClassOrObjectCreation(context);
    }

    @NotNull
    public static JsExpression generateObjectLiteral(@NotNull JetObjectLiteralExpression objectLiteralExpression, @NotNull TranslationContext context) {
        return new ClassTranslator(objectLiteralExpression.getObjectDeclaration(), null, context).translateObjectLiteralExpression();
    }

    ClassTranslator(@NotNull JetClassOrObject classDeclaration, @Nullable ClassAliasingMap aliasingMap, @NotNull TranslationContext context) {
        this(classDeclaration, BindingUtils.getClassDescriptor(context.bindingContext(), classDeclaration), aliasingMap, context);
    }

    ClassTranslator(@NotNull JetClassOrObject classDeclaration, @NotNull ClassDescriptor descriptor, @Nullable ClassAliasingMap aliasingMap, @NotNull TranslationContext context) {
        super(context);
        this.aliasingMap = aliasingMap;
        this.descriptor = descriptor;
        this.classDeclaration = classDeclaration;
    }

    @NotNull
    private JsExpression translateObjectLiteralExpression() {
        ClassDescriptor containingClass = JsDescriptorUtils.getContainingClass(this.descriptor);
        if (containingClass == null) {
            return this.translateClassOrObjectCreation(this.context());
        }
        return this.translateAsObjectCreationExpressionWithEnclosingThisSaved(containingClass);
    }

    @NotNull
    private JsExpression translateAsObjectCreationExpressionWithEnclosingThisSaved(@NotNull ClassDescriptor containingClass) {
        return this.context().literalFunctionTranslator().translate(containingClass, this.classDeclaration, this.descriptor, this);
    }

    @NotNull
    public JsExpression translateClassOrObjectCreation(@NotNull TranslationContext declarationContext) {
        JsInvocation createInvocation = this.context().namer().classCreateInvocation(this.descriptor);
        this.translateClassOrObjectCreation(createInvocation, declarationContext);
        return createInvocation;
    }

    public void translateClassOrObjectCreation(@NotNull JsInvocation createInvocation) {
        this.translateClassOrObjectCreation(createInvocation, this.context());
    }

    private void translateClassOrObjectCreation(@NotNull JsInvocation createInvocation, @NotNull TranslationContext context) {
        this.addSuperclassReferences(createInvocation);
        this.addClassOwnDeclarations(createInvocation, context);
    }

    private boolean isTrait() {
        return this.descriptor.getKind().equals((Object)ClassKind.TRAIT);
    }

    private void addClassOwnDeclarations(@NotNull JsInvocation jsClassDeclaration, @NotNull TranslationContext classDeclarationContext) {
        JsObjectLiteral properties = new JsObjectLiteral(true);
        List<JsPropertyInitializer> propertyList = properties.getPropertyInitializers();
        if (!this.isTrait()) {
            JsFunction initializer = Translation.generateClassInitializerMethod(this.classDeclaration, classDeclarationContext);
            if (this.context().isEcma5()) {
                jsClassDeclaration.getArguments().add(initializer.getBody().getStatements().isEmpty() ? JsLiteral.NULL : initializer);
            } else {
                propertyList.add(new JsPropertyInitializer(Namer.initializeMethodReference(), initializer));
            }
        }
        propertyList.addAll(this.translatePropertiesAsConstructorParameters(classDeclarationContext));
        propertyList.addAll(this.declarationBodyVisitor.traverseClass(this.classDeclaration, classDeclarationContext));
        if (!propertyList.isEmpty() || !this.context().isEcma5()) {
            jsClassDeclaration.getArguments().add(properties);
        }
    }

    private void addSuperclassReferences(@NotNull JsInvocation jsClassDeclaration) {
        List<JsExpression> superClassReferences = this.getSupertypesNameReferences();
        List<JsExpression> expressions = jsClassDeclaration.getArguments();
        if (this.context().isEcma5()) {
            if (superClassReferences.isEmpty()) {
                jsClassDeclaration.getArguments().add(JsLiteral.NULL);
                return;
            }
            if (superClassReferences.size() > 1) {
                JsArrayLiteral arrayLiteral = new JsArrayLiteral();
                jsClassDeclaration.getArguments().add(arrayLiteral);
                expressions = arrayLiteral.getExpressions();
            }
        }
        for (JsExpression superClassReference : superClassReferences) {
            expressions.add(superClassReference);
        }
    }

    @NotNull
    private List<JsExpression> getSupertypesNameReferences() {
        Collection<JetType> supertypes = this.descriptor.getTypeConstructor().getSupertypes();
        if (supertypes.isEmpty()) {
            return Collections.emptyList();
        }
        JsExpression base = null;
        ArrayList<JsExpression> list = null;
        block4: for (JetType type : supertypes) {
            ClassDescriptor result = DescriptorUtils.getClassDescriptorForType(type);
            if (!DescriptorUtils.isNotAny(result) || AnnotationsUtils.isNativeObject(result)) continue;
            switch (result.getKind()) {
                case CLASS: {
                    base = this.getClassReference(result);
                    continue block4;
                }
                case TRAIT: {
                    if (list == null) {
                        list = new ArrayList<JsExpression>();
                    }
                    list.add(this.getClassReference(result));
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("unsupported super class kind " + result.getKind().name());
        }
        if (list == null) {
            return base == null ? Collections.emptyList() : Collections.singletonList(base);
        }
        if (base != null) {
            list.add(0, base);
        }
        return list;
    }

    @NotNull
    private JsExpression getClassReference(@NotNull ClassDescriptor superClassDescriptor) {
        JsNameRef name;
        if (this.aliasingMap != null && (name = this.aliasingMap.get(superClassDescriptor, this.descriptor)) != null) {
            return name;
        }
        return TranslationUtils.getQualifiedReference(this.context(), superClassDescriptor);
    }

    @NotNull
    private List<JsPropertyInitializer> translatePropertiesAsConstructorParameters(@NotNull TranslationContext classDeclarationContext) {
        List<JetParameter> parameters = PsiUtils.getPrimaryConstructorParameters(this.classDeclaration);
        if (parameters.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList<JsPropertyInitializer> result = new SmartList<JsPropertyInitializer>();
        for (JetParameter parameter : parameters) {
            PropertyDescriptor descriptor = BindingUtils.getPropertyDescriptorForConstructorParameter(this.bindingContext(), parameter);
            if (descriptor == null) continue;
            PropertyTranslator.translateAccessors(descriptor, result, classDeclarationContext);
        }
        return result;
    }
}

