/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions.basic;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.k2js.translate.utils.ErrorReportingUtils;

public final class CallStandardMethodIntrinsic
extends FunctionIntrinsic {
    @NotNull
    private final JsNameRef methodName;
    private final boolean receiverShouldBeNotNull;
    private final int expectedParamsNumber;

    public CallStandardMethodIntrinsic(@NotNull JsNameRef methodName, boolean receiverShouldBeNotNull, int expectedParamsNumber) {
        this.methodName = methodName;
        this.receiverShouldBeNotNull = receiverShouldBeNotNull;
        this.expectedParamsNumber = expectedParamsNumber;
    }

    @Override
    @NotNull
    public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
        assert (receiver != null == this.receiverShouldBeNotNull);
        assert (arguments.size() == this.expectedParamsNumber) : this.errorMessage(receiver, arguments);
        return new JsInvocation((JsExpression)this.methodName, CallStandardMethodIntrinsic.composeArguments(receiver, arguments));
    }

    @NotNull
    private String errorMessage(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments) {
        return "Incorrect number of arguments " + arguments.size() + " when expected " + this.expectedParamsNumber + " on method " + this.methodName + " " + ErrorReportingUtils.atLocation(receiver, arguments);
    }

    @NotNull
    private static List<JsExpression> composeArguments(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments) {
        if (receiver != null) {
            SmartList<JsExpression> args = new SmartList<JsExpression>(receiver);
            args.addAll(arguments);
            return args;
        }
        return arguments;
    }
}

