/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions.factories;

import com.google.common.collect.Lists;
import com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.BuiltInPropertyIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.CallStandardMethodIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.CompositeFIF;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.NamePredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.PatternBuilder;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class ArrayFIF
extends CompositeFIF {
    @NotNull
    private static final NamePredicate NUMBER_ARRAY;
    @NotNull
    private static final NamePredicate CHAR_ARRAY;
    @NotNull
    private static final NamePredicate BOOLEAN_ARRAY;
    @NotNull
    private static final NamePredicate ARRAY;
    @NotNull
    private static final NamePredicate ARRAYS;
    @NotNull
    private static final FunctionIntrinsic GET_INTRINSIC;
    @NotNull
    private static final FunctionIntrinsic SET_INTRINSIC;
    @NotNull
    public static final BuiltInPropertyIntrinsic ARRAY_LENGTH_INTRINSIC;
    @NotNull
    public static final FunctionIntrinsicFactory INSTANCE;

    private ArrayFIF() {
        this.add(PatternBuilder.pattern(ARRAYS, "get"), GET_INTRINSIC);
        this.add(PatternBuilder.pattern(ARRAYS, "set"), SET_INTRINSIC);
        this.add(PatternBuilder.pattern(ARRAYS, "<get-size>"), ARRAY_LENGTH_INTRINSIC);
        this.add(PatternBuilder.pattern(ARRAYS, "<get-indices>"), new CallStandardMethodIntrinsic(new JsNameRef("arrayIndices", "Kotlin"), true, 0));
        this.add(PatternBuilder.pattern(ARRAYS, "iterator"), new CallStandardMethodIntrinsic(new JsNameRef("arrayIterator", "Kotlin"), true, 0));
        this.add(PatternBuilder.pattern(ARRAY, "<init>"), new CallStandardMethodIntrinsic(new JsNameRef("arrayFromFun", "Kotlin"), false, 2));
        this.add(PatternBuilder.pattern(NUMBER_ARRAY, "<init>"), new CallStandardMethodIntrinsic(new JsNameRef("numberArrayOfSize", "Kotlin"), false, 1));
        this.add(PatternBuilder.pattern(CHAR_ARRAY, "<init>"), new CallStandardMethodIntrinsic(new JsNameRef("charArrayOfSize", "Kotlin"), false, 1));
        this.add(PatternBuilder.pattern(BOOLEAN_ARRAY, "<init>"), new CallStandardMethodIntrinsic(new JsNameRef("booleanArrayOfSize", "Kotlin"), false, 1));
    }

    static {
        ArrayList<Name> arrayTypeNames = Lists.newArrayList();
        for (PrimitiveType type : PrimitiveType.NUMBER_TYPES) {
            if (type == PrimitiveType.CHAR) continue;
            arrayTypeNames.add(type.getArrayTypeName());
        }
        Name arrayName = Name.identifier("Array");
        Name booleanArrayName = PrimitiveType.BOOLEAN.getArrayTypeName();
        Name charArrayName = PrimitiveType.CHAR.getArrayTypeName();
        NUMBER_ARRAY = new NamePredicate((Collection<Name>)arrayTypeNames);
        CHAR_ARRAY = new NamePredicate(charArrayName);
        BOOLEAN_ARRAY = new NamePredicate(booleanArrayName);
        ARRAY = new NamePredicate(arrayName);
        arrayTypeNames.add(charArrayName);
        arrayTypeNames.add(booleanArrayName);
        arrayTypeNames.add(arrayName);
        ARRAYS = new NamePredicate((Collection<Name>)arrayTypeNames);
        GET_INTRINSIC = new FunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
                assert (receiver != null);
                assert (arguments.size() == 1) : "Array get expression must have one argument.";
                JsExpression indexExpression = arguments.get(0);
                return new JsArrayAccess(receiver, indexExpression);
            }
        };
        SET_INTRINSIC = new FunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
                assert (receiver != null);
                assert (arguments.size() == 2) : "Array set expression must have two arguments.";
                JsExpression indexExpression = arguments.get(0);
                JsExpression value = arguments.get(1);
                JsArrayAccess arrayAccess = new JsArrayAccess(receiver, indexExpression);
                return JsAstUtils.assignment(arrayAccess, value);
            }
        };
        ARRAY_LENGTH_INTRINSIC = new BuiltInPropertyIntrinsic("length");
        INSTANCE = new ArrayFIF();
    }
}

