/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import com.google.common.collect.Lists;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.common.SourceInfo;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;

public final class ErrorReportingUtils {
    private ErrorReportingUtils() {
    }

    @NotNull
    public static RuntimeException reportErrorWithLocation(@NotNull JetExpression selector, @NotNull RuntimeException e) {
        return ErrorReportingUtils.reportErrorWithLocation(e, DiagnosticUtils.atLocation(selector));
    }

    @NotNull
    private static RuntimeException reportErrorWithLocation(@NotNull RuntimeException e, @NotNull String location) {
        throw new RuntimeException(e.getMessage() + " at " + location, e);
    }

    @NotNull
    public static String message(@NotNull PsiElement expression, @NotNull String messageText) {
        return messageText + " at " + DiagnosticUtils.atLocation(expression) + ".";
    }

    @NotNull
    public static String message(@NotNull BindingContext context, @NotNull DeclarationDescriptor descriptor, @NotNull String explainingMessage) {
        return explainingMessage + " at " + DiagnosticUtils.atLocation(context, descriptor) + ".";
    }

    @NotNull
    public static String message(@NotNull PsiElement element) {
        return "Error at " + DiagnosticUtils.atLocation(element) + ".";
    }

    @NotNull
    public static RuntimeException reportErrorWithLocation(@NotNull RuntimeException e, @NotNull DeclarationDescriptor descriptor, @NotNull BindingContext bindingContext) {
        throw ErrorReportingUtils.reportErrorWithLocation(e, DiagnosticUtils.atLocation(bindingContext, descriptor));
    }

    @NotNull
    public static String atLocation(@Nullable JsExpression expression, @NotNull List<JsExpression> arguments) {
        ArrayList<JsExpression> list = Lists.newArrayList(expression);
        list.addAll(arguments);
        for (JsExpression value : arguments) {
            SourceInfo info = value.getSourceInfo();
            if (info == null) continue;
            return "at " + info.getSource().getUri() + " " + info.getLine() + ":" + info.getColumn();
        }
        return "at unknown location";
    }
}

