/*
 * Copyright 2010-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.jet.lang.resolve.java;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.name.FqName;

import java.util.List;

public interface PsiClassFinder {
    enum RuntimeClassesHandleMode {
        REPORT_ERROR,
        IGNORE,
    }

    @Nullable
    PsiClass findPsiClass(@NotNull FqName fqName, @NotNull RuntimeClassesHandleMode runtimeClassesHandleMode);

    @Nullable
    PsiPackage findPsiPackage(@NotNull FqName fqName);

    @NotNull
    List<PsiClass> findPsiClasses(@NotNull PsiPackage psiPackage);

    @NotNull
    List<PsiClass> findInnerPsiClasses(@NotNull PsiClass psiClass);
}
