/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Ordering;
import com.google.common.collect.SortedIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;

final class SortedIterables {
    public static boolean hasSameComparator(Comparator<?> comparator, Iterable<?> elements) {
        Comparator<Object> comparator2;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(elements);
        if (elements instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)elements;
            comparator2 = sortedSet.comparator();
            if (comparator2 == null) {
                comparator2 = Ordering.natural();
            }
        } else {
            comparator2 = elements instanceof SortedIterable ? ((SortedIterable)elements).comparator() : null;
        }
        return ((Object)comparator).equals(comparator2);
    }

    public static <E> Collection<E> sortedUnique(Comparator<? super E> comparator, Iterable<E> elements) {
        if (elements instanceof Multiset) {
            elements = ((Multiset)elements).elementSet();
        }
        if (elements instanceof Set) {
            if (SortedIterables.hasSameComparator(comparator, elements)) {
                return (Set)elements;
            }
            ArrayList<E> list = Lists.newArrayList(elements);
            Collections.sort(list, comparator);
            return list;
        }
        Object[] array = Iterables.toArray(elements);
        if (!SortedIterables.hasSameComparator(comparator, elements)) {
            Arrays.sort(array, comparator);
        }
        return SortedIterables.uniquifySortedArray(comparator, array);
    }

    private static <E> Collection<E> uniquifySortedArray(Comparator<? super E> comparator, E[] array) {
        if (array.length == 0) {
            return Collections.emptySet();
        }
        int length = 1;
        for (int i = 1; i < array.length; ++i) {
            int cmp = comparator.compare(array[i], array[length - 1]);
            if (cmp == 0) continue;
            array[length++] = array[i];
        }
        if (length < array.length) {
            array = ObjectArrays.arraysCopyOf(array, length);
        }
        return Arrays.asList(array);
    }
}

