/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsNodeImpl;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class JsBlock
extends JsNodeImpl
implements JsStatement {
    private final List<JsStatement> statements;

    public JsBlock() {
        this(new ArrayList<JsStatement>());
    }

    public JsBlock(JsStatement statement) {
        this(Collections.singletonList(statement));
    }

    public JsBlock(JsStatement ... statements) {
        this(Arrays.asList(statements));
    }

    public JsBlock(List<JsStatement> statements) {
        this.statements = statements;
    }

    public List<JsStatement> getStatements() {
        return this.statements;
    }

    public boolean isGlobalBlock() {
        return false;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptWithInsertRemove(this.statements);
        }
        v.endVisit(this, ctx);
    }
}

