/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNodeImpl;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.backend.js.ast.JsVisitor;

public class JsFor
extends JsNodeImpl
implements JsStatement {
    private JsStatement body;
    private JsExpression condition;
    private JsExpression incrExpr;
    private JsExpression initExpr;
    private JsVars initVars;

    public JsFor(JsVars initVars, JsExpression condition, JsExpression incrementExpr) {
        this.initVars = initVars;
        this.incrExpr = incrementExpr;
        this.condition = condition;
        this.initExpr = null;
    }

    public JsStatement getBody() {
        return this.body;
    }

    public JsExpression getCondition() {
        return this.condition;
    }

    public JsExpression getIncrExpr() {
        return this.incrExpr;
    }

    public JsExpression getInitExpr() {
        return this.initExpr;
    }

    public JsVars getInitVars() {
        return this.initVars;
    }

    public void setBody(JsStatement body) {
        this.body = body;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            assert (this.initExpr == null || this.initVars == null);
            if (this.initExpr != null) {
                this.initExpr = v.accept(this.initExpr);
            } else if (this.initVars != null) {
                this.initVars = v.accept(this.initVars);
            }
            if (this.condition != null) {
                this.condition = v.accept(this.condition);
            }
            if (this.incrExpr != null) {
                this.incrExpr = v.accept(this.incrExpr);
            }
            this.body = v.accept(this.body);
        }
        v.endVisit(this, ctx);
    }
}

