/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Language
extends UserDataHolderBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.lang.Language");
    private static final Map<Class<? extends Language>, Language> ourRegisteredLanguages = Collections.synchronizedMap(new THashMap());
    private static final Map<String, List<Language>> ourRegisteredMimeTypes = Collections.synchronizedMap(new THashMap());
    private static final Map<String, Language> ourRegisteredIDs = new THashMap<String, Language>();
    private final Language myBaseLanguage;
    private final String myID;
    private final String[] myMimeTypes;
    private final List<Language> myDialects;
    public static final Language ANY = new Language(""){

        @Override
        public String toString() {
            return "Language: ANY";
        }
    };

    protected Language(@NotNull @NonNls String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/Language.<init> must not be null");
        }
        this(id, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    protected Language(@NotNull @NonNls String ID2, String ... mimeTypes) {
        if (ID2 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/Language.<init> must not be null");
        }
        if (mimeTypes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/Language.<init> must not be null");
        }
        this((Language)null, ID2, mimeTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Language(@Nullable Language baseLanguage, @NotNull @NonNls String ID2, String ... mimeTypes) {
        if (ID2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/Language.<init> must not be null");
        }
        if (mimeTypes == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/Language.<init> must not be null");
        }
        this.myDialects = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myBaseLanguage = baseLanguage;
        this.myID = ID2;
        this.myMimeTypes = mimeTypes;
        Class<?> langClass = this.getClass();
        Language prev = ourRegisteredLanguages.put(langClass, this);
        if (prev != null) {
            LOG.error("Language of '" + langClass + "' is already registered: " + prev);
            return;
        }
        prev = ourRegisteredIDs.put(ID2, this);
        if (prev != null) {
            LOG.error("Language with ID '" + ID2 + "' is already registered: " + prev.getClass());
        }
        for (String mimeType : mimeTypes) {
            if (StringUtil.isEmpty(mimeType)) continue;
            List<Language> languagesByMimeType = ourRegisteredMimeTypes.get(mimeType);
            if (languagesByMimeType == null) {
                Map<String, List<Language>> map = ourRegisteredMimeTypes;
                synchronized (map) {
                    languagesByMimeType = ourRegisteredMimeTypes.get(mimeType);
                    if (languagesByMimeType == null) {
                        languagesByMimeType = Collections.synchronizedList(new ArrayList());
                        ourRegisteredMimeTypes.put(mimeType, languagesByMimeType);
                    }
                }
            }
            languagesByMimeType.add(this);
        }
        if (baseLanguage != null) {
            baseLanguage.myDialects.add(this);
        }
    }

    public static Collection<Language> getRegisteredLanguages() {
        Collection<Language> languages = ourRegisteredLanguages.values();
        return Collections.unmodifiableCollection(new ArrayList<Language>(languages));
    }

    public static <T extends Language> T findInstance(Class<T> klass) {
        return (T)ourRegisteredLanguages.get(klass);
    }

    @NotNull
    public static Collection<Language> findInstancesByMimeType(@Nullable String mimeType) {
        List<Language> result = mimeType != null ? ourRegisteredMimeTypes.get(mimeType) : null;
        Collection<Object> collection = result != null ? Collections.unmodifiableCollection(result) : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/Language.findInstancesByMimeType must not return null");
        }
        return collection;
    }

    public String toString() {
        return "Language: " + this.myID;
    }

    @NotNull
    public String[] getMimeTypes() {
        if (this.myMimeTypes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/Language.getMimeTypes must not return null");
        }
        return this.myMimeTypes;
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/Language.getID must not return null");
        }
        return string;
    }

    @Nullable
    public LanguageFileType getAssociatedFileType() {
        FileType[] types;
        for (FileType fileType : types = FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
            if (!(fileType instanceof LanguageFileType) || ((LanguageFileType)fileType).getLanguage() != this) continue;
            return (LanguageFileType)fileType;
        }
        for (FileType fileType : types) {
            if (!(fileType instanceof LanguageFileType) || !this.isKindOf(((LanguageFileType)fileType).getLanguage())) continue;
            return (LanguageFileType)fileType;
        }
        return null;
    }

    @Nullable
    public Language getBaseLanguage() {
        return this.myBaseLanguage;
    }

    public String getDisplayName() {
        return this.getID();
    }

    public final boolean is(Language another) {
        return this == another;
    }

    public boolean isCaseSensitive() {
        return this.myBaseLanguage != null && this.myBaseLanguage.isCaseSensitive();
    }

    public final boolean isKindOf(Language another) {
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.is(another)) continue;
            return true;
        }
        return false;
    }

    public List<Language> getDialects() {
        return this.myDialects;
    }

    @Nullable
    public static Language findLanguageByID(String id) {
        Collection<Language> languages = Language.getRegisteredLanguages();
        for (Language language : languages) {
            if (!language.getID().equals(id)) continue;
            return language;
        }
        return null;
    }
}

