/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.BitUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceParser {
    private static final TokenSet WILDCARD_KEYWORD_SET = TokenSet.create(JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.SUPER_KEYWORD);
    private final JavaParser myParser;

    public ReferenceParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/parser/ReferenceParser.<init> must not be null");
        }
        this.myParser = javaParser;
    }

    @Nullable
    public PsiBuilder.Marker parseType(PsiBuilder builder, int flags) {
        TypeInfo typeInfo = this.parseTypeInfo(builder, flags);
        return typeInfo != null ? typeInfo.marker : null;
    }

    @Nullable
    public TypeInfo parseTypeInfo(PsiBuilder builder, int flags) {
        TypeInfo typeInfo = this.parseTypeInfo(builder, flags, false);
        if (typeInfo != null) {
            IElementType operator;
            assert (BitUtil.notSet(flags, 48)) : "don't not set both flags simultaneously";
            IElementType iElementType = BitUtil.isSet(flags, 16) ? JavaTokenType.OR : (operator = BitUtil.isSet(flags, 32) ? JavaTokenType.AND : null);
            if (operator != null && builder.getTokenType() == operator) {
                typeInfo.marker = typeInfo.marker.precede();
                while (builder.getTokenType() == operator) {
                    builder.advanceLexer();
                    IElementType tokenType = builder.getTokenType();
                    if (tokenType != JavaTokenType.IDENTIFIER && tokenType != JavaTokenType.AT) {
                        JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                    }
                    this.parseTypeInfo(builder, flags, false);
                }
                typeInfo.marker.done(JavaElementType.TYPE);
            }
        }
        return typeInfo;
    }

    @Nullable
    private TypeInfo parseTypeInfo(PsiBuilder builder, int flags, boolean badWildcard) {
        if (builder.getTokenType() == null) {
            return null;
        }
        TypeInfo typeInfo = new TypeInfo();
        PsiBuilder.Marker type = builder.mark();
        PsiBuilder.Marker anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
        IElementType tokenType = builder.getTokenType();
        if (PsiBuilderUtil.expect(builder, ElementType.PRIMITIVE_TYPE_BIT_SET)) {
            typeInfo.isPrimitive = true;
        } else if (tokenType == JavaTokenType.IDENTIFIER) {
            this.parseJavaCodeReference(builder, BitUtil.isSet(flags, 1), true, false, false, false, BitUtil.isSet(flags, 8), typeInfo);
        } else {
            if ((BitUtil.isSet(flags, 4) || badWildcard) && tokenType == JavaTokenType.QUEST) {
                builder.advanceLexer();
                this.completeWildcardType(builder, BitUtil.isSet(flags, 4), type);
                typeInfo.marker = type;
                return typeInfo;
            }
            if (BitUtil.isSet(flags, 8) && tokenType == JavaTokenType.GT) {
                JavaParserUtil.emptyElement(builder, JavaElementType.DIAMOND_TYPE);
                type.done(JavaElementType.TYPE);
                typeInfo.marker = type;
                return typeInfo;
            }
            type.drop();
            if (anno != null && BitUtil.isSet(flags, 64)) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.type", new Object[0]));
                typeInfo.hasErrors = true;
                return typeInfo;
            }
            return null;
        }
        while (true) {
            type.done(JavaElementType.TYPE);
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            PsiBuilder.Marker bracket = builder.mark();
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.LBRACKET)) {
                bracket.drop();
                break;
            }
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.RBRACKET)) {
                bracket.rollbackTo();
                break;
            }
            bracket.drop();
            typeInfo.isArray = true;
            type = type.precede();
        }
        if (BitUtil.isSet(flags, 2) && builder.getTokenType() == JavaTokenType.ELLIPSIS) {
            type = type.precede();
            builder.advanceLexer();
            type.done(JavaElementType.TYPE);
            typeInfo.isVarArg = true;
        }
        typeInfo.marker = type;
        return typeInfo;
    }

    private void completeWildcardType(PsiBuilder builder, boolean wildcard, PsiBuilder.Marker type) {
        if (PsiBuilderUtil.expect(builder, WILDCARD_KEYWORD_SET) && this.parseTypeInfo(builder, 1) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.type", new Object[0]));
        }
        if (wildcard) {
            type.done(JavaElementType.TYPE);
        } else {
            type.error(JavaErrorMessages.message("wildcard.not.expected", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parseJavaCodeReference(PsiBuilder builder, boolean eatLastDot, boolean parameterList, boolean isNew, boolean diamonds) {
        return this.parseJavaCodeReference(builder, eatLastDot, parameterList, false, false, isNew, diamonds, new TypeInfo());
    }

    public boolean parseImportCodeReference(PsiBuilder builder, boolean isStatic) {
        TypeInfo typeInfo = new TypeInfo();
        this.parseJavaCodeReference(builder, true, false, true, isStatic, false, false, typeInfo);
        return !typeInfo.hasErrors;
    }

    @Nullable
    private PsiBuilder.Marker parseJavaCodeReference(PsiBuilder builder, boolean eatLastDot, boolean parameterList, boolean isImport, boolean isStaticImport, boolean isNew, boolean diamonds, TypeInfo typeInfo) {
        PsiBuilder.Marker refElement = builder.mark();
        this.myParser.getDeclarationParser().parseAnnotations(builder);
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            refElement.rollbackTo();
            if (isImport) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            }
            typeInfo.hasErrors = true;
            return null;
        }
        if (parameterList) {
            typeInfo.isParameterized = this.parseReferenceParameterList(builder, true, diamonds);
        } else {
            JavaParserUtil.emptyElement(builder, JavaElementType.REFERENCE_PARAMETER_LIST);
        }
        while (builder.getTokenType() == JavaTokenType.DOT) {
            boolean hasIdentifier;
            refElement.done(JavaElementType.JAVA_CODE_REFERENCE);
            if (isNew && !diamonds && typeInfo.isParameterized) {
                return refElement;
            }
            PsiBuilder.Marker dotPos = builder.mark();
            builder.advanceLexer();
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            if (PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
                hasIdentifier = true;
            } else {
                if (isImport && PsiBuilderUtil.expect(builder, JavaTokenType.ASTERISK)) {
                    dotPos.drop();
                    return refElement;
                }
                if (!eatLastDot) {
                    dotPos.rollbackTo();
                    return refElement;
                }
                hasIdentifier = false;
            }
            dotPos.drop();
            PsiBuilder.Marker prevElement = refElement;
            refElement = refElement.precede();
            if (!hasIdentifier) {
                typeInfo.hasErrors = true;
                if (isImport) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("import.statement.identifier.or.asterisk.expected.", new Object[0]));
                    refElement.drop();
                    return prevElement;
                }
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                JavaParserUtil.emptyElement(builder, JavaElementType.REFERENCE_PARAMETER_LIST);
                break;
            }
            if (parameterList) {
                typeInfo.isParameterized = this.parseReferenceParameterList(builder, true, diamonds);
                continue;
            }
            JavaParserUtil.emptyElement(builder, JavaElementType.REFERENCE_PARAMETER_LIST);
        }
        refElement.done(isStaticImport ? JavaElementType.IMPORT_STATIC_REFERENCE : JavaElementType.JAVA_CODE_REFERENCE);
        return refElement;
    }

    public boolean parseReferenceParameterList(PsiBuilder builder, boolean wildcard, boolean diamonds) {
        PsiBuilder.Marker list = builder.mark();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LT)) {
            list.done(JavaElementType.REFERENCE_PARAMETER_LIST);
            return false;
        }
        int flags = BitUtil.set(BitUtil.set(1, 4, wildcard), 8, diamonds);
        boolean isOk = true;
        while (true) {
            if (this.parseTypeInfo(builder, flags, true) == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            } else {
                IElementType tokenType = builder.getTokenType();
                if (WILDCARD_KEYWORD_SET.contains(tokenType) && tokenType != null) {
                    this.parseReferenceList(builder, tokenType, null, JavaTokenType.AND);
                }
            }
            if (PsiBuilderUtil.expect(builder, JavaTokenType.GT)) break;
            if (!JavaParserUtil.expectOrError(builder, JavaTokenType.COMMA, "expected.gt.or.comma")) {
                isOk = false;
                break;
            }
            flags = BitUtil.set(flags, 8, false);
        }
        list.done(JavaElementType.REFERENCE_PARAMETER_LIST);
        return isOk;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiBuilder.Marker parseTypeParameters(PsiBuilder builder) {
        PsiBuilder.Marker marker;
        PsiBuilder.Marker list = builder.mark();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LT)) {
            list.done(JavaElementType.TYPE_PARAMETER_LIST);
            marker = list;
            if (marker == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/ReferenceParser.parseTypeParameters must not return null");
            return marker;
        }
        do {
            PsiBuilder.Marker param;
            if ((param = this.parseTypeParameter(builder)) != null) continue;
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.type.parameter", new Object[0]));
        } while (PsiBuilderUtil.expect(builder, JavaTokenType.COMMA));
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.GT)) {
            if (builder.getTokenType() == JavaTokenType.IDENTIFIER) {
                if (builder.lookAhead(1) == JavaTokenType.GT) {
                    PsiBuilder.Marker errorElement = builder.mark();
                    builder.advanceLexer();
                    errorElement.error(JavaErrorMessages.message("unexpected.identifier", new Object[0]));
                    builder.advanceLexer();
                } else {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.gt", new Object[0]));
                }
            } else {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.gt", new Object[0]));
            }
        }
        list.done(JavaElementType.TYPE_PARAMETER_LIST);
        marker = list;
        if (marker != null) return marker;
        throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/ReferenceParser.parseTypeParameters must not return null");
    }

    @Nullable
    public PsiBuilder.Marker parseTypeParameter(PsiBuilder builder) {
        PsiBuilder.Marker param = builder.mark();
        this.myParser.getDeclarationParser().parseAnnotations(builder);
        boolean wild = PsiBuilderUtil.expect(builder, JavaTokenType.QUEST);
        if (!wild && !PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            param.rollbackTo();
            return null;
        }
        this.parseReferenceList(builder, JavaTokenType.EXTENDS_KEYWORD, JavaElementType.EXTENDS_BOUND_LIST, JavaTokenType.AND);
        if (!wild) {
            param.done(JavaElementType.TYPE_PARAMETER);
        } else {
            param.error(JavaErrorMessages.message("wildcard.not.expected", new Object[0]));
        }
        return param;
    }

    @NotNull
    public PsiBuilder.Marker parseReferenceList(PsiBuilder builder, IElementType start, @Nullable IElementType type, IElementType delimiter) {
        PsiBuilder.Marker element = builder.mark();
        if (PsiBuilderUtil.expect(builder, start)) {
            do {
                PsiBuilder.Marker classReference;
                if ((classReference = this.parseJavaCodeReference(builder, true, true, false, false)) != null) continue;
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            } while (PsiBuilderUtil.expect(builder, delimiter));
        }
        if (type != null) {
            element.done(type);
        } else {
            element.error(JavaErrorMessages.message("bound.not.expected", new Object[0]));
        }
        PsiBuilder.Marker marker = element;
        if (marker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/ReferenceParser.parseReferenceList must not return null");
        }
        return marker;
    }

    public static class TypeInfo {
        public boolean isPrimitive = false;
        public boolean isParameterized = false;
        public boolean isArray = false;
        public boolean isVarArg = false;
        public boolean hasErrors = false;
        public PsiBuilder.Marker marker = null;
    }
}

