/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.BulkChangesMerger;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import com.intellij.openapi.editor.impl.TextChangesStorage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceBackedByArray;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CharArray
implements CharSequenceBackedByArray {
    private static final Logger LOG = Logger.getInstance("#" + CharArray.class.getName());
    private static final boolean DISABLE_DEFERRED_PROCESSING = Boolean.getBoolean("idea.document.deny.deferred.changes");
    private static final boolean DEBUG_DEFERRED_PROCESSING = LOG.isDebugEnabled() || Boolean.getBoolean("idea.document.debug.bulk.processing");
    private final TextChangesStorage myDeferredChangesStorage;
    private volatile int myStart;
    private volatile int myCount;
    private volatile CharSequence myOriginalSequence;
    private volatile char[] myArray;
    private volatile Reference<String> myStringRef;
    private volatile int myBufferSize;
    private volatile int myDeferredShift;
    private volatile boolean myDeferredChangeMode;
    private volatile boolean myHasDeferredChanges;
    private final Lock lock;
    private final boolean myDebug;
    private CharArray myDebugArray;
    private List<TextChangeImpl> myDebugDeferredChanges;
    private String myDebugTextOnBatchUpdateStart;

    boolean isDebug() {
        return DEBUG_DEFERRED_PROCESSING || DocumentImpl.CHECK_DOCUMENT_CONSISTENCY;
    }

    CharArray(int bufferSize, @NotNull char[] data, int length) {
        if (data == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.<init> must not be null");
        }
        this.lock = new ReentrantLock();
        this.myDebug = this.isDebug();
        this.myBufferSize = bufferSize;
        this.myDeferredChangesStorage = new TextChangesStorage();
        this.myArray = Arrays.copyOf(data, length);
        this.myCount = length;
        if (this.myDebug) {
            this.myDebugArray = new CharArray(bufferSize, data, length){

                @Override
                @NotNull
                protected DocumentEvent beforeChangedUpdate(int offset, CharSequence oldString, CharSequence newString, boolean wholeTextReplaced) {
                    DocumentEvent documentEvent = CharArray.this.beforeChangedUpdate(offset, oldString, newString, wholeTextReplaced);
                    if (documentEvent == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/CharArray$1.beforeChangedUpdate must not return null");
                    }
                    return documentEvent;
                }

                @Override
                protected void afterChangedUpdate(@NotNull DocumentEvent event, long newModificationStamp) {
                    if (event == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray$1.afterChangedUpdate must not be null");
                    }
                }

                @Override
                protected void assertWriteAccess() {
                }

                @Override
                protected void assertReadAccess() {
                }

                @Override
                boolean isDebug() {
                    return false;
                }
            };
            this.myDebugDeferredChanges = new ArrayList<TextChangeImpl>();
        }
        this.assertConsistency();
    }

    public void setBufferSize(int bufferSize) {
        assert (bufferSize >= 0) : bufferSize;
        this.myBufferSize = bufferSize;
        this.assertConsistency();
    }

    private DocumentEvent startChange(int offset, @Nullable CharSequence oldString, @Nullable CharSequence newString, boolean wholeTextReplaced) {
        assert (this.myStart == 0);
        this.assertWriteAccess();
        this.assertConsistency();
        return this.beforeChangedUpdate(offset, oldString, newString, wholeTextReplaced);
    }

    @NotNull
    protected abstract DocumentEvent beforeChangedUpdate(int var1, @Nullable CharSequence var2, @Nullable CharSequence var3, boolean var4);

    protected abstract void afterChangedUpdate(@NotNull DocumentEvent var1, long var2);

    protected abstract void assertWriteAccess();

    protected abstract void assertReadAccess();

    private void assertConsistency() {
        CharSequence str;
        CharArrayCharSequence seqFromCharArray;
        int stringLen;
        if (this.isDeferredChangeMode()) assert (this.myOriginalSequence == null);
        CharSequence originalSequence = this.myOriginalSequence;
        int origLen = originalSequence == null ? -1 : originalSequence.length();
        String string = this.myStringRef == null ? null : this.myStringRef.get();
        int n = stringLen = string == null ? -1 : string.length();
        assert (origLen == stringLen || origLen == -1 || stringLen == -1);
        int count = this.myCount + this.myDeferredShift;
        assert (count == origLen || origLen == -1);
        assert (count == stringLen || stringLen == -1);
        if (!this.myDebug) {
            return;
        }
        if (this.myArray != null) {
            assert (this.myCount <= this.myArray.length);
            seqFromCharArray = new CharArrayCharSequence(this.myArray, this.myStart, this.myCount);
        } else {
            seqFromCharArray = null;
        }
        if (seqFromCharArray != null && originalSequence != null) assert (StringUtil.equals(seqFromCharArray, originalSequence));
        if (!this.isDeferredChangeMode() && seqFromCharArray != null && string != null) assert (StringUtil.equals(seqFromCharArray, string));
        if (originalSequence != null && string != null) assert (string.equals(((Object)originalSequence).toString()));
        this.myDebugArray.assertConsistency();
        String string2 = str = this.myStringRef == null ? null : this.myStringRef.get();
        if (str == null) {
            str = this.myHasDeferredChanges ? ((Object)this.doSubString(0, this.myCount + this.myDeferredShift)).toString() : (this.myOriginalSequence != null ? ((Object)this.myOriginalSequence).toString() : seqFromCharArray);
        }
        assert (count == str.length());
        if (this.isDeferredChangeMode()) {
            String expected = this.myDebugArray.toString();
            this.checkStrings("toString()", expected, str);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void replace(int startOffset, int endOffset, @NotNull CharSequence toDelete, @NotNull CharSequence newString, long newModificationStamp, boolean bl) {
        void wholeTextReplaced;
        if (toDelete == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.replace must not be null");
        }
        if (newString == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.replace must not be null");
        }
        DocumentEvent event = this.startChange(startOffset, toDelete, newString, (boolean)wholeTextReplaced);
        this.doReplace(startOffset += this.myStart, endOffset += this.myStart, newString);
        this.afterChangedUpdate(event, newModificationStamp);
        this.assertConsistency();
    }

    private void doReplace(int startOffset, int endOffset, @NotNull CharSequence newString) {
        if (newString == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.doReplace must not be null");
        }
        this.prepareForModification();
        if (this.isDeferredChangeMode()) {
            this.storeChange(new TextChangeImpl(newString, startOffset, endOffset));
            if (this.myDebug) {
                this.myDebugArray.doReplace(startOffset, endOffset, newString);
            }
        } else {
            int newLength = newString.length();
            int oldLength = endOffset - startOffset;
            CharArrayUtil.getChars(newString, this.myArray, startOffset, Math.min(newLength, oldLength));
            this.myStringRef = null;
            if (newLength > oldLength) {
                this.doInsert(newString.subSequence(oldLength, newLength), endOffset);
            } else if (newLength < oldLength) {
                this.doRemove(startOffset + newLength, startOffset + oldLength);
            }
        }
    }

    public void remove(int startIndex, int endIndex, @NotNull CharSequence toDelete) {
        if (toDelete == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.remove must not be null");
        }
        DocumentEvent event = this.startChange(startIndex, toDelete, null, false);
        this.doRemove(startIndex += this.myStart, endIndex += this.myStart);
        this.afterChangedUpdate(event, LocalTimeCounter.currentTime());
        this.assertConsistency();
    }

    private void doRemove(int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            return;
        }
        this.prepareForModification();
        if (this.isDeferredChangeMode()) {
            this.storeChange(new TextChangeImpl("", startIndex, endIndex));
            if (this.myDebug) {
                this.myDebugArray.doRemove(startIndex, endIndex);
            }
        } else {
            if (endIndex < this.myCount) {
                System.arraycopy(this.myArray, endIndex, this.myArray, startIndex, this.myCount - endIndex);
                this.myStringRef = null;
            }
            this.myCount -= endIndex - startIndex;
        }
    }

    private void doInsert(@NotNull CharSequence s, int startIndex) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.doInsert must not be null");
        }
        this.prepareForModification();
        if (this.isDeferredChangeMode()) {
            this.storeChange(new TextChangeImpl(s, startIndex));
            if (this.myDebug) {
                this.myDebugArray.doInsert(s, startIndex);
            }
        } else {
            int insertLength = s.length();
            this.myArray = CharArray.resizeArray(this.myArray, this.myCount + insertLength);
            if (startIndex < this.myCount) {
                System.arraycopy(this.myArray, startIndex, this.myArray, startIndex + insertLength, this.myCount - startIndex);
            }
            CharArrayUtil.getChars(s, this.myArray, startIndex);
            this.myCount += insertLength;
            this.myStringRef = null;
        }
    }

    private void storeChange(@NotNull TextChangeImpl change) {
        if (change == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.storeChange must not be null");
        }
        if (!change.isWithinBounds(this.length())) {
            LOG.error("Invalid change attempt detected - given change bounds are not within the current char array. Change: " + change.getText().length() + ":" + change.getStart() + "-" + change.getEnd(), this.dumpState());
            return;
        }
        if (this.myDeferredChangesStorage.size() >= 10000) {
            this.flushDeferredChanged();
        }
        this.myDeferredChangesStorage.store(change);
        this.myHasDeferredChanges = true;
        this.myDeferredShift += change.getDiff();
        if (this.myDebug) {
            this.myDebugDeferredChanges.add(change);
        }
    }

    private void prepareForModification() {
        if (this.myOriginalSequence != null) {
            this.myArray = new char[this.myOriginalSequence.length()];
            CharArrayUtil.getChars(this.myOriginalSequence, this.myArray, 0);
            this.myCount = this.myArray.length;
            this.myOriginalSequence = null;
            this.myStart = 0;
        }
        this.myStringRef = null;
        this.assertConsistency();
    }

    @NotNull
    public CharSequence getCharArray() {
        this.assertConsistency();
        CharSequence originalSequence = this.myOriginalSequence;
        CharSequence charSequence = originalSequence == null ? this : originalSequence;
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/CharArray.getCharArray must not return null");
        }
        return charSequence;
    }

    @Override
    @NotNull
    public String toString() {
        String str;
        this.assertConsistency();
        String string = str = this.myStringRef == null ? null : this.myStringRef.get();
        if (str == null) {
            str = this.myHasDeferredChanges ? ((Object)this.substring(0, this.length())).toString() : (this.myOriginalSequence == null ? new String(this.myArray, this.myStart, this.myCount) : ((Object)this.myOriginalSequence).toString());
            this.myStringRef = new SoftReference<String>(str);
        }
        String string2 = str;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/CharArray.toString must not return null");
        }
        return string2;
    }

    @Override
    public final int length() {
        int expected;
        int result = this.myCount + this.myDeferredShift;
        if (this.myDebug && this.isDeferredChangeMode() && (expected = this.myDebugArray.length()) != result) {
            this.dumpDebugInfo("Incorrect length() processing. Expected: '" + expected + "', actual: '" + result + "'");
        }
        return result;
    }

    @Override
    public final char charAt(int i) {
        char expected;
        if (i < 0 || i >= this.length()) {
            throw new IndexOutOfBoundsException("Wrong offset: " + i + "; count:" + this.length());
        }
        char result = !this.myHasDeferredChanges ? (this.myOriginalSequence != null ? this.myOriginalSequence.charAt(i) : this.myArray[i]) : this.myDeferredChangesStorage.charAt(this.myArray, i += this.myStart);
        if (this.myDebug && this.isDeferredChangeMode() && (expected = this.myDebugArray.charAt(i)) != result) {
            this.dumpDebugInfo("Incorrect charAt() processing for index " + i + ". Expected: '" + expected + "', actual: '" + result + "'");
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        CharSequence charSequence;
        this.assertReadAccess();
        this.assertConsistency();
        if (start == 0 && end == this.length()) {
            charSequence = this;
            if (charSequence == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/CharArray.subSequence must not return null");
            return charSequence;
        }
        if (this.myOriginalSequence != null) {
            charSequence = this.myOriginalSequence.subSequence(start, end);
            if (charSequence == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/CharArray.subSequence must not return null");
            return charSequence;
        }
        this.flushDeferredChanged();
        charSequence = new CharArrayCharSequence(this.myArray, start, end);
        if (charSequence != null) return charSequence;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/CharArray.subSequence must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public char[] getChars() {
        this.assertReadAccess();
        this.assertConsistency();
        char[] array = this.myArray;
        CharSequence originalSequence = this.myOriginalSequence;
        if (this.myHasDeferredChanges || originalSequence != null && array == null) {
            this.lock.lock();
            try {
                this.flushDeferredChanged();
                if (this.myOriginalSequence != null && this.myArray == null) {
                    this.myArray = array = ArrayUtil.realloc(CharArrayUtil.fromSequence(this.myOriginalSequence), this.myOriginalSequence.length());
                    this.myStringRef = null;
                }
            }
            finally {
                this.lock.unlock();
            }
            this.assertConsistency();
        }
        if (array == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/CharArray.getChars must not return null");
        }
        return array;
    }

    @Override
    public void getChars(@NotNull char[] dst, int dstOffset) {
        if (dst == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.getChars must not be null");
        }
        this.assertReadAccess();
        this.assertConsistency();
        this.flushDeferredChanged();
        if (this.myOriginalSequence == null) {
            System.arraycopy(this.myArray, this.myStart, dst, dstOffset, this.length());
        } else {
            CharArrayUtil.getChars(this.myOriginalSequence, dst, dstOffset);
        }
        if (this.myDebug && this.isDeferredChangeMode()) {
            char[] expected = new char[dst.length];
            this.myDebugArray.getChars(expected, dstOffset);
            int i = dstOffset;
            for (int j = this.myStart; i < dst.length && j < this.myArray.length; ++i, ++j) {
                if (expected[i] == this.myArray[j]) continue;
                this.dumpDebugInfo("getChars(char[], int). Given array of length " + dst.length + ", offset " + dstOffset + ". Found char '" + this.myArray[j] + "' at index " + i + ", expected to find '" + expected[i] + "'");
                break;
            }
        }
    }

    @NotNull
    public CharSequence substring(int start, int end) {
        this.assertReadAccess();
        CharSequence result = this.doSubString(start, end);
        this.assertConsistency();
        CharSequence charSequence = result;
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/CharArray.substring must not return null");
        }
        return charSequence;
    }

    private CharSequence doSubString(int start, int end) {
        if (start == end) {
            return "";
        }
        CharSequence result = this.myOriginalSequence == null ? this.myDeferredChangesStorage.substring(this.myArray, start + this.myStart, end + this.myStart) : this.myOriginalSequence.subSequence(start, end);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static char[] resizeArray(@NotNull char[] array, int newSize) {
        char[] cArray;
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.resizeArray must not be null");
        }
        if (newSize < array.length) {
            cArray = array;
            if (array == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/CharArray.resizeArray must not return null");
            return cArray;
        }
        int newArraySize = array.length;
        if (newArraySize == 0) {
            newArraySize = 16;
        }
        while (newArraySize <= newSize) {
            newArraySize = newArraySize * 12 / 10 + 1;
        }
        char[] newArray = new char[newArraySize];
        System.arraycopy(array, 0, newArray, 0, array.length);
        cArray = newArray;
        if (newArray != null) return cArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/CharArray.resizeArray must not return null");
    }

    public boolean isDeferredChangeMode() {
        return this.myDeferredChangeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDeferredChanged() {
        block8: {
            List<TextChangeImpl> changes = this.myDeferredChangesStorage.getChanges();
            if (changes.isEmpty()) {
                return;
            }
            this.lock.lock();
            try {
                boolean inPlace;
                char[] beforeMerge = null;
                if (this.myDebug) {
                    beforeMerge = new char[this.myArray.length];
                    System.arraycopy(this.myArray, 0, beforeMerge, 0, this.myArray.length);
                }
                BulkChangesMerger changesMerger = BulkChangesMerger.INSTANCE;
                if (this.myArray.length < this.length()) {
                    this.myArray = changesMerger.mergeToCharArray(this.myArray, this.myCount, changes);
                    inPlace = false;
                } else {
                    changesMerger.mergeInPlace(this.myArray, this.myCount, changes);
                    inPlace = true;
                }
                this.myCount += this.myDeferredShift;
                this.myDeferredShift = 0;
                this.myDeferredChangesStorage.clear();
                this.myHasDeferredChanges = false;
                this.myDeferredChangeMode = false;
                this.myStringRef = null;
                if (!this.myDebug) break block8;
                int max = this.length();
                for (int i = 0; i < max; ++i) {
                    if (this.myArray[i] == this.myDebugArray.myArray[i]) continue;
                    this.dumpDebugInfo("flushDeferredChanged(). Index " + i + ", expected: '" + this.myDebugArray.myArray[i] + "', actual '" + this.myArray[i] + "'. Text before merge: '" + Arrays.toString(beforeMerge) + "', merge inplace: " + inPlace);
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        this.assertConsistency();
    }

    @NonNls
    @NotNull
    public String dumpState() {
        String string = "deferred changes mode: " + this.isDeferredChangeMode() + ", length: " + this.length() + " (data array length: " + this.myCount + ", deferred shift: " + this.myDeferredShift + "); view offsets: [" + this.myStart + "; " + this.myCount + "]; deferred changes: " + this.myDeferredChangesStorage;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/CharArray.dumpState must not return null");
        }
        return string;
    }

    private void checkStrings(@NonNls @NotNull String operation, @NotNull String expected, @NotNull CharSequence actual) {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.checkStrings must not be null");
        }
        if (expected == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.checkStrings must not be null");
        }
        if (actual == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.checkStrings must not be null");
        }
        if (StringUtil.equals(expected, actual)) {
            return;
        }
        int max = Math.min(expected.length(), actual.length());
        for (int i = 0; i < max; ++i) {
            if (actual.charAt(i) == expected.charAt(i)) continue;
            this.dumpDebugInfo("Incorrect " + operation + " processing. Expected length: " + expected.length() + ", actual length: " + actual.length() + ". Unmatched symbol at " + i + " - expected: '" + expected.charAt(i) + "', " + "actual: '" + actual.charAt(i) + "', expected document: '" + expected + "', actual document: '" + actual + "'");
            return;
        }
        this.dumpDebugInfo("Incorrect " + operation + " processing. Expected length: " + expected.length() + ", actual length: " + actual.length() + ", expected: '" + expected + "', actual: '" + actual + "'");
    }

    private void dumpDebugInfo(@NonNls @NotNull String problem) {
        if (problem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.dumpDebugInfo must not be null");
        }
        LOG.error("Incorrect CharArray processing detected: " + problem + ". Start: " + this.myStart + ", count: " + this.myCount + ", text on batch update start: " + this.myDebugTextOnBatchUpdateStart + ", deferred changes history: " + this.myDebugDeferredChanges + ", current deferred changes: " + this.myDeferredChangesStorage);
    }
}

