/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.ExtensionInitializer;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.CachingComponentAdapter;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public class ExtensionComponentAdapter
implements LoadingOrder.Orderable,
AssignableToComponentAdapter {
    public static final ExtensionComponentAdapter[] EMPTY_ARRAY = new ExtensionComponentAdapter[0];
    private Object myComponentInstance;
    private final String myImplementationClassName;
    private final Element myExtensionElement;
    private final PicoContainer myContainer;
    private final PluginDescriptor myPluginDescriptor;
    private final boolean myDeserializeInstance;
    private ComponentAdapter myDelegate;
    private Class myImplementationClass;

    public ExtensionComponentAdapter(@NotNull String implementationClass, Element extensionElement, PicoContainer container, PluginDescriptor pluginDescriptor, boolean deserializeInstance) {
        if (implementationClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionComponentAdapter.<init> must not be null");
        }
        this.myImplementationClassName = implementationClass;
        this.myExtensionElement = extensionElement;
        this.myContainer = container;
        this.myPluginDescriptor = pluginDescriptor;
        this.myDeserializeInstance = deserializeInstance;
    }

    @Override
    public Object getComponentKey() {
        return this;
    }

    @Override
    public Class getComponentImplementation() {
        return this.loadClass(this.myImplementationClassName);
    }

    @Override
    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (this.myComponentInstance == null) {
            if (Element.class.equals((Object)this.getComponentImplementation())) {
                this.myComponentInstance = this.myExtensionElement;
            } else {
                ExtensionInitializer initializer;
                Object componentInstance = this.getDelegate().getComponentInstance(container);
                if (this.myDeserializeInstance) {
                    try {
                        XmlSerializer.deserializeInto(componentInstance, this.myExtensionElement);
                    }
                    catch (Exception e) {
                        throw new PicoInitializationException(e);
                    }
                }
                if ((initializer = (ExtensionInitializer)container.getComponentInstance(ExtensionInitializer.class)) != null) {
                    initializer.initExtension(componentInstance);
                }
                this.myComponentInstance = componentInstance;
            }
            if (this.myComponentInstance instanceof PluginAware) {
                PluginAware pluginAware = (PluginAware)this.myComponentInstance;
                pluginAware.setPluginDescriptor(this.myPluginDescriptor);
            }
        }
        return this.myComponentInstance;
    }

    public Object getExtension() {
        return this.getComponentInstance(this.myContainer);
    }

    @Override
    public LoadingOrder getOrder() {
        return LoadingOrder.readOrder(this.myExtensionElement.getAttributeValue("order"));
    }

    @Override
    public String getOrderId() {
        return this.myExtensionElement.getAttributeValue("id");
    }

    private Element getExtensionElement() {
        return this.myExtensionElement;
    }

    @Override
    public Element getDescribingElement() {
        return this.getExtensionElement();
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    private Class loadClass(String className) {
        if (this.myImplementationClass == null) {
            try {
                ClassLoader classLoader;
                ClassLoader classLoader2 = classLoader = this.myPluginDescriptor != null ? this.myPluginDescriptor.getPluginClassLoader() : this.getClass().getClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                this.myImplementationClass = Class.forName(className, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.myImplementationClass;
    }

    private synchronized ComponentAdapter getDelegate() {
        if (this.myDelegate == null) {
            this.myDelegate = new CachingComponentAdapter(new ConstructorInjectionComponentAdapter(this.getComponentKey(), this.loadClass(this.myImplementationClassName), null, true));
        }
        return this.myDelegate;
    }

    @Override
    public boolean isAssignableTo(Class aClass) {
        return aClass.getName().equals(this.myImplementationClassName);
    }

    @Override
    public String getAssignableToClassName() {
        return this.myImplementationClassName;
    }
}

