/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import java.beans.Introspector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtil
extends StringUtilRt {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.text.StringUtil");
    @NonNls
    private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
    public static final NotNullFunction<String, String> QUOTER = new NotNullFunction<String, String>(){

        @Override
        @NotNull
        public String fun(String s) {
            String string = "\"" + s + "\"";
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil$1.fun must not return null");
            }
            return string;
        }
    };
    public static final NotNullFunction<String, String> SINGLE_QUOTER = new NotNullFunction<String, String>(){

        @Override
        @NotNull
        public String fun(String s) {
            String string = "'" + s + "'";
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil$2.fun must not return null");
            }
            return string;
        }
    };
    @NotNull
    public static Function<String, String> TRIMMER = new Function<String, String>(){

        @Override
        @Nullable
        public String fun(@Nullable String s) {
            return s == null ? null : s.trim();
        }
    };
    @NonNls
    private static final String[] ourPrepositions = new String[]{"at", "the", "and", "not", "if", "a", "or", "to", "in", "on", "into", "by"};
    @NonNls
    private static final String[] REPLACES_REFS = new String[]{"&lt;", "&gt;", "&amp;", "&#39;", "&quot;"};
    @NonNls
    private static final String[] REPLACES_DISP = new String[]{"<", ">", "&", "'", "\""};

    @NotNull
    public static String replace(@NonNls @NotNull String text, @NonNls @NotNull String oldS, @NonNls @Nullable String newS) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        if (oldS == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        String string = StringUtil.replace(text, oldS, newS, false);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.replace must not return null");
        }
        return string;
    }

    public static String replace(@NotNull String text, @NotNull String oldS, @Nullable String newS, boolean ignoreCase) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        if (oldS == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        if (text.length() < oldS.length()) {
            return text;
        }
        String text1 = ignoreCase ? text.toLowerCase() : text;
        String oldS1 = ignoreCase ? oldS.toLowerCase() : oldS;
        StringBuilder newText = null;
        int i = 0;
        while (i < text1.length()) {
            int i1 = text1.indexOf(oldS1, i);
            if (i1 < 0) {
                if (i == 0) {
                    return text;
                }
                newText.append(text, i, text.length());
                break;
            }
            if (newS == null) {
                return null;
            }
            if (newText == null) {
                newText = new StringBuilder();
            }
            newText.append(text, i, i1);
            newText.append(newS);
            i = i1 + oldS.length();
        }
        return newText != null ? newText.toString() : "";
    }

    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        if (where == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOfIgnoreCase must not be null");
        }
        if (what == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOfIgnoreCase must not be null");
        }
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && StringUtil.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        if (where == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOfIgnoreCase must not be null");
        }
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        for (int i = fromIndex; i < sourceCount; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), what)) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsIgnoreCase(@NotNull String where, @NotNull String what) {
        if (where == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.containsIgnoreCase must not be null");
        }
        if (what == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.containsIgnoreCase must not be null");
        }
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    public static boolean endsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String suffix) {
        int suffixLength;
        if (str == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.endsWithIgnoreCase must not be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.endsWithIgnoreCase must not be null");
        }
        int stringLength = str.length();
        return stringLength >= (suffixLength = suffix.length()) && str.regionMatches(true, stringLength - suffixLength, suffix, 0, suffixLength);
    }

    public static boolean startsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String prefix) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.startsWithIgnoreCase must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.startsWithIgnoreCase must not be null");
        }
        return StringUtilRt.startsWithIgnoreCase(str, prefix);
    }

    @NotNull
    public static String getPackageName(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getPackageName must not be null");
        }
        String string = StringUtil.getPackageName(fqName, '.');
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getPackageName must not return null");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String getPackageName(@NotNull String fqName, char separator) {
        if (fqName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getPackageName must not be null");
        }
        int lastPointIdx = fqName.lastIndexOf(separator);
        if (lastPointIdx < 0) return "";
        String string = fqName.substring(0, lastPointIdx);
        String string2 = string;
        if (string != null) return string2;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getPackageName must not return null");
    }

    public static int getLineBreakCount(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getLineBreakCount must not be null");
        }
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                ++count;
                continue;
            }
            if (c != '\r') continue;
            if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                ++i;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    public static boolean containsLineBreak(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.containsLineBreak must not be null");
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!StringUtil.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    public static void escapeStringCharacters(int length, @NotNull String str, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not be null");
        }
        StringUtil.escapeStringCharacters(length, str, "\"", buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not be null");
        }
        StringBuilder stringBuilder = StringUtil.escapeStringCharacters(length, str, additionalChars, true, buffer);
        if (stringBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not return null");
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not be null");
        }
        char prev = '\u0000';
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (Character.isISOControl(ch)) {
                        String hexCode = StringUtilRt.toUpperCase(Integer.toHexString(ch));
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append(hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not return null");
        }
        return stringBuilder;
    }

    @NotNull
    public static String escapeStringCharacters(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not be null");
        }
        StringBuilder buffer = new StringBuilder();
        StringUtil.escapeStringCharacters(s.length(), s, buffer);
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not return null");
        }
        return string;
    }

    @NotNull
    public static String unescapeStringCharacters(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.unescapeStringCharacters must not be null");
        }
        StringBuilder buffer = new StringBuilder();
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.unescapeStringCharacters must not return null");
        }
        return string;
    }

    private static void unescapeStringCharacters(int length, @NotNull String s, @NotNull StringBuilder buffer) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.unescapeStringCharacters must not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.unescapeStringCharacters must not be null");
        }
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.valueOf(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String pluralize(@NotNull String suggestion) {
        String string;
        if (suggestion == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.pluralize must not be null");
        }
        if (suggestion.endsWith("Child") || suggestion.endsWith("child")) {
            String string2 = suggestion + "ren";
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.pluralize must not return null");
        }
        if (suggestion.equals("this")) {
            return "these";
        }
        if (suggestion.equals("This")) {
            return "These";
        }
        if (StringUtil.endsWithIgnoreCase(suggestion, "s") || StringUtil.endsWithIgnoreCase(suggestion, "x") || StringUtil.endsWithIgnoreCase(suggestion, "ch")) {
            String string3 = suggestion + "es";
            string = string3;
            if (string3 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.pluralize must not return null");
            return string;
        }
        int len = suggestion.length();
        if (StringUtil.endsWithIgnoreCase(suggestion, "y") && len > 1 && !StringUtil.isVowel(StringUtil.toLowerCase(suggestion.charAt(len - 2)))) {
            String string4 = suggestion.substring(0, len - 1) + "ies";
            string = string4;
            if (string4 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.pluralize must not return null");
            return string;
        }
        String string5 = suggestion + "s";
        string = string5;
        if (string5 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.pluralize must not return null");
        return string;
    }

    public static String decapitalize(String s) {
        return Introspector.decapitalize(s);
    }

    public static boolean isVowel(char c) {
        return "aeiouy".indexOf(c) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String capitalize(@NotNull String s) {
        String string;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.capitalize must not be null");
        }
        if (s.isEmpty()) {
            string = s;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalize must not return null");
            return string;
        }
        if (s.length() == 1) {
            string = StringUtilRt.toUpperCase(s);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalize must not return null");
            return string;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            string = s;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalize must not return null");
            return string;
        }
        string = StringUtil.toUpperCase(s.charAt(0)) + s.substring(1);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalize must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String capitalizeWithJavaBeanConvention(@NotNull String s) {
        String string;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.capitalizeWithJavaBeanConvention must not be null");
        }
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            string = s;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalizeWithJavaBeanConvention must not return null");
            return string;
        }
        string = StringUtil.capitalize(s);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalizeWithJavaBeanConvention must not return null");
    }

    public static int stringHashCode(@NotNull CharSequence chars) {
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.stringHashCode must not be null");
        }
        if (chars instanceof String) {
            return chars.hashCode();
        }
        if (chars instanceof CharSequenceWithStringHash) {
            return chars.hashCode();
        }
        if (chars instanceof CharArrayCharSequence) {
            return chars.hashCode();
        }
        return StringUtil.stringHashCode(chars, 0, chars.length());
    }

    public static int stringHashCode(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.stringHashCode must not be null");
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars.charAt(off);
        }
        return h;
    }

    public static int stringHashCode(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars[off];
        }
        return h;
    }

    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.stringHashCodeInsensitive must not be null");
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars.charAt(off));
        }
        return h;
    }

    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.stringHashCodeInsensitive must not be null");
        }
        return StringUtil.stringHashCodeInsensitive(chars, 0, chars.length());
    }

    public static boolean startsWithConcatenationOf(@NotNull String testee, @NotNull String firstPrefix, @NotNull String secondPrefix) {
        if (testee == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.startsWithConcatenationOf must not be null");
        }
        if (firstPrefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.startsWithConcatenationOf must not be null");
        }
        if (secondPrefix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.startsWithConcatenationOf must not be null");
        }
        int l1 = firstPrefix.length();
        int l2 = secondPrefix.length();
        if (testee.length() < l1 + l2) {
            return false;
        }
        return testee.startsWith(firstPrefix) && testee.regionMatches(l1, secondPrefix, 0, l2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String trimEnd(@NotNull String s, @NonNls @NotNull String suffix) {
        String string;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.trimEnd must not be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.trimEnd must not be null");
        }
        if (s.endsWith(suffix)) {
            string = s.substring(0, s.length() - suffix.length());
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.trimEnd must not return null");
            return string;
        }
        string = s;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.trimEnd must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String trimLog(@NotNull String text, int limit) {
        String string;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.trimLog must not be null");
        }
        if (limit > 5 && text.length() > limit) {
            string = text.substring(0, limit - 5) + " ...\n";
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.trimLog must not return null");
            return string;
        }
        string = text;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.trimLog must not return null");
    }

    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return StringUtilRt.endsWithChar(s, suffix);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String trimStart(@NotNull String s, @NonNls @NotNull String prefix) {
        String string;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.trimStart must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.trimStart must not be null");
        }
        if (s.startsWith(prefix)) {
            string = s.substring(prefix.length());
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.trimStart must not return null");
            return string;
        }
        string = s;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.trimStart must not return null");
    }

    public static void repeatSymbol(@NotNull Appendable buffer, char symbol, int times) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.repeatSymbol must not be null");
        }
        assert (times >= 0) : times;
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public static boolean isNotEmpty(@Nullable String s) {
        return s != null && !s.isEmpty();
    }

    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isEmptyOrSpaces(@Nullable String s) {
        return s == null || s.trim().isEmpty();
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        if (aThrowable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getThrowableText must not be null");
        }
        String string = ExceptionUtil.getThrowableText(aThrowable);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getThrowableText must not return null");
        }
        return string;
    }

    @NotNull
    public static String repeat(String s, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.repeat must not return null");
        }
        return string;
    }

    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.split must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.split must not be null");
        }
        List<String> list = StringUtil.split(s, separator, true);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.split must not return null");
        }
        return list;
    }

    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.split must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.split must not be null");
        }
        List<String> list = StringUtil.split(s, separator, excludeSeparator, true);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.split must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        ArrayList<String> result;
        List<String> list;
        block17: {
            int pos;
            block16: {
                if (s == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.split must not be null");
                }
                if (separator == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.split must not be null");
                }
                if (separator.isEmpty()) {
                    list = Collections.singletonList(s);
                    if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.split must not return null");
                    return list;
                }
                result = new ArrayList<String>();
                pos = 0;
                while (true) {
                    int index;
                    if ((index = s.indexOf(separator, pos)) == -1) {
                        if (pos >= s.length()) {
                            break;
                        }
                        break block16;
                    }
                    int nextPos = index + separator.length();
                    String token = s.substring(pos, excludeSeparator ? index : nextPos);
                    if (!token.isEmpty() || !excludeEmptyStrings) {
                        result.add(token);
                    }
                    pos = nextPos;
                }
                if (excludeEmptyStrings || pos != s.length()) break block17;
            }
            result.add(s.substring(pos, s.length()));
        }
        if ((list = result) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.split must not return null");
    }

    @NotNull
    public static <T> String join(@NotNull T[] items, @NotNull Function<T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (f == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        String string = StringUtil.join(Arrays.asList(items), f, separator);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static <T> String join(@NotNull Collection<T> items, @NotNull Function<T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (f == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (items.isEmpty()) {
            return "";
        }
        String string = StringUtil.join(items, f, separator);
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        return string2;
    }

    public static String join(@NotNull Iterable<?> items, @NotNull @NonNls String separator) {
        if (items == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        StringBuilder result = new StringBuilder();
        for (Object item : items) {
            result.append(item).append(separator);
        }
        if (result.length() > 0) {
            result.setLength(result.length() - separator.length());
        }
        return result.toString();
    }

    @NotNull
    public static <T> String join(@NotNull Iterable<T> items, @NotNull Function<T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (f == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        StringBuilder result = new StringBuilder();
        for (T item : items) {
            String string = f.fun(item);
            if (string == null || string.isEmpty()) continue;
            if (result.length() != 0) {
                result.append(separator);
            }
            result.append(string);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        }
        return string;
    }

    @NotNull
    public static String join(@NotNull Collection<? extends String> strings, @NotNull String separator) {
        if (strings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        StringBuilder result = new StringBuilder();
        for (String string : strings) {
            if (string == null || string.isEmpty()) continue;
            if (result.length() != 0) {
                result.append(separator);
            }
            result.append(string);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String join(String ... strings) {
        if (strings == null) return "";
        if (strings.length == 0) {
            return "";
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        for (String string : strings) {
            builder.append(string);
        }
        String string = builder.toString();
        String string2 = string;
        String string3 = string2;
        if (string2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        return string3;
        finally {
            StringBuilderSpinAllocator.dispose(builder);
        }
    }

    @NotNull
    public static String stripQuotesAroundValue(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.stripQuotesAroundValue must not be null");
        }
        if (StringUtil.startsWithChar(text, '\"') || StringUtil.startsWithChar(text, '\'')) {
            text = text.substring(1);
        }
        if (StringUtil.endsWithChar(text, '\"') || StringUtil.endsWithChar(text, '\'')) {
            text = text.substring(0, text.length() - 1);
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.stripQuotesAroundValue must not return null");
        }
        return string;
    }

    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars, int start, int end) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.containsAnyChar must not be null");
        }
        if (chars == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.containsAnyChar must not be null");
        }
        for (int i = start; i < end; ++i) {
            if (chars.indexOf(value.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean containsChar(@NotNull String value, char ch) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.containsChar must not be null");
        }
        return value.indexOf(ch) >= 0;
    }

    @NotNull
    public static String strip(@NotNull String s, @NotNull CharFilter filter) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.strip must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.strip must not be null");
        }
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            result.append(ch);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.strip must not return null");
        }
        return string;
    }

    public static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        int l2;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.endsWith must not be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.endsWith must not be null");
        }
        int l1 = text.length();
        if (l1 < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (text.charAt(i) == suffix.charAt(i + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(@NotNull CharSequence s, int start, int end, char c) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.contains must not be null");
        }
        return StringUtil.indexOf(s, c, start, end) >= 0;
    }

    public static int indexOf(@NotNull CharSequence s, char c) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOf must not be null");
        }
        return StringUtil.indexOf(s, c, 0, s.length());
    }

    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOf must not be null");
        }
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(@NotNull char[] s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOf must not be null");
        }
        for (int i = start; i < end; ++i) {
            if (!StringUtil.charsMatch(s[i], c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfAny(@NotNull String s, @NotNull String chars, int start, int end) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOfAny must not be null");
        }
        if (chars == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOfAny must not be null");
        }
        for (int i = start; i < end; ++i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.lastIndexOf must not be null");
        }
        for (int i = end - 1; i >= start; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public static CharSequence first(@NotNull CharSequence text, int length, boolean appendEllipsis) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.first must not be null");
        }
        CharSequence charSequence = text.length() > length ? text.subSequence(0, length) + (appendEllipsis ? "..." : "") : text;
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.first must not return null");
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence last(@NotNull CharSequence text, int length, boolean prependEllipsis) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.last must not be null");
        }
        CharSequence charSequence = text.length() > length ? (prependEllipsis ? "..." : "") + text.subSequence(text.length() - length, text.length()) : text;
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.last must not return null");
        }
        return charSequence;
    }

    public static String escapeXml(@Nullable String text) {
        if (text == null) {
            return null;
        }
        return StringUtil.replace(text, REPLACES_DISP, REPLACES_REFS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String escapeToRegexp(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeToRegexp must not be null");
        }
        StringBuilder result = StringBuilderSpinAllocator.alloc();
        String string = StringUtil.escapeToRegexp(text, result).toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.escapeToRegexp must not return null");
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose(result);
        }
    }

    public static StringBuilder escapeToRegexp(CharSequence text, StringBuilder builder) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_') {
                builder.append(c);
                continue;
            }
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            builder.append('\\').append(c);
        }
        return builder;
    }

    @NotNull
    public static String replace(@NotNull String text, @NotNull String[] from, @NotNull String[] to) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        if (from == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        StringBuilder result = new StringBuilder(text.length());
        block0: for (int i = 0; i < text.length(); ++i) {
            for (int j = 0; j < from.length; ++j) {
                String toReplace = from[j];
                String replaceWith = to[j];
                int len = toReplace.length();
                if (!text.regionMatches(i, toReplace, 0, len)) continue;
                result.append(replaceWith);
                i += len - 1;
                continue block0;
            }
            result.append(text.charAt(i));
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.replace must not return null");
        }
        return string;
    }

    public static int countNewLines(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.countNewLines must not be null");
        }
        return StringUtil.countChars(text, '\n');
    }

    public static int countChars(@NotNull CharSequence text, char c) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.countChars must not be null");
        }
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch != c) continue;
            ++count;
        }
        return count;
    }

    @Nullable
    public static String joinOrNull(String ... args) {
        if (args == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.joinOrNull must not be null");
        }
        StringBuilder r = new StringBuilder();
        for (String arg : args) {
            if (arg == null) {
                return null;
            }
            r.append(arg);
        }
        return r.toString();
    }

    @Nullable
    public static String getPropertyName(@NonNls @NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getPropertyName must not be null");
        }
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    public static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    public static boolean isJavaIdentifierPart(char c) {
        return c >= '0' && c <= '9' || StringUtil.isJavaIdentifierStart(c);
    }

    public static boolean isJavaIdentifier(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.isJavaIdentifier must not be null");
        }
        int len = text.length();
        if (len == 0) {
            return false;
        }
        if (!StringUtil.isJavaIdentifierStart(text.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (StringUtil.isJavaIdentifierPart(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getQualifiedName(@Nullable String packageName, String className) {
        if (packageName == null || packageName.isEmpty()) {
            return className;
        }
        return packageName + '.' + className;
    }

    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[\\.\\_\\-]");
        String[] part2 = v2.split("[\\.\\_\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length == part2.length) {
            return 0;
        }
        if (part1.length > idx) {
            return 1;
        }
        return -1;
    }

    public static void assertValidSeparators(@NotNull CharSequence s) {
        int i;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.assertValidSeparators must not be null");
        }
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(s);
        int slashRIndex = -1;
        if (chars != null) {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (chars[i] != '\r') continue;
                slashRIndex = i;
                break;
            }
        } else {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (s.charAt(i) != '\r') continue;
                slashRIndex = i;
                break;
            }
        }
        if (slashRIndex != -1) {
            String context = String.valueOf(StringUtil.last(s.subSequence(0, slashRIndex), 10, true)) + StringUtil.first(s.subSequence(slashRIndex, s.length()), 10, true);
            context = StringUtil.escapeStringCharacters(context);
            LOG.error("Wrong line separators: '" + context + "' at offset " + slashRIndex);
        }
    }

    public static int hashCode(@NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.hashCode must not be null");
        }
        return StringUtil.stringHashCode(s);
    }

    public static boolean equals(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int compare(char c1, char c2, boolean ignoreCase) {
        char u2;
        int d = c1 - c2;
        if (d == 0 || !ignoreCase) {
            return d;
        }
        char u1 = StringUtilRt.toUpperCase(c1);
        d = u1 - (u2 = StringUtilRt.toUpperCase(c2));
        if (d != 0) {
            d = StringUtilRt.toLowerCase(u1) - StringUtilRt.toLowerCase(u2);
        }
        return d;
    }

    public static boolean charsMatch(char c1, char c2, boolean ignoreCase) {
        return StringUtil.compare(c1, c2, ignoreCase) == 0;
    }

    public static boolean charsEqualIgnoreCase(char a, char b) {
        return StringUtilRt.charsEqualIgnoreCase(a, b);
    }

    public static char toUpperCase(char a) {
        return StringUtilRt.toUpperCase(a);
    }

    public static String toUpperCase(String a) {
        return StringUtilRt.toUpperCase(a);
    }

    public static char toLowerCase(char a) {
        return StringUtilRt.toLowerCase(a);
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not be null");
        }
        String string = StringUtilRt.convertLineSeparators(text);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not return null");
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not be null");
        }
        if (newSeparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not be null");
        }
        String string = StringUtilRt.convertLineSeparators(text, newSeparator);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not return null");
        }
        return string;
    }

    @NotNull
    public static String getShortName(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getShortName must not be null");
        }
        String string = StringUtilRt.getShortName(fqName);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getShortName must not return null");
        }
        return string;
    }
}

