/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileEvent
extends EventObject {
    private final VirtualFile myFile;
    private final VirtualFile myParent;
    private final Object myRequestor;
    private final String myFileName;
    private final long myOldModificationStamp;
    private final long myNewModificationStamp;

    public VirtualFileEvent(@Nullable Object requestor, @NotNull VirtualFile file, @NotNull String fileName, @Nullable VirtualFile parent) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileEvent.<init> must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileEvent.<init> must not be null");
        }
        this(requestor, file, fileName, parent, 0L, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public VirtualFileEvent(@Nullable Object requestor, @NotNull VirtualFile file, @Nullable VirtualFile parent, long oldModificationStamp, long l) {
        void newModificationStamp;
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileEvent.<init> must not be null");
        }
        this(requestor, file, file.getName(), parent, oldModificationStamp, (long)newModificationStamp);
    }

    /*
     * WARNING - void declaration
     */
    private VirtualFileEvent(@Nullable Object requestor, @NotNull VirtualFile file, @NotNull String fileName, @Nullable VirtualFile parent, long oldModificationStamp, long l) {
        void newModificationStamp;
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileEvent.<init> must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileEvent.<init> must not be null");
        }
        super(file);
        this.myFile = file;
        this.myFileName = fileName;
        this.myParent = parent;
        this.myRequestor = requestor == null ? file.getUserData(VirtualFile.REQUESTOR_MARKER) : requestor;
        this.myOldModificationStamp = oldModificationStamp;
        this.myNewModificationStamp = newModificationStamp;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFileEvent.getFile must not return null");
        }
        return virtualFile;
    }

    @Nullable
    public VirtualFile getParent() {
        return this.myParent;
    }

    @Nullable
    public Object getRequestor() {
        return this.myRequestor;
    }
}

