/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.CoreJarHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJarFileSystem
extends DeprecatedVirtualFileSystem {
    private final Map<String, CoreJarHandler> myHandlers = new HashMap<String, CoreJarHandler>();

    @Override
    @NotNull
    public String getProtocol() {
        String string = StandardFileSystems.JAR_PROTOCOL;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem.getProtocol must not return null");
        }
        return string;
    }

    @Override
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem.findFileByPath must not be null");
        }
        int separatorIndex = path.indexOf("!/");
        if (separatorIndex < 0) {
            throw new IllegalArgumentException("path in JarFileSystem must contain a separator");
        }
        String localPath = path.substring(0, separatorIndex);
        String pathInJar = path.substring(separatorIndex + 2);
        CoreJarHandler handler = this.getHandler(localPath);
        if (handler == null) {
            return null;
        }
        return handler.findFileByPath(pathInJar);
    }

    @Nullable
    protected CoreJarHandler getHandler(String localPath) {
        CoreJarHandler handler = this.myHandlers.get(localPath);
        if (handler == null) {
            handler = new CoreJarHandler(this, localPath);
            this.myHandlers.put(localPath, handler);
        }
        return handler;
    }

    @Override
    protected void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem.deleteFile must not be null");
        }
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }

    @Override
    protected void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem.renameFile must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem.renameFile must not be null");
        }
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }

    @Override
    protected VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem.createChildFile must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem.createChildFile must not be null");
        }
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }

    @Override
    @NotNull
    protected VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem.createChildDirectory must not be null");
        }
        if (dirName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem.createChildDirectory must not be null");
        }
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }

    @Override
    protected VirtualFile copyFile(Object requestor, @NotNull VirtualFile virtualFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem.copyFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem.copyFile must not be null");
        }
        if (copyName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem.copyFile must not be null");
        }
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }
}

