/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VFileCopyEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final VirtualFile myNewParent;
    private final String myNewChildName;

    public VirtualFile getFile() {
        return this.myFile;
    }

    public VirtualFile getNewParent() {
        return this.myNewParent;
    }

    public String getNewChildName() {
        return this.myNewChildName;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[copy " + this.myFile + " to " + this.myNewParent + " as " + this.myNewChildName + "]";
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent.getFileSystem must not return null");
        }
        return virtualFileSystem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileCopyEvent event = (VFileCopyEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewChildName.equals(event.myNewChildName)) {
            return false;
        }
        return this.myNewParent.equals(event.myNewParent);
    }

    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myNewParent.hashCode();
        result = 31 * result + this.myNewChildName.hashCode();
        return result;
    }
}

