/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VFileCreateEvent
extends VFileEvent {
    private final VirtualFile myParent;
    private final boolean myDirectory;
    private final String myChildName;
    private final boolean myReCreation;
    private VirtualFile myCreatedFile;

    public String getChildName() {
        return this.myChildName;
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[" + (this.myReCreation ? "re" : "") + "create " + (this.myDirectory ? "dir " : "file ") + this.myChildName + " in " + this.myParent.getUrl() + "]";
    }

    public VirtualFile getFile() {
        if (this.myCreatedFile != null) {
            return this.myCreatedFile;
        }
        this.myCreatedFile = this.myParent.findChild(this.myChildName);
        return this.myCreatedFile;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myParent.getFileSystem();
        if (virtualFileSystem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent.getFileSystem must not return null");
        }
        return virtualFileSystem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileCreateEvent event = (VFileCreateEvent)o;
        if (this.myDirectory != event.myDirectory) {
            return false;
        }
        if (!this.myChildName.equals(event.myChildName)) {
            return false;
        }
        if (!this.myParent.equals(event.myParent)) {
            return false;
        }
        return this.myReCreation == event.myReCreation;
    }

    public int hashCode() {
        int result = this.myParent.hashCode();
        result = 31 * result + (this.myDirectory ? 1 : 0);
        result = 31 * result + this.myChildName.hashCode();
        result = 31 * result + (this.myReCreation ? 1 : 0);
        return result;
    }
}

