/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.DebugUtil");
    public static boolean CHECK = false;
    public static final boolean DO_EXPENSIVE_CHECKS;
    public static final boolean CHECK_INSIDE_ATOMIC_ACTION_ENABLED;
    private static final Key<List<Pair<Object, Processor<PsiElement>>>> TRACK_INVALIDATION_KEY;

    public static String psiTreeToString(@NotNull PsiElement element, boolean skipWhitespaces) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.psiTreeToString must not be null");
        }
        ASTNode node = SourceTreeToPsiMap.psiElementToTree(element);
        assert (node != null) : element;
        return DebugUtil.treeToString(node, skipWhitespaces);
    }

    public static String treeToString(@NotNull ASTNode root, boolean skipWhitespaces) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.treeToString must not be null");
        }
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.treeToBuffer(ruler, root, 0, skipWhitespaces, false, false, true);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.treeToBuffer(buffer, root, 0, skipWhitespaces, false, false, true);
        return buffer.toString();
    }

    public static String nodeTreeToString(@NotNull ASTNode root, boolean skipWhitespaces) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.nodeTreeToString must not be null");
        }
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.treeToBuffer(ruler, root, 0, skipWhitespaces, false, false, false);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.treeToBuffer(buffer, root, 0, skipWhitespaces, false, false, false);
        return buffer.toString();
    }

    public static String treeToString(@NotNull ASTNode root, boolean skipWhitespaces, boolean showRanges) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.treeToString must not be null");
        }
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.treeToBuffer(ruler, root, 0, skipWhitespaces, showRanges, false, true);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.treeToBuffer(buffer, root, 0, skipWhitespaces, showRanges, false, true);
        return buffer.toString();
    }

    public static String treeToStringWithUserData(TreeElement root, boolean skipWhitespaces) {
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.treeToBufferWithUserData((Appendable)ruler, root, 0, skipWhitespaces);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.treeToBufferWithUserData((Appendable)buffer, root, 0, skipWhitespaces);
        return buffer.toString();
    }

    public static String treeToStringWithUserData(PsiElement root, boolean skipWhitespaces) {
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.treeToBufferWithUserData((Appendable)ruler, root, 0, skipWhitespaces);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.treeToBufferWithUserData((Appendable)buffer, root, 0, skipWhitespaces);
        return buffer.toString();
    }

    public static void treeToBuffer(@NotNull Appendable buffer, @NotNull ASTNode root, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.treeToBuffer must not be null");
        }
        if (root == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.treeToBuffer must not be null");
        }
        DebugUtil.treeToBuffer(buffer, root, indent, skipWhiteSpaces, showRanges, showChildrenRanges, usePsi, null);
    }

    public static void treeToBuffer(final @NotNull Appendable buffer, @NotNull ASTNode root, final int indent, final boolean skipWhiteSpaces, boolean showRanges, final boolean showChildrenRanges, final boolean usePsi, PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.treeToBuffer must not be null");
        }
        if (root == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.treeToBuffer must not be null");
        }
        if (skipWhiteSpaces && root.getElementType() == TokenType.WHITE_SPACE) {
            return;
        }
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            PsiElement psiElement = null;
            if (root instanceof CompositeElement) {
                if (usePsi) {
                    psiElement = root.getPsi();
                    if (psiElement != null) {
                        buffer.append(((Object)psiElement).toString());
                    } else {
                        buffer.append(root.getElementType().toString());
                    }
                } else {
                    buffer.append(root.toString());
                }
            } else {
                String text = DebugUtil.fixWhiteSpaces(root.getText());
                buffer.append(root.toString()).append("('").append(text).append("')");
            }
            if (showRanges) {
                buffer.append(root.getTextRange().toString());
            }
            buffer.append("\n");
            if (root instanceof CompositeElement) {
                ASTNode child = root.getFirstChildNode();
                if (child == null) {
                    StringUtil.repeatSymbol(buffer, ' ', indent + 2);
                    buffer.append("<empty list>\n");
                } else {
                    while (child != null) {
                        DebugUtil.treeToBuffer(buffer, child, indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges, usePsi, extra);
                        child = child.getTreeNext();
                    }
                }
            }
            if (psiElement != null && extra != null) {
                extra.consume(psiElement, new Consumer<PsiElement>(){

                    @Override
                    public void consume(PsiElement element) {
                        DebugUtil.treeToBuffer(buffer, element.getNode(), indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges, usePsi, null);
                    }
                });
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public static String lightTreeToString(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, boolean skipWhitespaces) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.lightTreeToString must not be null");
        }
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.lightTreeToBuffer(tree, tree.getRoot(), ruler, 0, skipWhitespaces);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.lightTreeToBuffer(tree, tree.getRoot(), buffer, 0, skipWhitespaces);
        return buffer.toString();
    }

    public static void lightTreeToBuffer(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode node, @NotNull Appendable buffer, int indent, boolean skipWhiteSpaces) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.lightTreeToBuffer must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.lightTreeToBuffer must not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.lightTreeToBuffer must not be null");
        }
        IElementType tokenType = node.getTokenType();
        if (skipWhiteSpaces && tokenType == TokenType.WHITE_SPACE) {
            return;
        }
        boolean isLeaf = node instanceof LighterASTTokenNode;
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            if (tokenType == TokenType.ERROR_ELEMENT) {
                buffer.append("PsiErrorElement:").append(PsiBuilderImpl.getErrorMessage(node));
            } else if (tokenType == TokenType.WHITE_SPACE) {
                buffer.append("PsiWhiteSpace");
            } else {
                buffer.append(isLeaf ? "PsiElement" : "Element").append('(').append(tokenType.toString()).append(')');
            }
            if (isLeaf) {
                String text = ((Object)((LighterASTTokenNode)node).getText()).toString();
                buffer.append("('").append(DebugUtil.fixWhiteSpaces(text)).append("')");
            }
            buffer.append('\n');
            if (!isLeaf) {
                Ref<T[]> kids = new Ref<T[]>();
                int numKids = tree.getChildren(tree.prepareForGetChildren(node), kids);
                if (numKids == 0) {
                    StringUtil.repeatSymbol(buffer, ' ', indent + 2);
                    buffer.append("<empty list>\n");
                } else {
                    for (int i = 0; i < numKids; ++i) {
                        DebugUtil.lightTreeToBuffer(tree, ((LighterASTNode[])kids.get())[i], buffer, indent + 2, skipWhiteSpaces);
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public static String stubTreeToString(Stub root) {
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.stubTreeToBuffer(root, ruler, 0);
        StringBuilder builder = new StringBuilder(ruler.getLength());
        DebugUtil.stubTreeToBuffer(root, builder, 0);
        return builder.toString();
    }

    public static void stubTreeToBuffer(Stub node, Appendable buffer, int indent) {
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            ObjectStubSerializer stubType = node.getStubType();
            if (stubType != null) {
                buffer.append(stubType.toString()).append(':');
            }
            buffer.append(node.toString()).append('\n');
            List<? extends Stub> children = node.getChildrenStubs();
            for (Stub stub : children) {
                DebugUtil.stubTreeToBuffer(stub, buffer, indent + 2);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    private static void treeToBufferWithUserData(Appendable buffer, TreeElement root, int indent, boolean skipWhiteSpaces) {
        if (skipWhiteSpaces && root.getElementType() == TokenType.WHITE_SPACE) {
            return;
        }
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            PsiElement psi = SourceTreeToPsiMap.treeElementToPsi(root);
            assert (psi != null) : root;
            if (root instanceof CompositeElement) {
                buffer.append(((Object)psi).toString());
            } else {
                String text = DebugUtil.fixWhiteSpaces(root.getText());
                buffer.append(root.toString()).append("('").append(text).append("')");
            }
            buffer.append(root.getUserDataString());
            buffer.append("\n");
            if (root instanceof CompositeElement) {
                PsiElement[] children;
                for (PsiElement child : children = psi.getChildren()) {
                    DebugUtil.treeToBufferWithUserData(buffer, (TreeElement)SourceTreeToPsiMap.psiElementToTree(child), indent + 2, skipWhiteSpaces);
                }
                if (children.length == 0) {
                    StringUtil.repeatSymbol(buffer, ' ', indent + 2);
                    buffer.append("<empty list>\n");
                }
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    private static void treeToBufferWithUserData(Appendable buffer, PsiElement root, int indent, boolean skipWhiteSpaces) {
        if (skipWhiteSpaces && root instanceof PsiWhiteSpace) {
            return;
        }
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            PsiElement[] children;
            if (root instanceof CompositeElement) {
                buffer.append(((Object)root).toString());
            } else {
                String text = DebugUtil.fixWhiteSpaces(root.getText());
                buffer.append(((Object)root).toString()).append("('").append(text).append("')");
            }
            buffer.append(((UserDataHolderBase)((Object)root)).getUserDataString());
            buffer.append("\n");
            for (PsiElement child : children = root.getChildren()) {
                DebugUtil.treeToBufferWithUserData(buffer, child, indent + 2, skipWhiteSpaces);
            }
            if (children.length == 0) {
                StringUtil.repeatSymbol(buffer, ' ', indent + 2);
                buffer.append("<empty list>\n");
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public static void doCheckTreeStructure(@Nullable ASTNode anyElement) {
        if (anyElement == null) {
            return;
        }
        ASTNode root = anyElement;
        while (root.getTreeParent() != null) {
            root = root.getTreeParent();
        }
        if (root instanceof CompositeElement) {
            DebugUtil.checkSubtree((CompositeElement)root);
        }
    }

    private static void checkSubtree(CompositeElement root) {
        if (root.rawFirstChild() == null) {
            if (root.rawLastChild() != null) {
                throw new IncorrectTreeStructureException(root, "firstChild == null, but lastChild != null");
            }
        } else {
            for (ASTNode child = root.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (child instanceof CompositeElement) {
                    DebugUtil.checkSubtree((CompositeElement)child);
                }
                if (child.getTreeParent() != root) {
                    throw new IncorrectTreeStructureException(child, "child has wrong parent value");
                }
                if (child == root.getFirstChildNode()) {
                    if (child.getTreePrev() != null) {
                        throw new IncorrectTreeStructureException(root, "firstChild.prev != null");
                    }
                } else {
                    if (child.getTreePrev() == null) {
                        throw new IncorrectTreeStructureException(child, "not first child has prev == null");
                    }
                    if (child.getTreePrev().getTreeNext() != child) {
                        throw new IncorrectTreeStructureException(child, "element.prev.next != element");
                    }
                }
                if (child.getTreeNext() != null || root.getLastChildNode() == child) continue;
                throw new IncorrectTreeStructureException(child, "not last child has next == null");
            }
        }
    }

    public static void checkParentChildConsistent(@NotNull ASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.checkParentChildConsistent must not be null");
        }
        ASTNode treeParent = element.getTreeParent();
        if (treeParent == null) {
            return;
        }
        ASTNode[] elements = treeParent.getChildren(null);
        if (ArrayUtil.find(elements, element) == -1) {
            throw new IncorrectTreeStructureException(element, "child cannot be found among parents children");
        }
    }

    public static void checkSameCharTabs(@NotNull ASTNode element1, @NotNull ASTNode element2) {
        CharTable toCharTab;
        if (element1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.checkSameCharTabs must not be null");
        }
        if (element2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.checkSameCharTabs must not be null");
        }
        CharTable fromCharTab = SharedImplUtil.findCharTableByTree(element1);
        LOG.assertTrue(fromCharTab == (toCharTab = SharedImplUtil.findCharTableByTree(element2)));
    }

    public static String psiToString(@NotNull PsiElement element, boolean skipWhitespaces) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.psiToString must not be null");
        }
        return DebugUtil.psiToString(element, skipWhitespaces, false);
    }

    public static String psiToString(@NotNull PsiElement root, boolean skipWhiteSpaces, boolean showRanges) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.psiToString must not be null");
        }
        return DebugUtil.psiToString(root, skipWhiteSpaces, showRanges, null);
    }

    public static String psiToString(@NotNull PsiElement root, boolean skipWhiteSpaces, boolean showRanges, PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.psiToString must not be null");
        }
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.psiToBuffer(ruler, root, skipWhiteSpaces, showRanges, extra);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.psiToBuffer(buffer, root, skipWhiteSpaces, showRanges, extra);
        return buffer.toString();
    }

    private static void psiToBuffer(Appendable buffer, PsiElement root, boolean skipWhiteSpaces, boolean showRanges, PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
        ASTNode node = root.getNode();
        if (node == null) {
            DebugUtil.psiToBuffer(buffer, root, 0, skipWhiteSpaces, showRanges, showRanges, extra);
        } else {
            DebugUtil.treeToBuffer(buffer, node, 0, skipWhiteSpaces, showRanges, showRanges, true, extra);
        }
    }

    public static void psiToBuffer(@NotNull Appendable buffer, @NotNull PsiElement root, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.psiToBuffer must not be null");
        }
        if (root == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.psiToBuffer must not be null");
        }
        DebugUtil.psiToBuffer(buffer, root, indent, skipWhiteSpaces, showRanges, showChildrenRanges, null);
    }

    public static void psiToBuffer(final @NotNull Appendable buffer, @NotNull PsiElement root, final int indent, final boolean skipWhiteSpaces, boolean showRanges, final boolean showChildrenRanges, PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.psiToBuffer must not be null");
        }
        if (root == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.psiToBuffer must not be null");
        }
        if (skipWhiteSpaces && root instanceof PsiWhiteSpace) {
            return;
        }
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            buffer.append(((Object)root).toString());
            PsiElement child = root.getFirstChild();
            if (child == null) {
                String text = root.getText();
                assert (text != null) : "text is null for <" + root + ">";
                buffer.append("('").append(DebugUtil.fixWhiteSpaces(text)).append("')");
            }
            if (showRanges) {
                buffer.append(root.getTextRange().toString());
            }
            buffer.append("\n");
            while (child != null) {
                DebugUtil.psiToBuffer(buffer, child, indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges, extra);
                child = child.getNextSibling();
            }
            if (extra != null) {
                extra.consume(root, new Consumer<PsiElement>(){

                    @Override
                    public void consume(PsiElement element) {
                        DebugUtil.psiToBuffer(buffer, element, indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges, null);
                    }
                });
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public static String fixWhiteSpaces(String text) {
        text = StringUtil.replace(text, "\n", "\\n");
        text = StringUtil.replace(text, "\r", "\\r");
        text = StringUtil.replace(text, "\t", "\\t");
        return text;
    }

    public static String currentStackTrace() {
        return ExceptionUtil.getThrowableText(new Throwable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trackInvalidation(@NotNull PsiElement element, @NotNull Object requestor, @NotNull Processor<PsiElement> callback) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.trackInvalidation must not be null");
        }
        if (requestor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.trackInvalidation must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.trackInvalidation must not be null");
        }
        PsiElement psiElement = element;
        synchronized (psiElement) {
            ASTNode node = element.getNode();
            if (node == null) {
                return;
            }
            List<Pair<Object, Processor<PsiElement>>> callbacks = node.getUserData(TRACK_INVALIDATION_KEY);
            if (callbacks == null) {
                callbacks = new SmartList<Pair<Object, Processor<PsiElement>>>();
                node.putUserData(TRACK_INVALIDATION_KEY, callbacks);
            }
            for (int i = 0; i < callbacks.size(); ++i) {
                Pair<Object, Processor<PsiElement>> pair = callbacks.get(i);
                Object callbackRequestor = pair.first;
                if (!callbackRequestor.equals(requestor)) continue;
                callbacks.set(i, Pair.create(requestor, callback));
                return;
            }
            callbacks.add(Pair.create(requestor, callback));
        }
    }

    public static void onInvalidated(@NotNull TreeElement treeElement) {
        if (treeElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/DebugUtil.onInvalidated must not be null");
        }
        treeElement.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            protected void visitNode(TreeElement element) {
                List callbacks = (List)element.getUserData(TRACK_INVALIDATION_KEY);
                if (callbacks != null) {
                    for (Pair pair : callbacks) {
                        Processor callback = (Processor)pair.second;
                        PsiElement psi = element.getPsi();
                        if (psi == null) continue;
                        callback.process(psi);
                    }
                }
                super.visitNode(element);
            }
        });
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            LOG.error(e);
        }
    }

    public static void checkTreeStructure(ASTNode element) {
        if (CHECK) {
            DebugUtil.doCheckTreeStructure(element);
        }
    }

    static {
        Application application = ApplicationManager.getApplication();
        CHECK_INSIDE_ATOMIC_ACTION_ENABLED = DO_EXPENSIVE_CHECKS = application != null && application.isUnitTestMode();
        TRACK_INVALIDATION_KEY = Key.create("TRACK_INVALIDATION_KEY");
    }

    public static class IncorrectTreeStructureException
    extends RuntimeException {
        private final ASTNode myElement;

        public IncorrectTreeStructureException(ASTNode element, String message) {
            super(message);
            this.myElement = element;
        }

        public ASTNode getElement() {
            return this.myElement;
        }
    }

    public static class LengthBuilder
    implements Appendable {
        private int myLength = 0;

        public int getLength() {
            return this.myLength;
        }

        @Override
        public Appendable append(CharSequence csq) {
            this.myLength += csq.length();
            return this;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) {
            this.myLength += csq.subSequence(start, end).length();
            return this;
        }

        @Override
        public Appendable append(char c) {
            ++this.myLength;
            return this;
        }
    }
}

