/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsMemberImpl;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsMethodImpl
extends ClsMemberImpl<PsiMethodStub>
implements PsiAnnotationMethod {
    private PsiTypeElement myReturnType = null;
    private PsiAnnotationMemberValue myDefaultValue = null;

    public ClsMethodImpl(PsiMethodStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.getChildren(this.getDocComment(), this.getModifierList(), this.getReturnTypeElement(), this.getNameIdentifier(), this.getParameterList(), this.getThrowsList(), this.getDefaultValue());
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    @Override
    public PsiClass getContainingClass() {
        return (PsiClass)this.getParent();
    }

    @Override
    @NotNull
    public PsiMethod[] findSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List<MethodSignatureBackedByPsiMethod> list = PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic(this, checkAccess);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.findSuperMethodSignaturesIncludingStatic must not return null");
        }
        return list;
    }

    @Override
    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod(this);
    }

    @Override
    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findDeepestSuperMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.findDeepestSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(this);
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getHierarchicalMethodSignature must not return null");
        }
        return hierarchicalMethodSignature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiTypeElement getReturnTypeElement() {
        if (this.isConstructor()) {
            return null;
        }
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (this.myReturnType == null) {
                PsiMethodStub stub = (PsiMethodStub)this.getStub();
                String typeText = TypeInfo.createTypeText(stub.getReturnTypeText(false));
                assert (typeText != null) : stub;
                this.myReturnType = new ClsTypeElementImpl(this, typeText, '\u0000');
            }
            return this.myReturnType;
        }
    }

    @Override
    public PsiType getReturnType() {
        PsiTypeElement typeElement = this.getReturnTypeElement();
        return typeElement == null ? null : typeElement.getType();
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = ((PsiMethodStub)this.getStub()).findChildStubByType(JavaStubElementTypes.MODIFIER_LIST).getPsi();
        if (psiModifierList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getModifierList must not return null");
        }
        return psiModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList = ((PsiMethodStub)this.getStub()).findChildStubByType(JavaStubElementTypes.PARAMETER_LIST).getPsi();
        if (psiParameterList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getParameterList must not return null");
        }
        return psiParameterList;
    }

    @Override
    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList psiReferenceList = ((PsiMethodStub)this.getStub()).findChildStubByType(JavaStubElementTypes.THROWS_LIST).getPsi();
        if (psiReferenceList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getThrowsList must not return null");
        }
        return psiReferenceList;
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return ((PsiMethodStub)this.getStub()).findChildStubByType(JavaStubElementTypes.TYPE_PARAMETER_LIST).getPsi();
    }

    @Override
    public PsiCodeBlock getBody() {
        return null;
    }

    @Override
    public boolean isDeprecated() {
        return ((PsiMethodStub)this.getStub()).isDeprecated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiAnnotationMemberValue getDefaultValue() {
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (this.myDefaultValue == null) {
                String text = ((PsiMethodStub)this.getStub()).getDefaultValueText();
                if (text == null || StringUtil.isEmpty(text)) {
                    return null;
                }
                this.myDefaultValue = ClsParsingUtil.createMemberValueFromText(text, this.getManager(), this);
            }
            return this.myDefaultValue;
        }
    }

    @Override
    public boolean isConstructor() {
        return ((PsiMethodStub)this.getStub()).isConstructor();
    }

    @Override
    public boolean isVarArgs() {
        return ((PsiMethodStub)this.getStub()).isVarArgs();
    }

    @Override
    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.getSignature must not be null");
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create(this, substitutor);
        if (methodSignatureBackedByPsiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getSignature must not return null");
        }
        return methodSignatureBackedByPsiMethod;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        PsiAnnotationMemberValue defaultValue;
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.appendMirrorText must not be null");
        }
        ClsMethodImpl.appendText(this.getDocComment(), indentLevel, buffer, "go_to_next_line_and_indent");
        ClsMethodImpl.appendText(this.getModifierList(), indentLevel, buffer, "");
        ClsMethodImpl.appendText(this.getTypeParameterList(), indentLevel, buffer, " ");
        if (!this.isConstructor()) {
            ClsMethodImpl.appendText(this.getReturnTypeElement(), indentLevel, buffer, " ");
        }
        ClsMethodImpl.appendText(this.getNameIdentifier(), indentLevel, buffer, "");
        ClsMethodImpl.appendText(this.getParameterList(), indentLevel, buffer);
        PsiReferenceList throwsList = this.getThrowsList();
        if (throwsList.getReferencedTypes().length > 0) {
            buffer.append(' ');
            ClsMethodImpl.appendText(throwsList, indentLevel, buffer);
        }
        if ((defaultValue = this.getDefaultValue()) != null) {
            buffer.append(" default ");
            ClsMethodImpl.appendText(defaultValue, indentLevel, buffer);
        }
        if (this.hasModifierProperty("abstract") || this.hasModifierProperty("native")) {
            buffer.append(";");
        } else {
            buffer.append(" { /* compiled code */ }");
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiMethod mirror = (PsiMethod)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsMethodImpl.setMirrorIfPresent(this.getDocComment(), mirror.getDocComment());
        ClsMethodImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsMethodImpl.setMirror(this.getTypeParameterList(), mirror.getTypeParameterList());
        if (!this.isConstructor()) {
            ClsMethodImpl.setMirror(this.getReturnTypeElement(), mirror.getReturnTypeElement());
        }
        ClsMethodImpl.setMirror(this.getNameIdentifier(), mirror.getNameIdentifier());
        ClsMethodImpl.setMirror(this.getParameterList(), mirror.getParameterList());
        ClsMethodImpl.setMirror(this.getThrowsList(), mirror.getThrowsList());
        PsiAnnotationMemberValue defaultValue = this.getDefaultValue();
        if (defaultValue != null) {
            assert (mirror instanceof PsiAnnotationMethod) : this;
            ClsMethodImpl.setMirror(defaultValue, ((PsiAnnotationMethod)mirror).getDefaultValue());
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethod(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiParameter[] parameters;
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.processDeclarations must not be null");
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        if (lastParent == null) {
            return true;
        }
        if (!PsiScopesUtil.walkChildrenScopes(this, processor, state, lastParent, place)) {
            return false;
        }
        for (PsiParameter parameter : parameters = this.getParameterList().getParameters()) {
            if (processor.execute(parameter, state)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public PsiMethod getSourceMirrorMethod() {
        PsiClass sourceClassMirror = ((ClsClassImpl)this.getParent()).getSourceMirrorClass();
        if (sourceClassMirror == null) {
            return null;
        }
        for (PsiMethod sourceMethod : sourceClassMirror.findMethodsByName(this.getName(), false)) {
            if (!MethodSignatureUtil.areParametersErasureEqual(this, sourceMethod)) continue;
            return sourceMethod;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement;
        for (ClsCustomNavigationPolicy customNavigationPolicy : Extensions.getExtensions(ClsCustomNavigationPolicy.EP_NAME)) {
            PsiElement navigationElement = customNavigationPolicy.getNavigationElement(this);
            if (navigationElement == null) continue;
            psiElement = navigationElement;
            if (psiElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getNavigationElement must not return null");
            return psiElement;
        }
        PsiMethod method = this.getSourceMirrorMethod();
        psiElement = method != null ? method.getNavigationElement() : this;
        if (psiElement != null) return psiElement;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getNavigationElement must not return null");
    }

    @Override
    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters(this);
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters(this);
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getTypeParameters must not return null");
        }
        return psiTypeParameterArray;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON;
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(methodIcon, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getUseScope must not return null");
        }
        return searchScope;
    }

    @Override
    public PsiType getReturnTypeNoResolve() {
        return this.getReturnType();
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public String toString() {
        return "PsiMethod:" + this.getName();
    }
}

