/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import com.intellij.psi.impl.java.stubs.impl.PsiImportStatementStubImpl;
import com.intellij.psi.impl.source.PsiImportStatementImpl;
import com.intellij.psi.impl.source.PsiImportStaticStatementImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.SourceUtil;
import com.intellij.psi.impl.source.tree.java.ImportStaticStatementElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JavaImportStatementElementType
extends JavaStubElementType<PsiImportStatementStub, PsiImportStatementBase> {
    public JavaImportStatementElementType(@NonNls @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaImportStatementElementType.<init> must not be null");
        }
        super(id);
    }

    @Override
    public PsiImportStatementBase createPsi(@NotNull PsiImportStatementStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaImportStatementElementType.createPsi must not be null");
        }
        return this.getPsiFactory(stub).createImportStatement(stub);
    }

    @Override
    public PsiImportStatementBase createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaImportStatementElementType.createPsi must not be null");
        }
        if (node instanceof ImportStaticStatementElement) {
            return new PsiImportStaticStatementImpl(node);
        }
        return new PsiImportStatementImpl(node);
    }

    @Override
    public PsiImportStatementStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        boolean isOnDemand = false;
        String refText = null;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type = child.getTokenType();
            if (type == JavaElementType.JAVA_CODE_REFERENCE || type == JavaElementType.IMPORT_STATIC_REFERENCE) {
                refText = SourceUtil.getReferenceText(tree, child);
                continue;
            }
            if (type != JavaTokenType.ASTERISK) continue;
            isOnDemand = true;
        }
        byte flags = PsiImportStatementStubImpl.packFlags(isOnDemand, node.getTokenType() == JavaElementType.IMPORT_STATIC_STATEMENT);
        return new PsiImportStatementStubImpl(parentStub, refText, flags);
    }

    @Override
    public void serialize(PsiImportStatementStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeByte(((PsiImportStatementStubImpl)stub).getFlags());
        dataStream.writeName(stub.getImportReferenceText());
    }

    @Override
    public PsiImportStatementStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        byte flags = dataStream.readByte();
        StringRef refText = dataStream.readName();
        return new PsiImportStatementStubImpl(parentStub, refText, flags);
    }

    @Override
    public void indexStub(PsiImportStatementStub stub, IndexSink sink) {
    }
}

