/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;

public class PsiClassReferenceType
extends PsiClassType {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiClassReferenceType");
    private final PsiJavaCodeReferenceElement myReference;

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel langLevel) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassReferenceType.<init> must not be null");
        }
        this(reference, langLevel, PsiClassReferenceType.collectAnnotations(reference));
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel langLevel, @NotNull PsiAnnotation[] annotations) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassReferenceType.<init> must not be null");
        }
        if (annotations == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassReferenceType.<init> must not be null");
        }
        super(langLevel, annotations);
        this.myReference = reference;
    }

    private static PsiAnnotation[] collectAnnotations(PsiJavaCodeReferenceElement reference) {
        SmartList<PsiAnnotation> result = null;
        for (PsiElement child = reference.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiAnnotation)) continue;
            if (result == null) {
                result = new SmartList<PsiAnnotation>();
            }
            result.add((PsiAnnotation)child);
        }
        return result == null ? PsiAnnotation.EMPTY_ARRAY : result.toArray(new PsiAnnotation[result.size()]);
    }

    @Override
    public boolean isValid() {
        return this.myReference.isValid();
    }

    @Override
    public boolean equalsToText(String text) {
        return Comparing.equal(text, this.getCanonicalText());
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myReference.getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.getResolveScope must not return null");
        }
        return globalSearchScope;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel;
        if (this.myLanguageLevel != null) {
            languageLevel = this.myLanguageLevel;
            if (languageLevel == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.getLanguageLevel must not return null");
            return languageLevel;
        }
        languageLevel = PsiUtil.getLanguageLevel(this.myReference);
        if (languageLevel != null) return languageLevel;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.getLanguageLevel must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        PsiClassReferenceType psiClassReferenceType;
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassReferenceType.setLanguageLevel must not be null");
        }
        if (languageLevel.equals((Object)this.myLanguageLevel)) {
            psiClassReferenceType = this;
            if (psiClassReferenceType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.setLanguageLevel must not return null");
            return psiClassReferenceType;
        }
        psiClassReferenceType = new PsiClassReferenceType(this.myReference, languageLevel, this.getAnnotations());
        if (psiClassReferenceType != null) return psiClassReferenceType;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.setLanguageLevel must not return null");
    }

    @Override
    public PsiClass resolve() {
        return this.resolveGenerics().getElement();
    }

    @Override
    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        LOG.assertTrue(this.isValid());
        JavaResolveResult result = this.myReference.advancedResolve(false);
        DelegatingClassResolveResult delegatingClassResolveResult = new DelegatingClassResolveResult(result);
        if (delegatingClassResolveResult == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.resolveGenerics must not return null");
        }
        return delegatingClassResolveResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiClassType rawType() {
        LightClassReference reference;
        PsiClassType psiClassType;
        PsiElement resolved = this.myReference.resolve();
        if (resolved instanceof PsiClass) {
            PsiSubstitutor rawSubstitutor;
            PsiManager manager;
            PsiElementFactory factory;
            PsiClass aClass = (PsiClass)resolved;
            if (!(!PsiUtil.typeParametersIterable(aClass).iterator().hasNext() ? (psiClassType = this) != null : (psiClassType = (factory = JavaPsiFacade.getInstance((manager = this.myReference.getManager()).getProject()).getElementFactory()).createType(aClass, rawSubstitutor = factory.createRawSubstitutor(aClass), this.getLanguageLevel(), this.getAnnotations())) != null)) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.rawType must not return null");
            return psiClassType;
        }
        String qualifiedName = this.myReference.getQualifiedName();
        String name = this.myReference.getReferenceName();
        if (name == null) {
            name = "";
        }
        if ((psiClassType = new PsiClassReferenceType(reference = new LightClassReference(this.myReference.getManager(), name, qualifiedName, this.myReference.getResolveScope()), null, this.getAnnotations())) != null) return psiClassType;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.rawType must not return null");
    }

    @Override
    public String getClassName() {
        return this.myReference.getReferenceName();
    }

    @Override
    @NotNull
    public PsiType[] getParameters() {
        PsiType[] psiTypeArray = this.myReference.getTypeParameters();
        if (psiTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.getParameters must not return null");
        }
        return psiTypeArray;
    }

    public PsiClassType createImmediateCopy() {
        PsiClassType.ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass element = resolveResult.getElement();
        return element != null ? new PsiImmediateClassType(element, resolveResult.getSubstitutor()) : this;
    }

    @Override
    public String getPresentableText() {
        return this.getAnnotationsTextPrefix(false, false, true) + PsiNameHelper.getPresentableText(this.myReference);
    }

    @Override
    public String getCanonicalText() {
        return this.myReference.getCanonicalText();
    }

    @Override
    public String getInternalCanonicalText() {
        return this.getAnnotationsTextPrefix(true, false, true) + this.getCanonicalText();
    }

    @NotNull
    public PsiJavaCodeReferenceElement getReference() {
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = this.myReference;
        if (psiJavaCodeReferenceElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.getReference must not return null");
        }
        return psiJavaCodeReferenceElement;
    }

    private static class DelegatingClassResolveResult
    implements PsiClassType.ClassResolveResult {
        private final JavaResolveResult myDelegate;

        private DelegatingClassResolveResult(JavaResolveResult delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public PsiSubstitutor getSubstitutor() {
            return this.myDelegate.getSubstitutor();
        }

        @Override
        public boolean isValidResult() {
            return this.myDelegate.isValidResult();
        }

        @Override
        public boolean isAccessible() {
            return this.myDelegate.isAccessible();
        }

        @Override
        public boolean isStaticsScopeCorrect() {
            return this.myDelegate.isStaticsScopeCorrect();
        }

        @Override
        public PsiElement getCurrentFileResolveScope() {
            return this.myDelegate.getCurrentFileResolveScope();
        }

        @Override
        public boolean isPackagePrefixPackageReference() {
            return this.myDelegate.isPackagePrefixPackageReference();
        }

        @Override
        public PsiClass getElement() {
            PsiElement element = this.myDelegate.getElement();
            return element instanceof PsiClass ? (PsiClass)element : null;
        }
    }
}

