/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.reference.SoftReference;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveCache {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.ResolveCache");
    private final ConcurrentMap[] myMaps;
    private final RecursionGuard myGuard;
    private static final Getter<ResolveResult[]> EMPTY_POLY_RESULT = new StaticGetter<ResolveResult[]>(ResolveResult.EMPTY_ARRAY);
    private static final Getter<Object> NULL_RESULT = new StaticGetter<Object>(null);

    public static ResolveCache getInstance(Project project) {
        ProgressIndicatorProvider.checkCanceled();
        return ServiceManager.getService(project, ResolveCache.class);
    }

    public ResolveCache(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.<init> must not be null");
        }
        this.myMaps = new ConcurrentMap[8];
        this.myGuard = RecursionManager.createGuard("resolveCache");
        for (int i = 0; i < this.myMaps.length; ++i) {
            this.myMaps[i] = ResolveCache.createWeakMap();
        }
        messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                ResolveCache.this.clearCache(isPhysical);
            }

            @Override
            public void afterPsiChanged(boolean isPhysical) {
            }
        });
    }

    private static <K, V> ConcurrentWeakHashMap<K, V> createWeakMap() {
        return new ConcurrentWeakHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy());
    }

    public void clearCache(boolean isPhysical) {
        int startIndex;
        for (int i = startIndex = isPhysical ? 0 : 1; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    this.myMaps[i * 4 + j * 2 + k].clear();
                }
            }
        }
    }

    @Nullable
    private <TRef extends PsiReference, TResult> TResult resolve(final @NotNull TRef ref, final @NotNull AbstractResolver<TRef, TResult> resolver, boolean needToPreventRecursion, final boolean incompleteCode, boolean isPoly, boolean isPhysical) {
        TResult result;
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolve must not be null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolve must not be null");
        }
        ProgressIndicatorProvider.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ConcurrentMap<TRef, Getter<TResult>> map = this.getMap(isPhysical, incompleteCode, isPoly);
        Getter reference = (Getter)map.get(ref);
        TResult TResult = result = reference == null ? null : (TResult)reference.get();
        if (result != null) {
            return result;
        }
        RecursionGuard.StackStamp stamp = this.myGuard.markStack();
        result = (TResult)(needToPreventRecursion ? this.myGuard.doPreventingRecursion(Trinity.create(ref, incompleteCode, isPoly), true, new Computable<TResult>(){

            @Override
            public TResult compute() {
                return resolver.resolve(ref, incompleteCode);
            }
        }) : resolver.resolve(ref, incompleteCode));
        PsiElement element = result instanceof ResolveResult ? ((ResolveResult)result).getElement() : null;
        LOG.assertTrue(element == null || element.isValid(), result);
        if (stamp.mayCacheNow()) {
            ResolveCache.cache(ref, map, result, isPoly);
        }
        return result;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not be null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not be null");
        }
        ResolveResult[] resolveResultArray = this.resolveWithCaching(ref, resolver, needToPreventRecursion, incompleteCode, ref.getElement().getContainingFile());
        if (resolveResultArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not return null");
        }
        return resolveResultArray;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not be null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not be null");
        }
        if (containingFile == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not be null");
        }
        ResolveResult[] result = (ResolveResult[])this.resolve(ref, resolver, needToPreventRecursion, incompleteCode, true, containingFile.isPhysical());
        ResolveResult[] resolveResultArray = result == null ? ResolveResult.EMPTY_ARRAY : result;
        if (resolveResultArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not return null");
        }
        return resolveResultArray;
    }

    public <T extends PsiPolyVariantReference> boolean isCached(@NotNull T ref, boolean physical, boolean incompleteCode, boolean isPoly) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.isCached must not be null");
        }
        ConcurrentMap map = this.getMap(physical, incompleteCode, isPoly);
        Getter reference = (Getter)map.get(ref);
        return reference != null && reference.get() != null;
    }

    public PsiElement resolveWithCaching(@NotNull PsiReference ref, @NotNull Resolver resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not be null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not be null");
        }
        return this.resolve(ref, resolver, needToPreventRecursion, incompleteCode, false, ref.getElement().isPhysical());
    }

    @Nullable
    public <TRef extends PsiReference, TResult> TResult resolveWithCaching(@NotNull TRef ref, @NotNull AbstractResolver<TRef, TResult> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not be null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not be null");
        }
        return this.resolve(ref, resolver, needToPreventRecursion, incompleteCode, false, ref.getElement().isPhysical());
    }

    private <TRef extends PsiReference, TResult> ConcurrentMap<TRef, Getter<TResult>> getMap(boolean physical, boolean incompleteCode, boolean isPoly) {
        return this.myMaps[(physical ? 0 : 1) * 4 + (incompleteCode ? 0 : 1) * 2 + (isPoly ? 0 : 1)];
    }

    private static <TRef extends PsiReference, TResult> void cache(@NotNull TRef ref, @NotNull ConcurrentMap<TRef, Getter<TResult>> map, TResult result, boolean isPoly) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.cache must not be null");
        }
        if (map == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.cache must not be null");
        }
        Getter<TResult> cached = (StaticGetter<TResult>)map.get(ref);
        if (cached != null && cached.get() == result) {
            return;
        }
        cached = result == null ? NULL_RESULT : (isPoly && ((Object[])result).length == 0 ? (result.getClass() == ResolveResult[].class ? EMPTY_POLY_RESULT : new StaticGetter<TResult>(result)) : new SoftGetter<TResult>(result));
        ConcurrencyUtil.cacheOrGet(map, ref, cached);
    }

    private static class SoftGetter<T>
    extends SoftReference<T>
    implements Getter<T> {
        public SoftGetter(T referent) {
            super(referent);
        }
    }

    public static interface Resolver
    extends AbstractResolver<PsiReference, PsiElement> {
    }

    public static interface PolyVariantResolver<T extends PsiPolyVariantReference>
    extends AbstractResolver<T, ResolveResult[]> {
        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull T var1, boolean var2);
    }

    public static interface AbstractResolver<TRef extends PsiReference, TResult> {
        public TResult resolve(@NotNull TRef var1, boolean var2);
    }
}

