/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.text;

import com.intellij.lang.ASTNode;
import com.intellij.pom.PomManager;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.ReplaceChangeInfoImpl;
import com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import org.jetbrains.annotations.NotNull;

public class ASTDiffBuilder
implements DiffTreeChangeBuilder<ASTNode, ASTNode> {
    private final TreeChangeEventImpl myEvent;

    public ASTDiffBuilder(@NotNull PsiFileImpl fileImpl) {
        if (fileImpl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/ASTDiffBuilder.<init> must not be null");
        }
        TreeAspect modelAspect = PomManager.getModel(fileImpl.getProject()).getModelAspect(TreeAspect.class);
        this.myEvent = new TreeChangeEventImpl(modelAspect, fileImpl.getTreeElement());
    }

    @Override
    public void nodeReplaced(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        if (oldNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/ASTDiffBuilder.nodeReplaced must not be null");
        }
        if (newNode == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/ASTDiffBuilder.nodeReplaced must not be null");
        }
        if (!(oldNode instanceof FileElement) || !(newNode instanceof FileElement)) {
            ReplaceChangeInfoImpl change = new ReplaceChangeInfoImpl(newNode);
            change.setReplaced(oldNode);
            this.myEvent.addElementaryChange(newNode, change);
        }
    }

    @Override
    public void nodeDeleted(@NotNull ASTNode parent, @NotNull ASTNode child) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/ASTDiffBuilder.nodeDeleted must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/ASTDiffBuilder.nodeDeleted must not be null");
        }
        this.myEvent.addElementaryChange(child, ChangeInfoImpl.create((short)1, child));
    }

    @Override
    public void nodeInserted(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
        if (oldParent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/ASTDiffBuilder.nodeInserted must not be null");
        }
        if (newNode == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/ASTDiffBuilder.nodeInserted must not be null");
        }
        this.myEvent.addElementaryChange(newNode, ChangeInfoImpl.create((short)0, newNode));
    }

    @NotNull
    public TreeChangeEventImpl getEvent() {
        TreeChangeEventImpl treeChangeEventImpl = this.myEvent;
        if (treeChangeEventImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/text/ASTDiffBuilder.getEvent must not return null");
        }
        return treeChangeEventImpl;
    }
}

