/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionCache;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyParseablePsiElement
extends LazyParseableElement
implements NavigationItem,
PsiElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.LazyParseablePsiElement");

    public LazyParseablePsiElement(@NotNull IElementType type, CharSequence buffer) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LazyParseablePsiElement.<init> must not be null");
        }
        super(type, buffer);
        this.setPsi(this);
    }

    @Override
    public LazyParseablePsiElement clone() {
        LazyParseablePsiElement clone = (LazyParseablePsiElement)super.clone();
        clone.setPsi(clone);
        return clone;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.getChildrenAsPsiElements(null, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LazyParseablePsiElement.getChildren must not return null");
        }
        return psiElementArray;
    }

    @Nullable
    protected <T> T findChildByClass(Class<T> aClass) {
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!ReflectionCache.isInstance(cur, aClass)) continue;
            return (T)cur;
        }
        return null;
    }

    @NotNull
    protected <T> T[] findChildrenByClass(Class<T> aClass) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!ReflectionCache.isInstance(cur, aClass)) continue;
            result.add(cur);
        }
        Object[] objectArray = result.toArray((Object[])Array.newInstance(aClass, result.size()));
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LazyParseablePsiElement.findChildrenByClass must not return null");
        }
        return objectArray;
    }

    @Override
    public PsiElement getFirstChild() {
        TreeElement child = this.getFirstChildNode();
        if (child == null) {
            return null;
        }
        return child.getPsi();
    }

    @Override
    public PsiElement getLastChild() {
        TreeElement child = this.getLastChildNode();
        if (child == null) {
            return null;
        }
        return child.getPsi();
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LazyParseablePsiElement.acceptChildren must not be null");
        }
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            child.accept(visitor);
        }
    }

    @Override
    public PsiElement getParent() {
        CompositeElement treeParent = this.getTreeParent();
        if (treeParent == null) {
            return null;
        }
        if (treeParent instanceof PsiElement) {
            return (PsiElement)((Object)treeParent);
        }
        return treeParent.getPsi();
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedImplUtil.getNextSibling(this);
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedImplUtil.getPrevSibling(this);
    }

    @Override
    public PsiFile getContainingFile() {
        PsiFile file = SharedImplUtil.getContainingFile(this);
        if (file == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        return file;
    }

    @Override
    public PsiElement findElementAt(int offset) {
        LeafElement leaf = this.findLeafElementAt(offset);
        return SourceTreeToPsiMap.treeElementToPsi(leaf);
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt(this, offset);
    }

    @Override
    public PsiElement copy() {
        ASTNode elementCopy = this.copyElement();
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public boolean isValid() {
        return SharedImplUtil.isValid(this);
    }

    @Override
    public boolean isWritable() {
        return SharedImplUtil.isWritable(this);
    }

    @Override
    public PsiReference getReference() {
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LazyParseablePsiElement.getReferences must not return null");
        }
        return psiReferenceArray;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LazyParseablePsiElement.add must not be null");
        }
        return this.addInnerBefore(element, null);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LazyParseablePsiElement.addBefore must not be null");
        }
        return this.addInnerBefore(element, anchor);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LazyParseablePsiElement.addAfter must not be null");
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        TreeElement treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
        return ChangeUtil.decodeInformation(treeElement).getPsi();
    }

    @Override
    public final void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LazyParseablePsiElement.checkAdd must not be null");
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    public final PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, null, null);
    }

    @Override
    public final PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LazyParseablePsiElement.addRangeBefore must not be null");
        }
        if (last == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/LazyParseablePsiElement.addRangeBefore must not be null");
        }
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
    }

    @Override
    public final PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        LOG.assertTrue(this.getTreeParent() != null, "Parent not found for " + this);
        CheckUtil.checkWritable(this);
        this.getTreeParent().deleteChildInternal(this);
        this.invalidate();
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        LOG.assertTrue(firstElement.getTreeParent() == this);
        LOG.assertTrue(lastElement.getTreeParent() == this);
        CodeEditUtil.removeChildren(this, firstElement, lastElement);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LazyParseablePsiElement.replace must not be null");
        }
        return SharedImplUtil.doReplace(this, this, newElement);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LazyParseablePsiElement.accept must not be null");
        }
        visitor.visitElement(this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LazyParseablePsiElement.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/LazyParseablePsiElement.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/LazyParseablePsiElement.processDeclarations must not be null");
        }
        return true;
    }

    @Override
    public String toString() {
        return "PsiElement(" + this.getElementType().toString() + ")";
    }

    @Override
    public PsiElement getContext() {
        return this.getParent();
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        LazyParseablePsiElement lazyParseablePsiElement = this;
        if (lazyParseablePsiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LazyParseablePsiElement.getNavigationElement must not return null");
        }
        return lazyParseablePsiElement;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public boolean isPhysical() {
        PsiFile file = this.getContainingFile();
        return file != null && file.isPhysical();
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        assert (this.isValid());
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LazyParseablePsiElement.getResolveScope must not return null");
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LazyParseablePsiElement.getUseScope must not return null");
        }
        return globalSearchScope;
    }

    public ItemPresentation getPresentation() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiNavigationSupport.getInstance().getDescriptor(this).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate(this);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        Project project = manager.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LazyParseablePsiElement.getProject must not return null");
        }
        return project;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.getElementType().getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LazyParseablePsiElement.getLanguage must not return null");
        }
        return language;
    }

    @Override
    @NotNull
    public ASTNode getNode() {
        LazyParseablePsiElement lazyParseablePsiElement = this;
        if (lazyParseablePsiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LazyParseablePsiElement.getNode must not return null");
        }
        return lazyParseablePsiElement;
    }

    private PsiElement addInnerBefore(PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        TreeElement treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
        if (treeElement != null) {
            return ChangeUtil.decodeInformation(treeElement).getPsi();
        }
        throw new IncorrectOperationException("Element cannot be added");
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }
}

