/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public abstract class PsiCommaSeparatedListImpl
extends CompositePsiElement
implements Constants {
    private final TokenSet myTypesOfElements;

    protected PsiCommaSeparatedListImpl(IElementType type, TokenSet typeOfElements) {
        super(type);
        this.myTypesOfElements = typeOfElements;
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        if (this.myTypesOfElements.contains(first.getElementType()) && this.myTypesOfElements.contains(last.getElementType())) {
            LeafElement comma;
            ASTNode child;
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
            TreeElement firstAdded = super.addInternal(first, last, anchor, before);
            for (child = first.getTreeNext(); child != null && child.getElementType() != COMMA; child = child.getTreeNext()) {
                if (!this.myTypesOfElements.contains(child.getElementType())) continue;
                comma = Factory.createSingleLeafElement(COMMA, ",", 0, 1, treeCharTab, this.getManager());
                super.addInternal(comma, comma, first, Boolean.FALSE);
                break;
            }
            for (child = first.getTreePrev(); child != null && child.getElementType() != COMMA; child = child.getTreePrev()) {
                if (!this.myTypesOfElements.contains(child.getElementType())) continue;
                comma = Factory.createSingleLeafElement(COMMA, ",", 0, 1, treeCharTab, this.getManager());
                super.addInternal(comma, comma, child, Boolean.FALSE);
                break;
            }
            return firstAdded;
        }
        return super.addInternal(first, last, anchor, before);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiCommaSeparatedListImpl.deleteChildInternal must not be null");
        }
        if (this.myTypesOfElements.contains(child.getElementType())) {
            ASTNode next = PsiImplUtil.skipWhitespaceAndComments(child.getTreeNext());
            if (next != null && next.getElementType() == COMMA) {
                this.deleteChildInternal(next);
            } else {
                ASTNode prev = PsiImplUtil.skipWhitespaceAndCommentsBack(child.getTreePrev());
                if (prev != null && prev.getElementType() == COMMA) {
                    this.deleteChildInternal(prev);
                }
            }
        }
        super.deleteChildInternal(child);
    }
}

