/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.conflictResolvers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DuplicateConflictResolver
implements PsiConflictResolver {
    public static final DuplicateConflictResolver INSTANCE = new DuplicateConflictResolver();

    private DuplicateConflictResolver() {
    }

    @Override
    public CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/scope/conflictResolvers/DuplicateConflictResolver.resolveConflict must not be null");
        }
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        HashMap<Object, CandidateInfo> uniqueItems = new HashMap<Object, CandidateInfo>();
        for (CandidateInfo info : conflicts) {
            PsiElement element = info.getElement();
            Object key = element instanceof PsiMethod ? ((PsiMethod)element).getSignature(info.getSubstitutor()) : PsiUtilCore.getName(element);
            if (uniqueItems.containsKey(key)) continue;
            uniqueItems.put(key, info);
        }
        if (uniqueItems.size() == 1) {
            return (CandidateInfo)uniqueItems.values().iterator().next();
        }
        return null;
    }
}

