/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConflictFilterProcessor
extends FilterScopeProcessor<CandidateInfo>
implements NameHint {
    private final PsiConflictResolver[] myResolvers;
    private JavaResolveResult[] myCachedResult;
    protected String myName;
    protected final PsiElement myPlace;
    protected final PsiFile myPlaceFile;

    public ConflictFilterProcessor(String name, @NotNull ElementFilter filter, @NotNull PsiConflictResolver[] resolvers, @NotNull List<CandidateInfo> container, @NotNull PsiElement place) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/scope/processor/ConflictFilterProcessor.<init> must not be null");
        }
        if (resolvers == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/scope/processor/ConflictFilterProcessor.<init> must not be null");
        }
        if (container == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/scope/processor/ConflictFilterProcessor.<init> must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/psi/scope/processor/ConflictFilterProcessor.<init> must not be null");
        }
        super(filter, container);
        this.myCachedResult = null;
        this.myResolvers = resolvers;
        this.myName = name;
        this.myPlace = place;
        this.myPlaceFile = place.getContainingFile();
    }

    @Override
    public boolean execute(@NotNull PsiElement element, ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/scope/processor/ConflictFilterProcessor.execute must not be null");
        }
        if (this.myCachedResult != null && this.myCachedResult.length == 1 && this.myCachedResult[0].isAccessible()) {
            return false;
        }
        if (this.myName == null || PsiUtil.checkName(element, this.myName, this.myPlace)) {
            return super.execute(element, state);
        }
        return true;
    }

    @Override
    protected void add(PsiElement element, PsiSubstitutor substitutor) {
        this.add(new CandidateInfo(element, substitutor));
    }

    protected void add(CandidateInfo info) {
        this.myCachedResult = null;
        this.myResults.add(info);
    }

    @Override
    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.CHANGE_LEVEL && this.myName != null) {
            this.getResult();
        }
    }

    @NotNull
    public JavaResolveResult[] getResult() {
        if (this.myCachedResult == null) {
            List<CandidateInfo> conflicts = this.getResults();
            for (PsiConflictResolver resolver : this.myResolvers) {
                CandidateInfo candidate = resolver.resolveConflict(conflicts);
                if (candidate == null) continue;
                conflicts.clear();
                conflicts.add(candidate);
                break;
            }
            this.myCachedResult = conflicts.toArray(new JavaResolveResult[conflicts.size()]);
        }
        if (this.myCachedResult == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/scope/processor/ConflictFilterProcessor.getResult must not return null");
        }
        return this.myCachedResult;
    }

    @Override
    public String getName(ResolveState state) {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/scope/processor/ConflictFilterProcessor.getHint must not be null");
        }
        if (hintKey == NameHint.KEY) {
            return (T)(this.myName != null ? this : null);
        }
        return super.getHint(hintKey);
    }
}

