/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignatureBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;

public class MethodSignatureBackedByPsiMethod
extends MethodSignatureBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.MethodSignatureBackedByPsiMethod");
    private final PsiMethod myMethod;
    private final boolean myIsRaw;

    protected MethodSignatureBackedByPsiMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean isRaw, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] methodTypeParameters) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureBackedByPsiMethod.<init> must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureBackedByPsiMethod.<init> must not be null");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/MethodSignatureBackedByPsiMethod.<init> must not be null");
        }
        if (methodTypeParameters == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/psi/util/MethodSignatureBackedByPsiMethod.<init> must not be null");
        }
        super(substitutor, parameterTypes, methodTypeParameters);
        this.myIsRaw = isRaw;
        if (!method.isValid()) {
            LOG.error("Invalid method: " + method, new PsiInvalidElementAccessException(method));
        }
        this.myMethod = method;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myMethod.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureBackedByPsiMethod.getName must not return null");
        }
        return string;
    }

    @Override
    public boolean isRaw() {
        return this.myIsRaw;
    }

    @Override
    public boolean isConstructor() {
        return this.myMethod.isConstructor();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MethodSignatureBackedByPsiMethod && ((MethodSignatureBackedByPsiMethod)o).myMethod == this.myMethod) {
            return true;
        }
        return super.equals(o);
    }

    @NotNull
    public PsiMethod getMethod() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureBackedByPsiMethod.getMethod must not return null");
        }
        return psiMethod;
    }

    public static MethodSignatureBackedByPsiMethod create(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureBackedByPsiMethod.create must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureBackedByPsiMethod.create must not be null");
        }
        return MethodSignatureBackedByPsiMethod.create(method, substitutor, PsiUtil.isRawSubstitutor(method, substitutor));
    }

    public static MethodSignatureBackedByPsiMethod create(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean isRaw) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureBackedByPsiMethod.create must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureBackedByPsiMethod.create must not be null");
        }
        PsiTypeParameter[] methodTypeParameters = method.getTypeParameters();
        if (isRaw) {
            substitutor = JavaPsiFacade.getInstance(method.getProject()).getElementFactory().createRawSubstitutor(substitutor, methodTypeParameters);
            methodTypeParameters = PsiTypeParameter.EMPTY_ARRAY;
        }
        assert (substitutor.isValid());
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiType[] parameterTypes = new PsiType[parameters.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            PsiType type = parameters[i].getType();
            assert (type.isValid());
            parameterTypes[i] = isRaw ? TypeConversionUtil.erasure(substitutor.substitute(type)) : type;
        }
        return new MethodSignatureBackedByPsiMethod(method, substitutor, isRaw, parameterTypes, methodTypeParameters);
    }
}

